/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import reliquary.crafting.conditions.PotionsEnabledCondition;
import reliquary.init.ModItems;

public class PotionEffectsRecipeBuilder {
    private final ShapedRecipeBuilder shapedRecipeBuilder;
    private final List<ICondition> additionalConditions = new ArrayList<ICondition>();
    private final float durationFactor;

    private PotionEffectsRecipeBuilder(ItemLike item, int count, float durationFactor) {
        this.shapedRecipeBuilder = ShapedRecipeBuilder.m_126118_((ItemLike)item, (int)count);
        this.durationFactor = durationFactor;
    }

    public static PotionEffectsRecipeBuilder potionEffectsRecipe(ItemLike item, int count, float durationFactor) {
        return new PotionEffectsRecipeBuilder(item, count, durationFactor);
    }

    public PotionEffectsRecipeBuilder addCondition(ICondition condition) {
        this.additionalConditions.add(condition);
        return this;
    }

    public PotionEffectsRecipeBuilder key(Character symbol, TagKey<Item> tagIn) {
        return this.key(symbol, Ingredient.m_204132_(tagIn));
    }

    public PotionEffectsRecipeBuilder key(Character symbol, ItemLike itemIn) {
        return this.key(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}));
    }

    public PotionEffectsRecipeBuilder key(Character symbol, Ingredient ingredient) {
        this.shapedRecipeBuilder.m_126124_(symbol, ingredient);
        return this;
    }

    public PotionEffectsRecipeBuilder patternLine(String pattern) {
        this.shapedRecipeBuilder.m_126130_(pattern);
        return this;
    }

    public PotionEffectsRecipeBuilder addCriterion(String name, CriterionTriggerInstance criterion) {
        this.shapedRecipeBuilder.m_126132_(name, criterion);
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ConditionalRecipe.Builder builder = ConditionalRecipe.builder().addCondition((ICondition)new PotionsEnabledCondition());
        this.additionalConditions.forEach(arg_0 -> ((ConditionalRecipe.Builder)builder).addCondition(arg_0));
        this.shapedRecipeBuilder.m_176498_(shapedResult -> builder.addRecipe(conditionalConsumer -> conditionalConsumer.accept(new Result(id, (FinishedRecipe)shapedResult, this.durationFactor))));
        builder.build(consumer, id);
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final FinishedRecipe shapedResult;
        private final float durationFactor;

        public Result(ResourceLocation id, FinishedRecipe shapedResult, float durationFactor) {
            this.id = id;
            this.shapedResult = shapedResult;
            this.durationFactor = durationFactor;
        }

        public void m_7917_(JsonObject json) {
            this.shapedResult.m_7917_(json);
            json.addProperty("duration_factor", (Number)Float.valueOf(this.durationFactor));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModItems.POTION_EFFECTS_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

