/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reliquary.items.IceMagusRodItem;
import reliquary.util.NBTHelper;
import reliquary.util.TooltipBuilder;

public class GlacialStaffItem
extends IceMagusRodItem {
    private static final String SNOWBALLS_TAG = "snowballs";
    private static final String BLOCK_LOCATIONS_TAG = "blockLocations";

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack staff, @Nullable Level world, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.charge(this, ".tooltip2", NBTHelper.getInt(SNOWBALLS_TAG, staff));
        if (this.isEnabled(staff)) {
            tooltipBuilder.absorbActive(Items.f_42452_.m_7626_(new ItemStack((ItemLike)Items.f_42452_)).getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity e) {
        if (e instanceof LivingEntity) {
            LivingEntity livingBase = (LivingEntity)e;
            if (NBTHelper.getInt(SNOWBALLS_TAG, stack) >= this.getSnowballCost()) {
                MobEffectInstance slow = new MobEffectInstance(MobEffects.f_19597_, 30, 0);
                MobEffectInstance slownessEffect = livingBase.m_21124_(MobEffects.f_19597_);
                if (slownessEffect != null) {
                    slow = new MobEffectInstance(MobEffects.f_19597_, Math.min(slownessEffect.m_19557_() + 30, 300), Math.min(slownessEffect.m_19564_() + 1, 4));
                }
                ((LivingEntity)e).m_7292_(slow);
                e.m_6469_(DamageSource.m_19344_((Player)player), (float)slow.m_19564_());
                NBTHelper.putInt(SNOWBALLS_TAG, stack, NBTHelper.getInt(SNOWBALLS_TAG, stack) - this.getSnowballCost());
            }
        }
        return super.onLeftClickEntity(stack, player, e);
    }

    @Override
    public void m_6883_(ItemStack staff, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(staff, world, entity, itemSlot, isSelected);
        if (world.m_46467_() % 2L != 0L) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.isEnabled(staff)) {
            this.freezeBlocks(staff, world, player);
        }
        this.meltBlocks(staff, world, player);
    }

    private void freezeBlocks(ItemStack staff, Level world, Player player) {
        BlockPos playerPos = player.m_20183_();
        BlockPos.m_121940_((BlockPos)playerPos.m_7918_(-2, -1, -2), (BlockPos)playerPos.m_7918_(2, -1, 2)).forEach(pos -> {
            if (Math.abs(playerPos.m_123341_() - pos.m_123341_()) == 2 && Math.abs(playerPos.m_123343_() - pos.m_123343_()) == 2) {
                return;
            }
            this.doFreezeCheck(staff, (BlockPos)pos, world);
        });
    }

    private void meltBlocks(ItemStack staff, Level world, Player player) {
        if (!world.f_46443_) {
            BlockPos playerPos = player.m_20183_();
            for (BlockPos pos : this.getBlockLocations(staff)) {
                int xOff = Math.abs(playerPos.m_123341_() - pos.m_123341_());
                int yOff = Math.abs(playerPos.m_123342_() - pos.m_123342_());
                int zOff = Math.abs(playerPos.m_123343_() - pos.m_123343_());
                if (xOff < 3 && yOff < 3 && zOff < 3 && (xOff != 2 || zOff != 2)) continue;
                this.doThawCheck(staff, pos, world);
            }
        }
    }

    private Set<BlockPos> getBlockLocations(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            tagCompound = new CompoundTag();
        }
        HashSet<BlockPos> locations = new HashSet<BlockPos>();
        tagCompound.m_128437_(BLOCK_LOCATIONS_TAG, 4).forEach(nbt -> locations.add(BlockPos.m_122022_((long)((LongTag)nbt).m_7046_())));
        return locations;
    }

    private void doFreezeCheck(ItemStack stack, BlockPos pos, Level world) {
        block3: {
            BlockState blockState;
            block2: {
                blockState = world.m_8055_(pos);
                if (blockState.m_60734_() != Blocks.f_49990_ || (Integer)blockState.m_61143_((Property)LiquidBlock.f_54688_) != 0 || !world.m_46859_(pos.m_7494_())) break block2;
                this.addFrozenBlockToList(stack, pos);
                world.m_46597_(pos, Blocks.f_50354_.m_49966_());
                for (int particleNum = world.f_46441_.m_188503_(3); particleNum < 2; ++particleNum) {
                    float xVel = world.f_46441_.m_188501_();
                    float yVel = world.f_46441_.m_188501_() + 0.5f;
                    float zVel = world.f_46441_.m_188501_();
                    world.m_7106_((ParticleOptions)ICE_PARTICLE, (double)((float)pos.m_123341_() + xVel), (double)((float)pos.m_123342_() + yVel), (double)((float)pos.m_123343_() + zVel), 0.75, 0.75, 1.0);
                }
                break block3;
            }
            if (blockState.m_60734_() != Blocks.f_49991_ || (Integer)blockState.m_61143_((Property)LiquidBlock.f_54688_) != 0) break block3;
            this.addFrozenBlockToList(stack, pos);
            world.m_46597_(pos, Blocks.f_50080_.m_49966_());
            for (int particleNum = world.f_46441_.m_188503_(3); particleNum < 2; ++particleNum) {
                float xVel = world.f_46441_.m_188501_();
                float yVel = world.f_46441_.m_188501_() + 0.5f;
                float zVel = world.f_46441_.m_188501_();
                world.m_7106_((ParticleOptions)(world.f_46441_.m_188503_(3) == 0 ? ParticleTypes.f_123755_ : ParticleTypes.f_123762_), (double)((float)pos.m_123341_() + xVel), (double)((float)pos.m_123342_() + yVel), (double)((float)pos.m_123343_() + zVel), 0.0, 0.2, 0.0);
            }
        }
    }

    private void doThawCheck(ItemStack stack, BlockPos pos, Level world) {
        block4: {
            BlockState blockState;
            block3: {
                blockState = world.m_8055_(pos);
                if (blockState != Blocks.f_50354_.m_49966_()) break block3;
                if (!this.removeFrozenBlockFromList(stack, pos)) break block4;
                world.m_46597_(pos, Blocks.f_49990_.m_49966_());
                for (int particleNum = world.f_46441_.m_188503_(3); particleNum < 2; ++particleNum) {
                    float xVel = world.f_46441_.m_188501_();
                    float yVel = world.f_46441_.m_188501_() + 0.5f;
                    float zVel = world.f_46441_.m_188501_();
                    world.m_7106_((ParticleOptions)(world.f_46441_.m_188503_(3) == 0 ? ParticleTypes.f_123755_ : ParticleTypes.f_123762_), (double)((float)pos.m_123341_() + xVel), (double)((float)pos.m_123342_() + yVel), (double)((float)pos.m_123343_() + zVel), 0.0, 0.2, 0.0);
                }
                break block4;
            }
            if (blockState == Blocks.f_50080_.m_49966_() && this.removeFrozenBlockFromList(stack, pos)) {
                world.m_46597_(pos, Blocks.f_49991_.m_49966_());
                for (int particleNum = world.f_46441_.m_188503_(3); particleNum < 2; ++particleNum) {
                    float xVel = world.f_46441_.m_188501_();
                    float yVel = world.f_46441_.m_188501_() + 0.5f;
                    float zVel = world.f_46441_.m_188501_();
                    world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)((float)pos.m_123341_() + xVel), (double)((float)pos.m_123342_() + yVel), (double)((float)pos.m_123343_() + zVel), 0.0, (double)0.2f, 0.0);
                }
            }
        }
    }

    private void addFrozenBlockToList(ItemStack stack, BlockPos pos) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            tagCompound = new CompoundTag();
        }
        ListTag tagList = tagCompound.m_128437_(BLOCK_LOCATIONS_TAG, 4);
        tagList.add((Object)LongTag.m_128882_((long)pos.m_121878_()));
        tagCompound.m_128365_(BLOCK_LOCATIONS_TAG, (Tag)tagList);
        stack.m_41751_(tagCompound);
    }

    private boolean removeFrozenBlockFromList(ItemStack stack, BlockPos pos) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            tagCompound = new CompoundTag();
        }
        ListTag tagList = tagCompound.m_128437_(BLOCK_LOCATIONS_TAG, 4);
        Iterator it = tagList.iterator();
        boolean removedBlock = false;
        while (it.hasNext()) {
            LongTag nbtPos = (LongTag)it.next();
            if (nbtPos.m_7046_() != pos.m_121878_()) continue;
            it.remove();
            removedBlock = true;
        }
        if (removedBlock) {
            tagCompound.m_128365_(BLOCK_LOCATIONS_TAG, (Tag)tagList);
            stack.m_41751_(tagCompound);
        }
        return removedBlock;
    }
}

