/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.crafting.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolsbase.modules.crafting.CraftingModule;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardContainer;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardItem;
import mcjty.rftoolsbase.modules.crafting.network.PacketItemNBTToServer;
import mcjty.rftoolsbase.setup.RFToolsBaseMessages;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class GuiCraftingCard
extends GenericGuiContainer<GenericTileEntity, CraftingCardContainer> {
    public static final int WIDTH = 180;
    public static final int HEIGHT = 198;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsbase", "textures/gui/craftingcard.png");
    private final BlockRender[] slots = new BlockRender[21];

    public GuiCraftingCard(CraftingCardContainer container, Inventory inventory) {
        super(null, (AbstractContainerMenu)container, inventory, CraftingCardItem.MANUAL);
        this.f_97726_ = 180;
        this.f_97727_ = 198;
    }

    public static void register() {
        MenuScreens.m_96206_((MenuType)((MenuType)CraftingModule.CONTAINER_CRAFTING_CARD.get()), GuiCraftingCard::createCraftingCardGui);
    }

    @Nonnull
    private static GuiCraftingCard createCraftingCardGui(CraftingCardContainer container, Inventory inventory, Component textComponent) {
        return new GuiCraftingCard(container, inventory);
    }

    public void m_7856_() {
        super.m_7856_();
        Panel toplevel = (Panel)Widgets.positional().background(iconLocation);
        toplevel.bounds(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        toplevel.children(new Widget[]{((Label)Widgets.label((String)"Regular 3x3 crafting recipe").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).hint(10, 4, 160, 14)});
        toplevel.children(new Widget[]{((Label)Widgets.label((String)"or more complicated recipes").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).hint(10, 17, 160, 14)});
        toplevel.children(new Widget[]{((Button)Widgets.button((int)110, (int)57, (int)60, (int)14, (String)"Update").tooltips(new String[]{"Update the item in the output", "slot to the recipe in the", "3x3 grid"})).event(() -> RFToolsBaseMessages.INSTANCE.sendToServer((Object)new PacketSendServerCommand("rftoolsbase", "testRecipe", TypedMap.EMPTY)))});
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 5; ++x) {
                int idx = y * 5 + x;
                this.createDummySlot(toplevel, idx, new PositionalLayout.PositionalHint(x * 18 + 10, y * 18 + 37, 18, 18), this.createSelectionEvent(idx));
            }
        }
        this.createDummySlot(toplevel, 20, new PositionalLayout.PositionalHint(154, 37, 18, 18), this.createSelectionEvent(20));
        this.updateSlots();
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void createDummySlot(Panel toplevel, final int idx, PositionalLayout.PositionalHint hint, BlockRenderEvent selectionEvent) {
        this.slots[idx] = (BlockRender)new BlockRender(){

            public List<String> getTooltips() {
                Object s = GuiCraftingCard.this.slots[idx].getRenderItem();
                if (s instanceof ItemStack) {
                    ItemStack stack = (ItemStack)s;
                    if (!stack.m_41619_()) {
                        TooltipFlag.Default flag = this.mc.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
                        List list = stack.m_41651_((Player)this.mc.f_91074_, (TooltipFlag)flag);
                        for (int i = 0; i < list.size(); ++i) {
                        }
                        return list.stream().map(Component::getString).collect(Collectors.toList());
                    }
                    return Collections.emptyList();
                }
                return Collections.emptyList();
            }
        }.hilightOnHover(true).hint((LayoutHint)hint);
        this.slots[idx].event(selectionEvent);
        toplevel.children(new Widget[]{this.slots[idx]});
    }

    private void updateSlots() {
        ItemStackList stacks = this.getStacks();
        if (stacks.isEmpty()) {
            return;
        }
        for (int i = 0; i < stacks.size(); ++i) {
            this.slots[i].renderItem(stacks.get(i));
        }
    }

    @Nonnull
    private ItemStackList getStacks() {
        ItemStack cardItem = this.f_96541_.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        ItemStackList stacks = ItemStackList.EMPTY;
        if (!cardItem.m_41619_() && cardItem.m_41720_() instanceof CraftingCardItem) {
            stacks = CraftingCardItem.getStacksFromItem(cardItem);
        }
        return stacks;
    }

    private BlockRenderEvent createSelectionEvent(final int idx) {
        return new BlockRenderEvent(){

            public void select() {
                ItemStack itemstack = ((CraftingCardContainer)GuiCraftingCard.this.f_97732_).m_142621_();
                GuiCraftingCard.this.slots[idx].renderItem((Object)itemstack);
                ItemStackList stacks = GuiCraftingCard.this.getStacks();
                if (!stacks.isEmpty()) {
                    stacks.set(idx, (Object)itemstack);
                    ItemStack cardItem = ((GuiCraftingCard)GuiCraftingCard.this).f_96541_.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
                    CraftingCardItem.putStacksInItem(cardItem, stacks);
                    RFToolsBaseMessages.INSTANCE.sendToServer((Object)new PacketItemNBTToServer(cardItem.m_41783_()));
                }
            }

            public void doubleClick() {
            }
        };
    }

    protected void m_7286_(@Nonnull PoseStack matrixStack, float partialTicks, int x, int y) {
        this.updateSlots();
        this.drawWindow(matrixStack);
    }
}

