/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.state;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Arrays;
import me.jellysquid.mods.sodium.client.gl.array.GlVertexArray;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBufferTarget;

public class GlStateTracker {
    private static final int UNASSIGNED_HANDLE = -1;
    private final int[] bufferState = new int[GlBufferTarget.COUNT];
    private final int[] bufferRestoreState = new int[GlBufferTarget.COUNT];
    private int vertexArrayState;
    private int vertexArrayRestoreState;

    public GlStateTracker() {
        this.reset();
    }

    public void notifyVertexArrayDeleted(GlVertexArray vertexArray) {
        if (this.vertexArrayState == vertexArray.handle()) {
            this.vertexArrayState = -1;
        }
    }

    public void notifyBufferDeleted(GlBuffer buffer) {
        for (GlBufferTarget target : GlBufferTarget.VALUES) {
            if (this.bufferState[target.ordinal()] != buffer.handle()) continue;
            this.bufferState[target.ordinal()] = -1;
        }
    }

    public boolean makeBufferActive(GlBufferTarget target, GlBuffer buffer) {
        boolean changed;
        boolean bl = changed = this.bufferState[target.ordinal()] != buffer.handle();
        if (changed) {
            this.bufferState[target.ordinal()] = buffer.handle();
        }
        return changed;
    }

    public boolean makeVertexArrayActive(GlVertexArray array) {
        boolean changed;
        if (this.vertexArrayRestoreState == -1) {
            this.vertexArrayRestoreState = GlStateManager.m_84092_((int)34229);
        }
        int handle = array == null ? 0 : array.handle();
        boolean bl = changed = this.vertexArrayState != handle;
        if (changed) {
            this.vertexArrayState = handle;
            Arrays.fill(this.bufferState, -1);
        }
        return changed;
    }

    public void pop() {
        if (this.vertexArrayRestoreState != -1 && this.vertexArrayState != this.vertexArrayRestoreState) {
            GlStateManager.m_157068_((int)this.vertexArrayRestoreState);
        }
        for (int i = 0; i < GlBufferTarget.COUNT; ++i) {
            if (this.bufferRestoreState[i] == -1 || this.bufferRestoreState[i] == this.bufferState[i]) continue;
            GlStateManager.m_84480_((int)GlBufferTarget.VALUES[i].getTargetParameter(), (int)this.bufferRestoreState[i]);
        }
        this.reset();
    }

    public void reset() {
        Arrays.fill(this.bufferState, -1);
        Arrays.fill(this.bufferRestoreState, -1);
        this.vertexArrayState = -1;
        this.vertexArrayRestoreState = -1;
    }

    public void push() {
        for (GlBufferTarget target : GlBufferTarget.VALUES) {
            this.bufferRestoreState[target.ordinal()] = GlStateManager.m_84092_((int)target.getBindingParameter());
        }
    }
}

