/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GearNamePrefixesEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.crafting.ingredient.IGearIngredient;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearGenerator;
import net.silentchaos512.gear.util.TimedEvents;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.advancements.LibTriggers;
import org.apache.commons.compress.utils.Lists;

public final class GearHelper {
    public static final ResourceLocation DAMAGE_FACTOR_CHANGE = SilentGear.getId("damage_factor_change");
    public static Tiers DEFAULT_DUMMY_TIER = Tiers.WOOD;
    public static ArmorMaterials DEFAULT_DUMMY_ARMOR_MATERIAL = ArmorMaterials.LEATHER;
    private static final UUID REACH_MODIFIER_UUID = UUID.fromString("5e889b20-a8bd-43df-9ece-88a9f9be7530");
    private static final float BROKEN_ATTACK_SPEED_CHANGE = 0.7f;
    private static final float BROKEN_DESTROY_SPEED = 0.25f;

    private GearHelper() {
    }

    public static Optional<ICoreItem> getItem(ItemStack gear) {
        if (gear.m_41720_() instanceof ICoreItem) {
            return Optional.of((ICoreItem)gear.m_41720_());
        }
        return Optional.empty();
    }

    public static boolean isGear(ItemStack stack) {
        return stack.m_41720_() instanceof ICoreItem;
    }

    public static boolean isValidGear(ItemStack stack) {
        if (!GearHelper.isGear(stack)) {
            return false;
        }
        ICoreItem item = (ICoreItem)stack.m_41720_();
        for (PartType type : item.getRequiredParts()) {
            if (GearData.hasPartOfType(stack, type)) continue;
            return false;
        }
        return true;
    }

    public static float getMeleeDamageModifier(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 1.0f;
        }
        float val = GearData.getStat(stack, ItemStats.MELEE_DAMAGE);
        return val < 0.0f ? 0.0f : val;
    }

    public static float getMagicDamageModifier(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0f;
        }
        float val = GearData.getStat(stack, ItemStats.MAGIC_DAMAGE);
        return val < 0.0f ? 0.0f : val;
    }

    public static float getAttackSpeedModifier(ItemStack stack) {
        if (!(stack.m_41720_() instanceof ICoreTool)) {
            return 0.0f;
        }
        float speed = GearData.getStat(stack, ItemStats.ATTACK_SPEED);
        if (GearHelper.isBroken(stack)) {
            speed += 0.7f;
        }
        return speed;
    }

    public static Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack, true);
    }

    public static Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack, boolean addStandardMainHandMods) {
        LinkedHashMultimap map = LinkedHashMultimap.create((Multimap)stack.m_41720_().m_7167_(slot));
        return GearHelper.getAttributeModifiers(slot, stack, (Multimap<Attribute, AttributeModifier>)map, addStandardMainHandMods);
    }

    public static Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map) {
        return GearHelper.getAttributeModifiers(slot, stack, map, true);
    }

    public static Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map, boolean addStandardMainHandMods) {
        return GearHelper.getAttributeModifiers(slot.m_20751_(), stack, map, addStandardMainHandMods);
    }

    public static Multimap<Attribute, AttributeModifier> getAttributeModifiers(String slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map, boolean addStandardMainHandMods) {
        if (addStandardMainHandMods && GearHelper.isValidSlot(stack, slot) && slot.equals(EquipmentSlot.MAINHAND.m_20751_())) {
            GearHelper.replaceAttributeModifierInMap(map, Attributes.f_22281_, GearHelper.getMeleeDamageModifier(stack));
            GearHelper.replaceAttributeModifierInMap(map, Attributes.f_22283_, GearHelper.getAttackSpeedModifier(stack));
            ForgeMod.REACH_DISTANCE.ifPresent(attr -> {
                float reachStat = GearData.getStat(stack, ItemStats.REACH_DISTANCE, false);
                AttributeModifier mod = new AttributeModifier(REACH_MODIFIER_UUID, "Gear reach", (double)reachStat, AttributeModifier.Operation.ADDITION);
                map.put(attr, (Object)mod);
            });
        }
        TraitHelper.getCachedTraits(stack).forEach((trait, level) -> trait.onGetAttributeModifiers(new TraitActionContext(null, (int)level, stack), map, slot));
        return map;
    }

    private static void replaceAttributeModifierInMap(Multimap<Attribute, AttributeModifier> map, Attribute key, float value) {
        Iterator iter;
        if (map.containsKey((Object)key) && (iter = map.get((Object)key).iterator()).hasNext()) {
            AttributeModifier mod = (AttributeModifier)iter.next();
            map.removeAll((Object)key);
            map.put((Object)key, (Object)new AttributeModifier(mod.m_22209_(), mod.m_22214_(), (double)value, mod.m_22217_()));
        }
    }

    public static boolean isValidSlot(ItemStack gear, String slot) {
        if (gear.m_41720_() instanceof ICoreItem) {
            return ((ICoreItem)gear.m_41720_()).isValidSlot(slot);
        }
        return false;
    }

    public static boolean getIsRepairable(ItemStack stack, ItemStack materialItem) {
        MaterialInstance material = MaterialInstance.from(materialItem);
        return material != null && GearHelper.getIsRepairable(stack, material);
    }

    public static boolean getIsRepairable(ItemStack gear, MaterialInstance material) {
        PartData part = GearData.getPrimaryPart(gear);
        return part != null && material.getTier(PartType.MAIN) >= part.getTier() && material.getRepairValue(gear) > 0;
    }

    public static ItemStat getDurabilityStat(ItemStack gear) {
        return GearHelper.getItem(gear).map(ICoreItem::getDurabilityStat).orElse(ItemStats.DURABILITY);
    }

    public static float getRepairModifier(ItemStack gear) {
        return GearHelper.getItem(gear).map(item -> Float.valueOf(item.getRepairModifier(gear))).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public static void attemptDamage(ItemStack stack, int amount, @Nullable LivingEntity entity, InteractionHand hand) {
        GearHelper.attemptDamage(stack, amount, entity, hand == InteractionHand.OFF_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND);
    }

    public static void attemptDamage(ItemStack stack, int amount, @Nullable LivingEntity entity, EquipmentSlot slot) {
        if (GearHelper.isUnbreakable(stack) || entity instanceof Player && ((Player)entity).m_150110_().f_35937_) {
            return;
        }
        ServerPlayer player = entity instanceof ServerPlayer ? (ServerPlayer)entity : null;
        int preTraitAmount = amount;
        amount = (int)TraitHelper.activateTraits(stack, preTraitAmount, (trait, level, val) -> trait.onDurabilityDamage(new TraitActionContext((Player)player, level, stack), (int)val));
        int maxDamage = stack.m_41776_();
        int preDamageFactor = GearHelper.getDamageFactor(stack, maxDamage);
        if (!GearHelper.canBreakPermanently(stack)) {
            amount = Math.min(maxDamage - stack.m_41773_(), amount);
        }
        stack.m_220157_(amount, SilentGear.RANDOM_SOURCE, player);
        if (GearHelper.getDamageFactor(stack, maxDamage) != preDamageFactor) {
            GearData.recalculateStats(stack, (Player)player);
            if (player != null) {
                GearHelper.onDamageFactorChange(player, preDamageFactor, GearHelper.getDamageFactor(stack, maxDamage));
            }
        }
        GearHelper.handleBrokenItem(stack, (Player)player, slot);
    }

    private static void handleBrokenItem(ItemStack stack, @Nullable Player player, EquipmentSlot slot) {
        if (GearHelper.isBroken(stack)) {
            GearHelper.onBroken(stack, player, slot);
        } else if (GearHelper.canBreakPermanently(stack) && stack.m_41773_() > stack.m_41776_()) {
            if (player != null) {
                player.m_21166_(slot);
            }
            stack.m_41774_(1);
        }
    }

    public static void onBroken(ItemStack stack, @Nullable Player player, EquipmentSlot slot) {
        GearData.incrementBrokenCount(stack);
        GearData.recalculateStats(stack, player);
        if (player != null) {
            player.m_21166_(slot);
            GearHelper.notifyPlayerOfBrokenGear(stack, player);
        }
    }

    public static InteractionResult useAndCheckBroken(UseOnContext context, Function<UseOnContext, InteractionResult> useFunction) {
        InteractionResult result = useFunction.apply(context);
        if (context.m_43723_() instanceof ServerPlayer) {
            GearHelper.handleBrokenItem(context.m_43722_(), context.m_43723_(), context.m_43724_() == InteractionHand.OFF_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND);
        }
        return result;
    }

    private static void onDamageFactorChange(ServerPlayer player, int preDamageFactor, int newDamageFactor) {
        if (newDamageFactor > preDamageFactor) {
            if (((Boolean)Config.Client.playKachinkSound.get()).booleanValue()) {
                player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 0.5f, 2.0f);
            }
            LibTriggers.GENERIC_INT.trigger(player, DAMAGE_FACTOR_CHANGE, 1);
        }
    }

    private static void notifyPlayerOfBrokenGear(ItemStack stack, Player player) {
        if (((Boolean)Config.Common.sendGearBrokenMessage.get()).booleanValue()) {
            player.m_213846_((Component)Component.m_237110_((String)"misc.silentgear.notifyOnBreak", (Object[])new Object[]{stack.m_41786_()}));
        }
    }

    private static int getDamageFactor(ItemStack stack, int maxDamage) {
        if (maxDamage == 0) {
            return 1;
        }
        int levels = (Integer)Config.Common.damageFactorLevels.get();
        int step = Math.max(1, maxDamage / (levels < 1 ? 10 : levels));
        return stack.m_41773_() / step;
    }

    public static int calcDamageClamped(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return 0;
        }
        if (!GearHelper.canBreakPermanently(stack)) {
            damage = damage > stack.m_41773_() ? Math.min(stack.m_41776_(), damage) : Math.max(0, damage);
        }
        return damage;
    }

    private static boolean canBreakPermanently(ItemStack stack) {
        return Config.Common.isLoaded() && (Boolean)Config.Common.gearBreaksPermanently.get() != false || TraitHelper.hasTrait(stack, Const.Traits.RED_CARD);
    }

    public static boolean isBroken(ItemStack stack) {
        if (stack.m_41619_() || GearHelper.canBreakPermanently(stack) || GearHelper.isUnbreakable(stack)) {
            return false;
        }
        int maxDamage = stack.m_41776_();
        return maxDamage > 0 && stack.m_41773_() >= maxDamage - 1;
    }

    public static boolean isUnbreakable(ItemStack stack) {
        return TraitHelper.getTraitLevel(stack, Const.Traits.INDESTRUCTIBLE) > 0;
    }

    public static void setDamage(ItemStack stack, int damage, BiConsumer<ItemStack, Integer> superFunction) {
        boolean alreadyBroken = GearHelper.isBroken(stack);
        int newDamage = GearHelper.calcDamageClamped(stack, damage);
        int diff = newDamage - stack.m_41773_();
        if (diff > 0 && !GearHelper.isBroken(stack)) {
            GearHelper.damageParts(stack, diff);
        }
        superFunction.accept(stack, newDamage);
        if (!alreadyBroken && GearHelper.isBroken(stack)) {
            GearData.recalculateStats(stack, null);
        }
    }

    public static <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int preTraitValue;
        if (GearHelper.isUnbreakable(stack)) {
            preTraitValue = 0;
        } else if (!Config.Common.isLoaded() || !((Boolean)Config.Common.gearBreaksPermanently.get()).booleanValue()) {
            preTraitValue = Mth.m_14045_((int)amount, (int)0, (int)(stack.m_41776_() - stack.m_41773_() - 1));
            if (!GearHelper.isBroken(stack) && stack.m_41773_() + preTraitValue >= stack.m_41776_() - 1) {
                onBroken.accept(entity);
            }
        } else {
            preTraitValue = amount;
        }
        int value = (int)TraitHelper.activateTraits(stack, preTraitValue, (trait, level, val) -> trait.onDurabilityDamage(new TraitActionContext(null, level, stack), (int)val));
        GearHelper.damageParts(stack, value);
        return value;
    }

    private static void damageParts(ItemStack stack, int amount) {
        GearData.getConstructionParts(stack).forEach(p -> p.get().onGearDamaged((PartData)p, stack, amount));
    }

    public static Item.Properties getBaseItemProperties() {
        return new Item.Properties().m_41487_(1).m_41503_(100).m_41491_(SilentGear.ITEM_GROUP);
    }

    public static GearType getType(ItemStack gear) {
        return GearHelper.getType(gear, GearType.NONE);
    }

    public static GearType getType(ItemStack gear, GearType defaultType) {
        if (gear.m_41619_() || !(gear.m_41720_() instanceof ICoreItem)) {
            return defaultType;
        }
        return ((ICoreItem)gear.m_41720_()).getGearType();
    }

    public static boolean isEquivalent(ItemStack gear1, ItemStack gear2) {
        if (!GearHelper.isGear(gear1) || !GearHelper.isGear(gear2) || gear1.m_41720_() != gear2.m_41720_()) {
            return false;
        }
        PartDataList parts1 = GearData.getConstructionParts(gear1);
        PartDataList parts2 = GearData.getConstructionParts(gear2);
        if (parts1.size() != parts2.size()) {
            return false;
        }
        if (parts1.isEmpty()) {
            return true;
        }
        block0: for (PartData part1 : parts1) {
            for (PartData part2 : parts2) {
                if (!part1.equals(part2)) continue;
                parts2.remove(part2);
                continue block0;
            }
        }
        return parts2.isEmpty();
    }

    public static int getHarvestLevel(ItemStack stack, @Nullable BlockState state) {
        if (GearHelper.isBroken(stack)) {
            return -1;
        }
        return GearData.getStatInt(stack, ItemStats.HARVEST_LEVEL);
    }

    @Nullable
    public static Tier getTier(ItemStack stack) {
        switch (GearHelper.getHarvestLevel(stack, null)) {
            case -1: {
                return null;
            }
            case 0: {
                return Tiers.WOOD;
            }
            case 1: {
                return Tiers.STONE;
            }
            case 2: {
                return Tiers.IRON;
            }
            case 3: {
                return Tiers.DIAMOND;
            }
            case 4: {
                return Tiers.NETHERITE;
            }
        }
        return Tiers.NETHERITE;
    }

    public static boolean isCorrectToolForDrops(ItemStack stack, BlockState state, @Nullable TagKey<Block> blocksForTool, Set<Material> extraMaterials) {
        Tier tier = GearHelper.getTier(stack);
        if (tier != null) {
            boolean isInToolTag = blocksForTool != null && state.m_204336_(blocksForTool);
            boolean isExtraMaterial = extraMaterials.contains(state.m_60767_());
            return (isInToolTag || isExtraMaterial) && TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)state);
        }
        return false;
    }

    public static float getDestroySpeed(ItemStack stack, BlockState state, @Nullable Set<Material> extraMaterials) {
        if (GearHelper.isBroken(stack)) {
            return 0.25f;
        }
        float speed = GearData.getStat(stack, ItemStats.HARVEST_SPEED);
        if (stack.m_41720_().isCorrectToolForDrops(stack, state)) {
            return speed;
        }
        if (extraMaterials != null && extraMaterials.contains(state.m_60767_())) {
            return speed;
        }
        return 1.0f;
    }

    public static boolean onBlockDestroyed(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!GearHelper.isBroken(stack) && stack.m_41720_() instanceof ICoreTool) {
            int damage = ((ICoreTool)stack.m_41720_()).getDamageOnBlockBreak(stack, world, state, pos);
            GearHelper.attemptDamage(stack, damage, entityLiving, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public static boolean hitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        boolean isBroken = GearHelper.isBroken(stack);
        if (!isBroken && stack.m_41720_() instanceof ICoreTool) {
            int damage = ((ICoreTool)stack.m_41720_()).getDamageOnHitEntity(stack, target, attacker);
            GearHelper.attemptDamage(stack, damage, attacker, EquipmentSlot.MAINHAND);
        }
        return !isBroken;
    }

    public static void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.f_46443_) {
            Player player = entity instanceof Player ? (Player)entity : null;
            TraitHelper.tickTraits(world, player, stack, isSelected);
        }
    }

    public static InteractionResult onItemUse(UseOnContext context) {
        InteractionResult ret = InteractionResult.PASS;
        Map<ITrait, Integer> traits = TraitHelper.getCachedTraits(context.m_43722_());
        for (Map.Entry<ITrait, Integer> entry : traits.entrySet()) {
            InteractionResult result = entry.getKey().onItemUse(context, entry.getValue());
            if (result == InteractionResult.PASS) continue;
            ret = result;
        }
        return ret;
    }

    public static void onItemSwing(ItemStack stack, LivingEntity wielder) {
        if (wielder instanceof Player && GearHelper.getType(stack).matches(GearType.MELEE_WEAPON) && GearHelper.tryAttackWithExtraReach((Player)wielder, false) != null) {
            return;
        }
        Map<ITrait, Integer> traits = TraitHelper.getCachedTraits(stack);
        for (Map.Entry<ITrait, Integer> entry : traits.entrySet()) {
            entry.getKey().onItemSwing(stack, wielder, entry.getValue());
        }
    }

    @Nullable
    public static Entity getAttackTargetWithExtraReach(Player player) {
        if (GearHelper.getType(player.m_21205_()).matches(GearType.MELEE_WEAPON)) {
            return GearHelper.tryAttackWithExtraReach(player, true);
        }
        return null;
    }

    @Nullable
    public static Entity tryAttackWithExtraReach(Player player) {
        return GearHelper.tryAttackWithExtraReach(player, false);
    }

    @Nullable
    private static Entity tryAttackWithExtraReach(Player player, boolean simulate) {
        AABB axisalignedbb;
        double range = GearHelper.getAttackRange((LivingEntity)player);
        Vec3 vector3d = player.m_20299_(0.0f);
        double rangeSquared = range * range;
        Vec3 vector3d1 = player.m_20252_(1.0f);
        Vec3 vector3d2 = vector3d.m_82520_(vector3d1.f_82479_ * range, vector3d1.f_82480_ * range, vector3d1.f_82481_ * range);
        EntityHitResult rayTrace = GearHelper.rayTraceEntities((Entity)player, vector3d, vector3d2, axisalignedbb = player.m_20191_().m_82369_(vector3d1.m_82490_(range)).m_82377_(1.0, 1.0, 1.0), entity -> !entity.m_5833_() && entity.m_6087_(), rangeSquared);
        if (rayTrace != null) {
            Entity entity2 = rayTrace.m_82443_();
            if (!simulate) {
                player.m_5706_(entity2);
            }
            return entity2;
        }
        return null;
    }

    private static double getAttackRange(LivingEntity entity) {
        ItemStack stack = entity.m_21205_();
        double base = GearHelper.getType(stack).matches(GearType.TOOL) ? (double)GearData.getStat(stack, ItemStats.ATTACK_REACH) : (double)ItemStats.ATTACK_REACH.getBaseValue();
        AttributeInstance attribute = entity.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (attribute != null) {
            double reachBonus = attribute.m_22135_() - attribute.m_22115_();
            return base + reachBonus;
        }
        return base;
    }

    @Nullable
    private static EntityHitResult rayTraceEntities(Entity shooter, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, double distance) {
        Level world = shooter.f_19853_;
        double d0 = distance;
        Entity entity = null;
        Vec3 vector3d = null;
        for (Entity entity1 : world.m_6249_(shooter, boundingBox, filter)) {
            Vec3 vector3d1;
            double d1;
            AABB axisalignedbb = entity1.m_20191_().m_82400_((double)entity1.m_6143_());
            Optional optional = axisalignedbb.m_82371_(startVec, endVec);
            if (axisalignedbb.m_82390_(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.m_82557_(vector3d1 = (Vec3)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.m_20201_() == shooter.m_20201_() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity, vector3d);
    }

    public static int getEnchantability(ItemStack stack) {
        if (((Boolean)Config.Common.allowEnchanting.get()).booleanValue()) {
            return GearData.getStatInt(stack, ItemStats.ENCHANTMENT_VALUE);
        }
        return 0;
    }

    public static Rarity getRarity(ItemStack stack) {
        int rarity = GearData.getStatInt(stack, ItemStats.RARITY);
        if (stack.m_41793_()) {
            rarity = ((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue() ? (rarity += 80) : (rarity += 20);
        }
        if (rarity < 40) {
            return Rarity.COMMON;
        }
        if (rarity < 80) {
            return Rarity.UNCOMMON;
        }
        if (rarity < 120) {
            return Rarity.RARE;
        }
        return Rarity.EPIC;
    }

    public static void fillItemGroup(ICoreItem item, CreativeModeTab group, Collection<ItemStack> items) {
        boolean inTab = false;
        for (CreativeModeTab tabInList : item.m_5456_().getCreativeTabs()) {
            if (tabInList != group) continue;
            inTab = true;
            break;
        }
        if (!inTab) {
            return;
        }
        items.add(GearHelper.createSampleItem(item, Const.Materials.IRON));
        items.add(GearHelper.createSampleItem(item, Const.Materials.DIAMOND));
        items.add(GearHelper.createSampleItem(item, Const.Materials.CRIMSON_STEEL));
        items.add(GearHelper.createSampleItem(item, Const.Materials.AZURE_ELECTRUM));
        items.add(GearHelper.createSampleItem(item, Const.Materials.TYRIAN_STEEL));
    }

    private static ItemStack createSampleItem(ICoreItem item, int tier) {
        ItemStack result = GearGenerator.create(item, tier);
        if (result.m_41619_()) {
            ArrayList parts = new ArrayList();
            for (PartType partType : item.getRequiredParts()) {
                partType.makeCompoundPart(item.getGearType(), Const.Materials.EXAMPLE).ifPresent(parts::add);
            }
            result = item.construct(parts);
        }
        GearData.setExampleTag(result, true);
        return result;
    }

    private static ItemStack createSampleItem(ICoreItem item, DataResource<IMaterial> mainMaterial) {
        ArrayList parts = Lists.newArrayList();
        for (PartType partType : item.getRequiredParts()) {
            partType.makeCompoundPart(item.getGearType(), GearHelper.selectMaterialForSample(partType, item.getGearType(), mainMaterial)).ifPresent(parts::add);
        }
        ItemStack result = new ItemStack((ItemLike)item);
        GearData.writeConstructionParts(result, parts);
        GearData.recalculateStats(result, null);
        return result;
    }

    private static DataResource<IMaterial> selectMaterialForSample(PartType partType, GearType gearType, DataResource<IMaterial> main) {
        if (partType == PartType.ROD) {
            return Const.Materials.WOOD;
        }
        if (partType == PartType.CORD) {
            return Const.Materials.STRING;
        }
        if (partType == PartType.FLETCHING) {
            return Const.Materials.FEATHER;
        }
        if (partType == PartType.BINDING) {
            return Const.Materials.STRING;
        }
        if (partType == PartType.ADORNMENT) {
            return GearHelper.getRandomMaterial(partType, gearType);
        }
        return main;
    }

    private static DataResource<IMaterial> getRandomMaterial(PartType partType, GearType gearType) {
        List<IMaterial> matsOfTier = MaterialManager.getValues(true).stream().map(MaterialInstance::of).filter(m -> m.allowedInPart(partType) && m.isCraftingAllowed(partType, gearType)).map(MaterialInstance::get).toList();
        if (!matsOfTier.isEmpty()) {
            IMaterial material = matsOfTier.get(SilentGear.RANDOM.nextInt(matsOfTier.size()));
            return DataResource.material(material.getId());
        }
        return Const.Materials.EXAMPLE;
    }

    public static Component getDisplayName(ItemStack gear) {
        MutableComponent gearName;
        PartData part = GearData.getPrimaryPart(gear);
        if (part == null) {
            return Component.m_237115_((String)gear.m_41778_());
        }
        Component partName = part.getMaterialName(gear);
        if (TimedEvents.isAprilFools()) {
            partName = partName.m_6881_().m_7220_((Component)Component.m_237113_((String)" & Knuckles"));
        }
        MutableComponent result = gearName = Component.m_237110_((String)(gear.m_41778_() + ".nameProper"), (Object[])new Object[]{partName});
        if (gear.m_41720_() instanceof ICoreTool) {
            ICoreItem item = (ICoreItem)gear.m_41720_();
            if (item.requiresPartOfType(PartType.ROD) && GearData.getPartOfType(gear, PartType.ROD) == null) {
                result = Component.m_237110_((String)(gear.m_41778_() + ".noRod"), (Object[])new Object[]{gearName});
            } else if (item.requiresPartOfType(PartType.CORD) && GearData.getPartOfType(gear, PartType.CORD) == null) {
                result = Component.m_237110_((String)(gear.m_41778_() + ".unstrung"), (Object[])new Object[]{gearName});
            }
        }
        for (Component t : GearHelper.getNamePrefixes(gear, GearData.getConstructionParts(gear))) {
            result = t.m_6881_().m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)result);
        }
        return result;
    }

    private static Collection<Component> getNamePrefixes(ItemStack gear, PartDataList parts) {
        GearNamePrefixesEvent event = new GearNamePrefixesEvent(gear, parts);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getPrefixes();
    }

    public static Collection<IPartData> getExamplePartsFromRecipe(GearType gearType, Iterable<Ingredient> ingredients) {
        LinkedHashMap map = new LinkedHashMap();
        PartType.MAIN.makeCompoundPart(gearType, Const.Materials.EXAMPLE).ifPresent(p -> map.put(PartType.MAIN, p));
        for (Ingredient ingredient : ingredients) {
            if (!(ingredient instanceof IGearIngredient)) continue;
            PartType type = ((IGearIngredient)ingredient).getPartType();
            type.makeCompoundPart(gearType, Const.Materials.EXAMPLE).ifPresent(p -> map.put(type, p));
        }
        return map.values();
    }

    public static Set<ToolAction> makeToolActionSet(ToolAction ... actions) {
        return Stream.of(actions).collect(Collectors.toCollection(Sets::newIdentityHashSet));
    }

    public static int getBarWidth(ItemStack stack) {
        return Math.round(13.0f - 13.0f * (float)stack.m_41773_() / (float)stack.m_41776_());
    }

    public static int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, (float)(stack.m_41776_() - stack.m_41773_()) / (float)stack.m_41776_());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }
}

