/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.data;

import com.flanks255.simplylight.SLBlockReg;
import com.flanks255.simplylight.SLBlocks;
import com.flanks255.simplylight.blocks.BaseBlockItem;
import com.flanks255.simplylight.blocks.LampBlock;
import com.flanks255.simplylight.blocks.LampPost;
import com.flanks255.simplylight.blocks.RodLamp;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.client.model.generators.loaders.CompositeModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStates
extends BlockStateProvider {
    ExistingFileHelper existingFileHelper;

    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "simplylight", exFileHelper);
        this.existingFileHelper = exFileHelper;
    }

    protected void registerStatesAndModels() {
        this.generateLampBlock();
        this.generateColorModels();
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_RED_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_RED);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_GREEN_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_GREEN);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_BLUE_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_BLUE);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_YELLOW_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_YELLOW);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_ORANGE_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_ORANGE);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_PINK_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_PINK);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_LIME_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_LIME);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_CYAN_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_CYAN);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_PURPLE_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_PURPLE);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_MAGENTA_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_MAGENTA);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_LIGHT_GRAY_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_LIGHT_GRAY);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_GRAY_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_GRAY);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_LIGHT_BLUE_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_LIGHT_BLUE);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_BROWN_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_BROWN);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_BLACK_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_BLACK);
        this.generateThinLamps();
        this.generateRodLamp();
        this.generateLightBulb();
        this.generateWallLamp();
        this.generateLampPost();
    }

    private void generateLightBulb() {
        ModelFile.ExistingModelFile base = this.models().getExistingFile(this.modLoc("block/lightbulb_base"));
        ModelFile.ExistingModelFile glow = this.models().getExistingFile(this.modLoc("block/lightbulb_glow"));
        BlockModelBuilder model = (BlockModelBuilder)((CompositeModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/lightbulb")).customLoader(CompositeModelBuilder::begin)).child("Solid", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).renderType("minecraft:solid")).parent((ModelFile)base))).child("Translucent", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).renderType("minecraft:translucent")).parent((ModelFile)glow))).end();
        this.myDirectionalBlock(SLBlocks.LIGHTBULB.get(), $ -> model, 180);
    }

    private void generateLampPost() {
        ModelFile.ExistingModelFile base = this.models().getExistingFile(this.modLoc("block/post_base"));
        ModelFile.ExistingModelFile mid = this.models().getExistingFile(this.modLoc("block/post_mid"));
        ModelFile.ExistingModelFile top = this.models().getExistingFile(this.modLoc("block/post_top"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(SLBlocks.LAMP_POST.get()).partialState().with(LampPost.POSITION, (Comparable)((Object)LampPost.Position.BOTTOM)).modelForState().modelFile((ModelFile)base).addModel()).partialState().with(LampPost.POSITION, (Comparable)((Object)LampPost.Position.MIDDLE)).modelForState().modelFile((ModelFile)mid).addModel()).partialState().with(LampPost.POSITION, (Comparable)((Object)LampPost.Position.TOP)).modelForState().modelFile((ModelFile)top).addModel();
    }

    private void generateWallLamp() {
        ModelFile.ExistingModelFile wallModel = this.models().getExistingFile(this.modLoc("block/wall_lamp"));
        ModelFile.ExistingModelFile floorModel = this.models().getExistingFile(this.modLoc("block/floorlamp"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(SLBlocks.WALL_LAMP.get()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)floorModel).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)floorModel).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)wallModel).rotationY(270).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)wallModel).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)wallModel).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)wallModel).rotationY(180).addModel();
    }

    private void generateThinLamps() {
        this.myDirectionalBlock(SLBlocks.ILLUMINANTSLAB.get(), $ -> this.models().getExistingFile(this.modLoc("block/illuminant_slab")), 180);
        this.myDirectionalBlock(SLBlocks.ILLUMINANTPANEL.get(), $ -> this.models().getExistingFile(this.modLoc("block/illuminant_panel")), 180);
    }

    void generateRodLamp() {
        RodLamp block = SLBlocks.RODLAMP.get();
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/rodlamp"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)model).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel();
    }

    private void generateLampBlock() {
        ResourceLocation offTex = this.modLoc("block/illuminant_block");
        ResourceLocation onTex = this.modLoc("block/illuminant_block_on");
        ModelBuilder.ElementBuilder illuminantBlockBuilder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(SLBlocks.ILLUMINANTBLOCK.get().getRegistryName().m_135815_(), "cube")).texture("all", offTex)).texture("particle", offTex)).ao(false)).element();
        ModelBuilder modelIlluminantBlock = illuminantBlockBuilder.cube("#all").shade(false).end();
        ModelBuilder.ElementBuilder illuminantBlockBuilder_On = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(SLBlocks.ILLUMINANTBLOCK_ON.get().getRegistryName().m_135815_(), "cube")).texture("all", onTex)).texture("particle", onTex)).ao(false)).element();
        ModelBuilder modelIlluminantBlock_on = illuminantBlockBuilder_On.cube("#all").shade(false).end();
        VariantBlockStateBuilder LampBlockBuilder = this.getVariantBuilder(SLBlocks.ILLUMINANTBLOCK.get());
        LampBlockBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelIlluminantBlock_on).addModel();
        LampBlockBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)modelIlluminantBlock).addModel();
        VariantBlockStateBuilder LampBlockOnBuilder = this.getVariantBuilder(SLBlocks.ILLUMINANTBLOCK_ON.get());
        LampBlockOnBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelIlluminantBlock_on).addModel();
        LampBlockOnBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)modelIlluminantBlock).addModel();
    }

    private void generateColorModels() {
        for (DyeColor color : DyeColor.values()) {
            if (color == DyeColor.WHITE) continue;
            ResourceLocation tex = this.modLoc("block/full_block/illuminant_" + color.m_41065_() + "_block");
            ResourceLocation tex_on = this.modLoc("block/full_block/illuminant_" + color.m_41065_() + "_block_on");
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/illuminant_" + color.m_41065_() + "_block", this.modLoc("block/illuminant_block"))).texture("all", tex)).texture("particle", tex);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/illuminant_" + color.m_41065_() + "_block_on", this.modLoc("block/illuminant_block"))).texture("all", tex_on)).texture("particle", tex_on);
        }
    }

    private void generateLampBlock(SLBlockReg<LampBlock, BaseBlockItem> block) {
        VariantBlockStateBuilder LampBlockBuilder = this.getVariantBuilder(block.get());
        LampBlockBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/illuminant_" + block.getBlock().color.m_41065_() + "_block_on"))).addModel();
        LampBlockBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/illuminant_" + block.getBlock().color.m_41065_() + "_block"))).addModel();
    }

    public void myDirectionalBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.m_122434_().m_122479_() ? 90 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + angleOffset) % 360).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }
}

