/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.blueprints.v1.DataFixerUtils;
import com.ldtteam.structurize.commands.AbstractCommand;
import com.ldtteam.structurize.update.DomumOrnamentumUpdateHandler;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;

public class UpdateSchematicsCommand
extends AbstractCommand {
    private static final String NAME = "updateschematics";

    protected static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)UpdateSchematicsCommand.newLiteral(NAME).executes(s -> UpdateSchematicsCommand.onExecute((CommandContext<CommandSourceStack>)s));
    }

    private static int onExecute(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
        Path gameFolder = new File(".").toPath().resolve("blueprints").resolve("updater");
        try {
            Files.createDirectories(gameFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (Stream<Path> paths = Files.list(gameFolder.resolve("input"));){
            paths.forEach(element -> UpdateSchematicsCommand.update(element, gameFolder.resolve("input"), gameFolder.resolve("output")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static void update(Path input, Path globalInputFolder, Path globalOutputFolder) {
        if (Files.isDirectory(input, new LinkOption[0])) {
            try (Stream<Path> paths = Files.list(input);){
                paths.forEach(element -> UpdateSchematicsCommand.update(element, globalInputFolder, globalOutputFolder));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            Path output = globalOutputFolder.resolve(input.toString().replaceAll("\\.nbt", ".blueprint").replace(globalInputFolder.toString(), ""));
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            if (input.toString().endsWith(".blueprint")) {
                CompoundTag bluePrintCompound = BlueprintUtil.writeBlueprintToNBT(UpdateSchematicsCommand.fixBluePrints(input));
                try (BufferedOutputStream outputstream = new BufferedOutputStream(Files.newOutputStream(output, new OpenOption[0]));){
                    NbtIo.m_128947_((CompoundTag)bluePrintCompound, (OutputStream)outputstream);
                }
                catch (IOException e) {
                    Log.getLogger().warn("Exception while trying to scan.", (Throwable)e);
                }
                return;
            }
            CompoundTag blueprint = NbtIo.m_128939_((InputStream)new ByteArrayInputStream(Files.readAllBytes(input)));
            if (blueprint == null || blueprint.m_128456_()) {
                return;
            }
            ListTag blocks = blueprint.m_128437_("blocks", 10);
            ListTag pallete = blueprint.m_128437_("palette", 10);
            CompoundTag bluePrintCompound = new CompoundTag();
            ListTag list = blueprint.m_128437_("size", 3);
            int[] size = new int[]{list.m_128763_(0), list.m_128763_(1), list.m_128763_(2)};
            bluePrintCompound.m_128376_("size_x", (short)size[0]);
            bluePrintCompound.m_128376_("size_y", (short)size[1]);
            bluePrintCompound.m_128376_("size_z", (short)size[2]);
            boolean addStructureVoid = blocks.size() != size[0] * size[1] * size[2];
            short structureVoidID = 0;
            if (addStructureVoid) {
                structureVoidID = (short)pallete.size();
                pallete.add((Object)NbtUtils.m_129202_((BlockState)Blocks.f_50454_.m_49966_()));
            }
            HashSet<String> mods = new HashSet<String>();
            for (int i = 0; i < pallete.size(); ++i) {
                CompoundTag blockState = pallete.m_128728_(i);
                String modid = blockState.m_128461_("Name").split(":")[0];
                mods.add(modid);
            }
            ListTag requiredMods = new ListTag();
            for (String str : mods) {
                requiredMods.add((Object)StringTag.m_129297_((String)str));
            }
            bluePrintCompound.m_128365_("palette", (Tag)pallete);
            bluePrintCompound.m_128365_("required_mods", (Tag)requiredMods);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            short[][][] dataArray = new short[size[1]][size[2]][size[0]];
            if (addStructureVoid) {
                for (int i = 0; i < size[1]; ++i) {
                    for (int j = 0; j < size[2]; ++j) {
                        for (int k = 0; k < size[0]; ++k) {
                            dataArray[i][j][k] = structureVoidID;
                        }
                    }
                }
            }
            ListTag tileEntities = new ListTag();
            for (int i = 0; i < blocks.size(); ++i) {
                CompoundTag comp = blocks.m_128728_(i);
                UpdateSchematicsCommand.updatePos(pos, comp);
                dataArray[pos.m_123342_()][pos.m_123343_()][pos.m_123341_()] = (short)comp.m_128451_("state");
                if (!comp.m_128441_("nbt")) continue;
                CompoundTag te = comp.m_128469_("nbt");
                te.m_128376_("x", (short)pos.m_123341_());
                te.m_128376_("y", (short)pos.m_123342_());
                te.m_128376_("z", (short)pos.m_123343_());
                tileEntities.add((Object)te);
            }
            bluePrintCompound.m_128385_("blocks", UpdateSchematicsCommand.convertBlocksToSaveData(dataArray, (short)size[0], (short)size[1], (short)size[2]));
            bluePrintCompound.m_128365_("tile_entities", (Tag)tileEntities);
            bluePrintCompound.m_128365_("architects", (Tag)new ListTag());
            bluePrintCompound.m_128365_("name", (Tag)StringTag.m_129297_((String)input.toString().replaceAll("\\.nbt", "")));
            bluePrintCompound.m_128405_("version", 1);
            ListTag newEntities = new ListTag();
            if (blueprint.m_128441_("entities")) {
                ListTag entities = blueprint.m_128437_("entities", 10);
                for (int i = 0; i < entities.size(); ++i) {
                    CompoundTag entityData = entities.m_128728_(i);
                    CompoundTag entity = entityData.m_128469_("nbt");
                    entity.m_128365_("Pos", entityData.m_128423_("pos"));
                    newEntities.add((Object)entity);
                }
            }
            bluePrintCompound.m_128365_("entities", (Tag)newEntities);
            try (BufferedOutputStream outputstream = new BufferedOutputStream(Files.newOutputStream(output, new OpenOption[0]));){
                NbtIo.m_128947_((CompoundTag)bluePrintCompound, (OutputStream)outputstream);
            }
            catch (IOException e) {
                Log.getLogger().warn("Exception while trying to scan.", (Throwable)e);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Blueprint fixBluePrints(Path input) {
        try {
            CompoundTag compoundNBT = NbtIo.m_128939_((InputStream)new ByteArrayInputStream(Files.readAllBytes(input)));
            return UpdateSchematicsCommand.readBlueprintFromNBT(compoundNBT);
        }
        catch (Exception e) {
            Log.getLogger().warn("Could not read file:" + input.toString());
            return null;
        }
    }

    public static Blueprint readBlueprintFromNBT(CompoundTag nbtTag) {
        CompoundTag tag = nbtTag;
        byte version = tag.m_128445_("version");
        if (version == 1) {
            CompoundTag optionalTag;
            short sizeX = tag.m_128448_("size_x");
            short sizeY = tag.m_128448_("size_y");
            short sizeZ = tag.m_128448_("size_z");
            ArrayList<String> requiredMods = new ArrayList<String>();
            ArrayList<String> missingMods = new ArrayList<String>();
            ListTag modsList = (ListTag)tag.m_128423_("required_mods");
            int modListSize = modsList.size();
            for (int i = 0; i < modListSize; ++i) {
                requiredMods.add(modsList.get(i).m_7916_());
                if (((String)requiredMods.get(i)).equals("minecraft") || ModList.get().getModContainerById((String)requiredMods.get(i)).isPresent()) continue;
                LogManager.getLogger().warn("Found missing mods for Blueprint, some blocks may be missing: " + (String)requiredMods.get(i));
                missingMods.add((String)requiredMods.get(i));
            }
            int oldDataVersion = tag.m_128441_("mcversion") ? tag.m_128451_("mcversion") : BlueprintUtil.DEFAULT_FIXER_IF_NOT_FOUND;
            ListTag paletteTag = (ListTag)tag.m_128423_("palette");
            ArrayList<BlockState> palette = new ArrayList<BlockState>();
            short[][][] blocks = BlueprintUtil.convertSaveDataToBlocks(tag.m_128465_("blocks"), sizeX, sizeY, sizeZ);
            CompoundTag[] tes = BlueprintUtil.fixTileEntities(oldDataVersion, (ListTag)tag.m_128423_("tile_entities"));
            ArrayList<CompoundTag> teList = new ArrayList<CompoundTag>();
            UpdateSchematicsCommand.fixPalette(oldDataVersion, palette, teList, paletteTag, blocks, new BlockPos((int)sizeX, (int)sizeY, (int)sizeZ));
            teList.addAll(Arrays.stream(tes).toList());
            CompoundTag[] tileEntities = teList.toArray(new CompoundTag[0]);
            CompoundTag[] entities = BlueprintUtil.fixEntities(oldDataVersion, (ListTag)tag.m_128423_("entities"));
            if (oldDataVersion == BlueprintUtil.DEFAULT_FIXER_IF_NOT_FOUND) {
                BlueprintUtil.fixCross1343(palette, blocks, tileEntities, entities);
            }
            Blueprint schem = new Blueprint(sizeX, sizeY, sizeZ, (short)palette.size(), palette, blocks, tileEntities, requiredMods).setMissingMods(missingMods.toArray(new String[0]));
            schem.setEntities(entities);
            if (tag.m_128431_().contains("name")) {
                schem.setName(tag.m_128461_("name"));
            }
            if (tag.m_128431_().contains("architects")) {
                ListTag architectsTag = (ListTag)tag.m_128423_("architects");
                String[] architects = new String[architectsTag.size()];
                for (int i = 0; i < architectsTag.size(); ++i) {
                    architects[i] = architectsTag.m_128778_(i);
                }
                schem.setArchitects(architects);
            }
            if (tag.m_128431_().contains("optional_data") && (optionalTag = tag.m_128469_("optional_data")).m_128431_().contains("structurize")) {
                CompoundTag structurizeTag = optionalTag.m_128469_("structurize");
                BlockPos offsetPos = BlockPosUtil.readFromNBT(structurizeTag, "primary_offset");
                schem.setCachePrimaryOffset(offsetPos);
            }
            return schem;
        }
        return null;
    }

    public static void fixPalette(int oldDataVersion, List<BlockState> palette, List<CompoundTag> tileEntities, ListTag paletteTag, short[][][] blocks, BlockPos blockPos) {
        short paletteSize = (short)paletteTag.size();
        for (short i = 0; i < paletteSize; i = (short)(i + 1)) {
            CompoundTag nbt = paletteTag.m_128728_((int)i);
            try {
                CompoundTag fixedNbt = DataFixerUtils.runDataFixer(nbt, References.f_16783_, oldDataVersion);
                String name = fixedNbt.m_128461_("Name");
                if (!name.startsWith("%s:".formatted("structurize"))) {
                    BlockState state = NbtUtils.m_129241_((CompoundTag)fixedNbt);
                    palette.add(i, state);
                    continue;
                }
                Optional<Tuple<BlockState, Optional<BlockEntity>>> replacementData = DomumOrnamentumUpdateHandler.createBlockReplacementData(fixedNbt);
                if (replacementData.isEmpty()) {
                    BlockState state = NbtUtils.m_129241_((CompoundTag)fixedNbt);
                    palette.add(i, state);
                    continue;
                }
                palette.add(i, (BlockState)replacementData.get().m_14418_());
                if (!((Optional)replacementData.get().m_14419_()).isPresent()) continue;
                for (int y = 0; y < blockPos.m_123342_(); ++y) {
                    for (int x = 0; x < blockPos.m_123341_(); ++x) {
                        for (int z = 0; z < blockPos.m_123343_(); ++z) {
                            if (blocks[y][z][x] != i) continue;
                            CompoundTag targetTag = ((BlockEntity)((Optional)replacementData.get().m_14419_()).get()).m_187480_().m_6426_();
                            targetTag.m_128405_("x", x);
                            targetTag.m_128405_("y", y);
                            targetTag.m_128405_("z", z);
                            tileEntities.add(targetTag);
                        }
                    }
                }
                continue;
            }
            catch (Exception e) {
                palette.add(i, Blocks.f_50016_.m_49966_());
                Log.getLogger().warn("Blueprint reader: something went wrong loading block at position: " + i, (Throwable)e);
            }
        }
    }

    private static void updatePos(BlockPos.MutableBlockPos pos, CompoundTag comp) {
        ListTag list = comp.m_128437_("pos", 3);
        pos.m_122178_(list.m_128763_(0), list.m_128763_(1), list.m_128763_(2));
    }

    private static int[] convertBlocksToSaveData(short[][][] multDimArray, short sizeX, short sizeY, short sizeZ) {
        int currentInt;
        short[] oneDimArray = new short[sizeX * sizeY * sizeZ];
        int j = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    oneDimArray[j++] = multDimArray[y][z][x];
                }
            }
        }
        int[] ints = new int[(int)Math.ceil((float)oneDimArray.length / 2.0f)];
        for (int i = 1; i < oneDimArray.length; i += 2) {
            currentInt = oneDimArray[i - 1];
            ints[(int)Math.ceil((double)((double)((float)i / 2.0f))) - 1] = currentInt = currentInt << 16 | oneDimArray[i];
        }
        if (oneDimArray.length % 2 == 1) {
            ints[ints.length - 1] = currentInt = oneDimArray[oneDimArray.length - 1] << 16;
        }
        return ints;
    }
}

