/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class SyncPreviewCacheToClient
implements IMessage {
    private final BlueprintPreviewData previewData;
    private final String playerUUID;

    public SyncPreviewCacheToClient(FriendlyByteBuf buf) {
        this.previewData = new BlueprintPreviewData(buf);
        this.playerUUID = buf.m_130136_(Short.MAX_VALUE);
    }

    public SyncPreviewCacheToClient(BlueprintPreviewData previewData, String playerUUID) {
        this.previewData = previewData;
        this.playerUUID = playerUUID;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        this.previewData.writeToBuf(buf);
        buf.m_130070_(this.playerUUID);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (this.previewData.isEmpty()) {
            if (RenderingCache.hasBlueprint(this.playerUUID)) {
                RenderingCache.removeBlueprint(this.playerUUID);
            }
        } else {
            RenderingCache.queue(this.playerUUID, this.previewData);
        }
    }
}

