/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams.block;

import chiefarug.mods.systeams.ConversionKitItem;
import chiefarug.mods.systeams.SysteamsConfig;
import chiefarug.mods.systeams.SysteamsRegistry;
import cofh.core.block.TileBlockActive6Way;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="systeams")
public class BoilerBlock
extends TileBlockActive6Way {
    private static final VoxelShape[] BASE_SHAPE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)10.0), Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] TUBE_SHAPE = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)6.0), Block.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)12.0), Block.m_49796_((double)10.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)};
    private static final VoxelShape[] BOILER_SHAPE = new VoxelShape[]{Shapes.m_83110_((VoxelShape)BASE_SHAPE[0], (VoxelShape)TUBE_SHAPE[0]), Shapes.m_83110_((VoxelShape)BASE_SHAPE[1], (VoxelShape)TUBE_SHAPE[1]), Shapes.m_83110_((VoxelShape)BASE_SHAPE[2], (VoxelShape)TUBE_SHAPE[2]), Shapes.m_83110_((VoxelShape)BASE_SHAPE[3], (VoxelShape)TUBE_SHAPE[3]), Shapes.m_83110_((VoxelShape)BASE_SHAPE[4], (VoxelShape)TUBE_SHAPE[4]), Shapes.m_83110_((VoxelShape)BASE_SHAPE[5], (VoxelShape)TUBE_SHAPE[5])};

    public BoilerBlock(BlockBehaviour.Properties builder, Class<?> tileClass, Supplier<BlockEntityType<?>> blockEntityType) {
        super(builder, tileClass, blockEntityType);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStatePropertiesCoFH.ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStatePropertiesCoFH.FACING_ALL, (Comparable)Direction.UP)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BOILER_SHAPE[((Direction)state.m_61143_((Property)BlockStatePropertiesCoFH.FACING_ALL)).ordinal()];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public ItemStack getOtherConversionItem() {
        return new ItemStack(SysteamsRegistry.Items.RF_COIL);
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(context).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(flag));
    }

    @SubscribeEvent
    public static void use(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        Level level = event.getLevel();
        BlockState oldState = level.m_8055_(pos = event.getHitVec().m_82425_());
        Block block = oldState.m_60734_();
        if (!(block instanceof BoilerBlock)) {
            return;
        }
        BoilerBlock boiler = (BoilerBlock)block;
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack item = player.m_21120_(hand);
        if (item.m_41720_() != boiler.getOtherConversionItem().m_41720_() || !player.m_6047_()) {
            return;
        }
        if (ModList.get().isLoaded("pneumaticcraft") && !((Boolean)SysteamsConfig.PNEUMATIC_BOILER_IN_WORLD_CONVERSION.get()).booleanValue() && boiler.getOtherConversionItem().m_41720_() != SysteamsRegistry.Items.RF_COIL.m_5456_()) {
            return;
        }
        Block dynamo = (Block)ConversionKitItem.getDynamoBoilerMap().inverse().get((Object)boiler);
        if (dynamo == null) {
            return;
        }
        BlockState newState = (BlockState)((BlockState)dynamo.m_49966_().m_61124_((Property)BlockStatePropertiesCoFH.FACING_ALL, (Comparable)((Direction)oldState.m_61143_((Property)BlockStatePropertiesCoFH.FACING_ALL)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)oldState.m_61143_((Property)BlockStateProperties.f_61362_)));
        ConversionKitItem.transformDynamoBoiler(pos, level, oldState, newState, player);
        if (!player.m_150110_().f_35937_) {
            item.m_41774_(1);
            if (item.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)SysteamsRegistry.Items.BOILER_PIPE.get()));
            } else {
                player.m_36356_(new ItemStack((ItemLike)SysteamsRegistry.Items.BOILER_PIPE.get()));
            }
        }
        if (level.m_5776_()) {
            player.m_6674_(hand);
        }
        event.setCanceled(true);
    }
}

