/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.RedstoneState;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TransferState;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TesseractBlockEntity
extends BaseBlockEntity {
    private TesseractReference reference;
    private final EnumMap<EnumChannelType, TransferState> transferState = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, LazyOptional<?>> capabilities = new EnumMap(EnumChannelType.class);
    private RedstoneState redstoneState = RedstoneState.DISABLED;
    private boolean redstone;
    public int recurrentCalls = 0;
    private final Map<Direction, Map<Capability<?>, LazyOptional<?>>> surroundingCapabilities = new HashMap();

    public TesseractBlockEntity(BlockPos pos, BlockState state) {
        super(Tesseract.tesseract_tile, pos, state);
        for (EnumChannelType enumChannelType : EnumChannelType.values()) {
            this.transferState.put(enumChannelType, TransferState.BOTH);
        }
        for (EnumChannelType enumChannelType : Direction.values()) {
            this.surroundingCapabilities.put((Direction)enumChannelType, new HashMap());
        }
    }

    public TesseractReference getReference() {
        if (this.reference == null) {
            this.reference = TesseractTracker.getInstance(this.f_58857_).add(this);
        }
        return this.reference;
    }

    public void invalidateReference() {
        this.reference = null;
    }

    public void channelChanged(EnumChannelType type) {
        LazyOptional<?> optional = this.capabilities.remove((Object)type);
        if (optional != null) {
            optional.invalidate();
        }
        this.notifyNeighbors();
    }

    public boolean renderOn() {
        return !this.isBlockedByRedstone();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.capabilities.computeIfAbsent(EnumChannelType.ITEMS, o -> {
                Channel channel = this.getChannel(EnumChannelType.ITEMS);
                return channel == null ? LazyOptional.empty() : LazyOptional.of(() -> channel.getItemHandler(this));
            }).cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.capabilities.computeIfAbsent(EnumChannelType.FLUID, o -> {
                Channel channel = this.getChannel(EnumChannelType.FLUID);
                return channel == null ? LazyOptional.empty() : LazyOptional.of(() -> channel.getFluidHandler(this));
            }).cast();
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return this.capabilities.computeIfAbsent(EnumChannelType.ENERGY, o -> {
                Channel channel = this.getChannel(EnumChannelType.ENERGY);
                return channel == null ? LazyOptional.empty() : LazyOptional.of(() -> channel.getEnergyStorage(this));
            }).cast();
        }
        return super.getCapability(capability, side);
    }

    public <T> List<T> getSurroundingCapabilities(Capability<T> capability) {
        if (this.f_58857_ == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Direction facing : Direction.values()) {
            LazyOptional optional = this.surroundingCapabilities.get(facing).computeIfAbsent(capability, o -> {
                BlockEntity entity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing));
                if (entity != null && !(entity instanceof TesseractBlockEntity)) {
                    return entity.getCapability(capability, facing.m_122424_());
                }
                return LazyOptional.empty();
            });
            if (!optional.isPresent()) continue;
            list.add(optional.orElseGet(() -> null));
        }
        return list;
    }

    public boolean canSend(EnumChannelType type) {
        return this.transferState.get((Object)type).canSend() && !this.isBlockedByRedstone();
    }

    public boolean canReceive(EnumChannelType type) {
        return this.transferState.get((Object)type).canReceive() && !this.isBlockedByRedstone();
    }

    public boolean isBlockedByRedstone() {
        return this.redstoneState != RedstoneState.DISABLED && this.redstoneState == (this.redstone ? RedstoneState.LOW : RedstoneState.HIGH);
    }

    public int getChannelId(EnumChannelType type) {
        return this.getReference().getChannelId(type);
    }

    public TransferState getTransferState(EnumChannelType type) {
        return this.transferState.get((Object)type);
    }

    public void cycleTransferState(EnumChannelType type) {
        TransferState transferState = this.transferState.get((Object)type);
        this.transferState.put(type, transferState == TransferState.BOTH ? TransferState.SEND : (transferState == TransferState.SEND ? TransferState.RECEIVE : TransferState.BOTH));
        this.updateReference();
        this.dataChanged();
    }

    public RedstoneState getRedstoneState() {
        return this.redstoneState;
    }

    public void cycleRedstoneState() {
        this.redstoneState = this.redstoneState == RedstoneState.DISABLED ? RedstoneState.HIGH : (this.redstoneState == RedstoneState.HIGH ? RedstoneState.LOW : RedstoneState.DISABLED);
        this.updateReference();
        this.dataChanged();
    }

    public void setPowered(boolean powered) {
        if (this.redstone != powered) {
            this.redstone = powered;
            this.updateReference();
            this.dataChanged();
        }
    }

    private Channel getChannel(EnumChannelType type) {
        return this.getReference().getChannel(type);
    }

    public void onNeighborChanged(BlockPos neighbor) {
        Direction facing = Direction.m_122372_((float)(neighbor.m_123341_() - this.f_58858_.m_123341_()), (float)(neighbor.m_123342_() - this.f_58858_.m_123342_()), (float)(neighbor.m_123343_() - this.f_58858_.m_123343_()));
        this.surroundingCapabilities.get(facing).clear();
    }

    private void notifyNeighbors() {
        this.f_58857_.m_6289_(this.f_58858_, this.m_58900_().m_60734_());
    }

    private void updateReference() {
        TesseractReference reference = this.getReference();
        if (reference != null) {
            reference.update(this);
        }
    }

    protected CompoundTag writeData() {
        CompoundTag compound = new CompoundTag();
        for (EnumChannelType type : EnumChannelType.values()) {
            compound.m_128359_("transferState" + type.name(), this.transferState.get((Object)type).name());
        }
        compound.m_128359_("redstoneState", this.redstoneState.name());
        compound.m_128379_("powered", this.redstone);
        return compound;
    }

    protected void readData(CompoundTag compound) {
        for (EnumChannelType type : EnumChannelType.values()) {
            if (!compound.m_128441_("transferState" + type.name())) continue;
            this.transferState.put(type, TransferState.valueOf(compound.m_128461_("transferState" + type.name())));
        }
        if (compound.m_128441_("redstoneState")) {
            this.redstoneState = RedstoneState.valueOf(compound.m_128461_("redstoneState"));
        }
        if (compound.m_128441_("powered")) {
            this.redstone = compound.m_128471_("powered");
        }
    }

    public void onReplaced() {
        if (!this.f_58857_.f_46443_) {
            TesseractTracker.SERVER.remove(this.f_58857_, this.f_58858_);
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.capabilities.values().forEach(LazyOptional::invalidate);
    }
}

