/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.capabilities;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class CombinedEnergyStorage
implements IEnergyStorage {
    private final Channel channel;
    private final TesseractBlockEntity requester;

    public CombinedEnergyStorage(Channel channel, TesseractBlockEntity requester) {
        this.channel = channel;
        this.requester = requester;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        if (!this.requester.canSend(EnumChannelType.ENERGY) || maxReceive <= 0) {
            this.popRecurrentCall();
            return 0;
        }
        int amount = maxReceive;
        block0: for (TesseractReference location : this.channel.receivingTesseracts) {
            TesseractBlockEntity entity;
            if (!location.canBeAccessed() || !location.canReceive(EnumChannelType.ENERGY) || (entity = location.getTesseract()) == this.requester) continue;
            for (IEnergyStorage storage : entity.getSurroundingCapabilities(CapabilityEnergy.ENERGY)) {
                int received;
                if (!storage.canReceive() || (received = storage.receiveEnergy(amount, simulate)) <= 0 || (amount -= received) > 0) continue;
                break block0;
            }
        }
        this.popRecurrentCall();
        return Math.max(0, maxReceive - amount);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        if (!this.requester.canReceive(EnumChannelType.ENERGY) || maxExtract <= 0) {
            this.popRecurrentCall();
            return 0;
        }
        int amount = maxExtract;
        block0: for (TesseractReference location : this.channel.sendingTesseracts) {
            TesseractBlockEntity entity;
            if (!location.canBeAccessed() || !location.canSend(EnumChannelType.ENERGY) || (entity = location.getTesseract()) == this.requester) continue;
            for (IEnergyStorage storage : entity.getSurroundingCapabilities(CapabilityEnergy.ENERGY)) {
                int extracted;
                if (!storage.canExtract() || (extracted = storage.extractEnergy(amount, simulate)) <= 0 || (amount -= extracted) > 0) continue;
                break block0;
            }
        }
        this.popRecurrentCall();
        return Math.max(0, maxExtract - amount);
    }

    public int getEnergyStored() {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        int amount = 0;
        for (TesseractReference location : this.channel.tesseracts) {
            TesseractBlockEntity entity;
            if (!location.canBeAccessed() || (entity = location.getTesseract()) == this.requester) continue;
            for (IEnergyStorage storage : entity.getSurroundingCapabilities(CapabilityEnergy.ENERGY)) {
                amount += storage.getEnergyStored();
            }
        }
        this.popRecurrentCall();
        return amount;
    }

    public int getMaxEnergyStored() {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        int amount = 0;
        for (TesseractReference location : this.channel.tesseracts) {
            TesseractBlockEntity entity;
            if (!location.canBeAccessed() || (entity = location.getTesseract()) == this.requester) continue;
            for (IEnergyStorage storage : entity.getSurroundingCapabilities(CapabilityEnergy.ENERGY)) {
                amount += storage.getMaxEnergyStored();
            }
        }
        this.popRecurrentCall();
        return amount;
    }

    public boolean canExtract() {
        return this.requester.canReceive(EnumChannelType.ENERGY);
    }

    public boolean canReceive() {
        return this.requester.canSend(EnumChannelType.ENERGY);
    }

    private boolean pushRecurrentCall() {
        if (this.requester.recurrentCalls >= 1) {
            return true;
        }
        ++this.requester.recurrentCalls;
        return false;
    }

    private void popRecurrentCall() {
        --this.requester.recurrentCalls;
    }
}

