/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.multischematic;

import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.Nullable;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.effect.EffectHelper;

public class RuinedMultiblockSchematicBlock
extends HorizontalDirectionalBlock
implements IInteractiveBlock {
    public static final DirectionProperty facingProp = BlockStateProperties.f_61374_;
    protected ResourceLocation pryTable;
    protected BlockInteraction[] pryAction = new BlockInteraction[]{new BlockInteraction(TetraToolActions.pry, 1, Direction.EAST, 6.0f, 10.0f, 7.0f, 10.0f, BlockStatePredicate.f_61281_, this::pryBlock)};

    public RuinedMultiblockSchematicBlock(BlockBehaviour.Properties properties, ResourceLocation pryTable) {
        super(properties);
        this.pryTable = pryTable;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)facingProp, (Comparable)Direction.EAST));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{facingProp});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)facingProp, (Comparable)context.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.pryTable != null) {
            return BlockInteraction.attemptInteraction(world, state, pos, player, hand, hit);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(Level world, BlockPos pos, BlockState blockState, Direction face, Collection<ToolAction> tools) {
        if (this.pryTable != null && face.m_122424_().equals((Object)blockState.m_61143_((Property)facingProp))) {
            return this.pryAction;
        }
        return new BlockInteraction[0];
    }

    protected boolean pryBlock(Level world, BlockPos pos, BlockState blockState, Player player, InteractionHand hand, Direction facing) {
        boolean didBreak = EffectHelper.breakBlock(world, player, player.m_21120_(hand), pos, blockState, false);
        if (didBreak && world instanceof ServerLevel) {
            BlockInteraction.getLoot(this.pryTable, player, hand, (ServerLevel)world, blockState).forEach(lootStack -> RuinedMultiblockSchematicBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)lootStack));
        }
        return true;
    }
}

