/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import se.mickelus.tetra.blocks.scroll.ScrollData;
import se.mickelus.tetra.blocks.scroll.ScrollItem;

@ParametersAreNonnullByDefault
public class ScrollIngredient
extends Ingredient {
    private final ItemStack itemStack;
    private final ScrollData data;

    protected ScrollIngredient(ItemStack itemStack, ScrollData data) {
        super(Stream.of(new Ingredient.ItemValue(itemStack)));
        this.itemStack = itemStack;
        this.data = data;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null || input.m_41720_() != ScrollItem.instance) {
            return false;
        }
        ScrollData inputData = ScrollData.read(input);
        return this.data.key.equals(inputData.key);
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.instance;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        this.data.write(json);
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<ScrollIngredient> {
        public static final Serializer instance = new Serializer();

        public ScrollIngredient parse(JsonObject json) {
            ScrollData data = ScrollData.read(json);
            ItemStack itemStack = new ItemStack((ItemLike)ScrollItem.instance);
            data.write(itemStack);
            return new ScrollIngredient(itemStack, data);
        }

        public ScrollIngredient parse(FriendlyByteBuf buffer) {
            ItemStack itemStack = buffer.m_130267_();
            return new ScrollIngredient(itemStack, ScrollData.read(itemStack));
        }

        public void write(FriendlyByteBuf buffer, ScrollIngredient ingredient) {
            buffer.m_130055_(ingredient.itemStack);
        }
    }
}

