/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.network.packet.server;

import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import cofh.thermal.dynamics.ThermalDynamics;
import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.attachment.IAttachment;
import cofh.thermal.dynamics.attachment.IPacketHandlerAttachment;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AttachmentConfigPacket
extends PacketBase
implements IPacketServer {
    protected BlockPos pos;
    protected Direction side;
    protected FriendlyByteBuf buffer;

    public AttachmentConfigPacket() {
        super(32, ThermalDynamics.PACKET_HANDLER);
    }

    public void handleServer(ServerPlayer player) {
        IDuct duct;
        IAttachment iAttachment;
        Level world = player.f_19853_;
        if (!world.m_46749_(this.pos)) {
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof IDuct && (iAttachment = (duct = (IDuct)tile).getAttachment(this.side)) instanceof IPacketHandlerAttachment) {
            IPacketHandlerAttachment attachment = (IPacketHandlerAttachment)iAttachment;
            attachment.handleConfigPacket(this.buffer);
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130068_((Enum)this.side);
        buf.writeBytes((ByteBuf)this.buffer);
    }

    public void read(FriendlyByteBuf buf) {
        this.buffer = buf;
        this.pos = this.buffer.m_130135_();
        this.side = (Direction)this.buffer.m_130066_(Direction.class);
    }

    public static void sendToServer(IPacketHandlerAttachment attachment) {
        if (!attachment.hasConfigPacket()) {
            return;
        }
        AttachmentConfigPacket packet = new AttachmentConfigPacket();
        packet.pos = attachment.pos();
        packet.side = attachment.side();
        packet.buffer = attachment.getConfigPacket(new FriendlyByteBuf(Unpooled.buffer()));
        packet.sendToServer();
    }
}

