/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.block.entity.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.FalseCraftingInventory;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.Utils;
import cofh.lib.xp.EmptyXpStorage;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.item.SlotSealItem;
import cofh.thermal.core.util.managers.machine.CrafterRecipeManager;
import cofh.thermal.expansion.init.TExpTileEntities;
import cofh.thermal.expansion.inventory.container.machine.MachineCrafterContainer;
import cofh.thermal.lib.block.entity.MachineBlockEntity;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class MachineCrafterTile
extends MachineBlockEntity {
    public static final int SLOT_CRAFTING_START = 11;
    protected FalseCraftingInventory craftMatrix = new FalseCraftingInventory(3, 3);
    protected ResultContainer craftResult = new ResultContainer();
    protected boolean hasRecipeChanges;
    protected boolean validRecipe;
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH();
    protected ItemStorageCoFH resultSlot = new ItemStorageCoFH();
    protected FluidStorageCoFH inputTank = new FluidStorageCoFH(8000, fluid -> this.filter.valid(fluid) && CrafterRecipeManager.instance().validFluid(fluid, this.curRecipe));

    public MachineCrafterTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TExpTileEntities.MACHINE_CRAFTER_TILE.get(), pos, state);
        this.xpStorage = EmptyXpStorage.INSTANCE;
        this.inventory.addSlots(StorageGroup.INPUT, 9, item -> item.m_41720_() instanceof SlotSealItem || this.filter.valid(item) && CrafterRecipeManager.instance().validItem(item, this.curRecipe));
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.inventory.addSlots(StorageGroup.INTERNAL, 9);
        this.inventory.addSlot(this.resultSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.inputTank, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalCoreConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return CrafterRecipeManager.instance().getBasePower();
    }

    public void tickServer() {
        if (!this.resultSlot.isEmpty() && this.craftResult.m_7928_() == null) {
            this.setRecipe();
        }
        super.tickServer();
    }

    protected int getBaseXpStorage() {
        return 0;
    }

    protected void setRecipe() {
        CraftingRecipe craftRecipe;
        if (this.f_58857_ == null || Utils.isClientWorld((Level)this.f_58857_)) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            this.craftMatrix.m_6836_(i, this.inventory.get(11 + i));
        }
        Optional possibleRecipe = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.craftMatrix, this.f_58857_);
        if (possibleRecipe.isPresent()) {
            craftRecipe = (CraftingRecipe)possibleRecipe.get();
            this.craftResult.m_6836_(0, craftRecipe.m_5874_((Container)this.craftMatrix));
        } else {
            craftRecipe = null;
            this.craftResult.m_6836_(0, ItemStack.f_41583_);
            if (this.isActive) {
                this.processOff();
            }
        }
        this.craftResult.m_6029_((Recipe)craftRecipe);
        this.curRecipe = CrafterRecipeManager.instance().getRecipe((Recipe)craftRecipe);
        this.resultSlot.setItemStack(this.craftResult.m_8020_(0));
        this.clearRecipeChanges();
    }

    public void markRecipeChanges() {
        this.hasRecipeChanges = true;
        if (this.isActive) {
            this.processOff();
        }
    }

    public void clearRecipeChanges() {
        this.hasRecipeChanges = false;
    }

    public boolean hasRecipeChanges() {
        return this.hasRecipeChanges;
    }

    public void onReplaced(BlockState state, Level levelIn, BlockPos pos, BlockState newState) {
        int i;
        if (!((Boolean)ThermalCoreConfig.keepItems.get()).booleanValue()) {
            for (i = 0; i < this.invSize() - this.augSize() - 9 - 1; ++i) {
                Containers.m_18992_((Level)levelIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.inventory.getStackInSlot(i));
            }
        }
        if (!((Boolean)ThermalCoreConfig.keepAugments.get()).booleanValue()) {
            for (i = this.invSize() - this.augSize(); i < this.invSize(); ++i) {
                Utils.dropItemStackIntoWorldWithRandomness((ItemStack)this.inventory.getStackInSlot(i), (Level)levelIn, (BlockPos)pos);
            }
        }
    }

    protected boolean canProcessStart() {
        return !this.hasRecipeChanges && super.canProcessStart();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = CrafterRecipeManager.instance().getRecipe(this.craftResult.m_7928_());
        if (this.curRecipe != null) {
            Pair inputCounts = this.curRecipe.getInputItemAndFluidCounts((IMachineInventory)this);
            this.itemInputCounts = (List)inputCounts.getLeft();
            this.fluidInputCounts = (List)inputCounts.getRight();
        }
        this.validRecipe = !this.itemInputCounts.isEmpty() || !this.fluidInputCounts.isEmpty();
        return this.validRecipe;
    }

    protected boolean cacheRenderFluid() {
        if (this.curRecipe == null) {
            return false;
        }
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = !this.fluidInputCounts.isEmpty() && (Integer)this.fluidInputCounts.get(0) > 0 ? new FluidStack(this.inputTank.getFluidStack(), 1000) : FluidStack.EMPTY;
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new MachineCrafterContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    public FriendlyByteBuf getConfigPacket(FriendlyByteBuf buffer) {
        super.getConfigPacket(buffer);
        for (int i = 11; i < 20; ++i) {
            buffer.m_130055_(this.inventory.getStackInSlot(i));
        }
        return buffer;
    }

    public void handleConfigPacket(FriendlyByteBuf buffer) {
        super.handleConfigPacket(buffer);
        for (int i = 11; i < 20; ++i) {
            this.inventory.set(i, buffer.m_130267_());
        }
        this.setRecipe();
        this.markChunkUnsaved();
    }

    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        boolean hasRecipe = this.craftResult.m_7928_() != null;
        buffer.writeBoolean(hasRecipe);
        if (hasRecipe) {
            buffer.m_130085_(this.craftResult.m_7928_().m_6423_());
        }
        return buffer;
    }

    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        if (buffer.readBoolean() && this.f_58857_ != null) {
            Optional possibleRecipe = this.f_58857_.m_7465_().m_44043_(buffer.m_130281_());
            possibleRecipe.ifPresent(recipe -> {
                this.curRecipe = CrafterRecipeManager.instance().getRecipe(recipe);
            });
        } else {
            this.curRecipe = null;
        }
    }
}

