/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.client.render;

import com.klikli_dev.theurgy.config.ClientConfig;
import com.klikli_dev.theurgy.item.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SulfurBEWLR
extends BlockEntityWithoutLevelRenderer {
    private static final SulfurBEWLR instance = new SulfurBEWLR();
    private static final ItemStack emptyJarStack = new ItemStack((ItemLike)ItemRegistry.EMPTY_JAR.get());
    private static final ItemStack labeledEmptyJarStack = new ItemStack((ItemLike)ItemRegistry.EMPTY_JAR_LABELED.get());
    private static final ItemStack labelStack = new ItemStack((ItemLike)ItemRegistry.JAR_LABEL.get());

    public SulfurBEWLR() {
        super(null, null);
    }

    public static SulfurBEWLR get() {
        return instance;
    }

    private static boolean isLeftHand(ItemTransforms.TransformType type) {
        return type == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND || type == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
    }

    public void m_108829_(ItemStack sulfurStack, ItemTransforms.TransformType pTransformType, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        boolean flatLighting;
        Boolean renderSource = (Boolean)ClientConfig.get().rendering.renderSulfurSourceItem.get();
        ItemStack jarStack = renderSource != false ? emptyJarStack : labeledEmptyJarStack;
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel model = itemRenderer.m_174264_(jarStack, null, null, 0);
        boolean bl = flatLighting = pTransformType == ItemTransforms.TransformType.GUI && !model.m_7547_();
        if (flatLighting) {
            Lighting.m_84930_();
        }
        itemRenderer.m_115143_(jarStack, pTransformType, SulfurBEWLR.isLeftHand(pTransformType), pPoseStack, pBuffer, pPackedLight, pPackedOverlay, model);
        if (renderSource.booleanValue()) {
            this.renderLabel(sulfurStack, pTransformType, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
            this.renderContainedItem(sulfurStack, pTransformType, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        }
    }

    public void renderLabel(ItemStack sulfurStack, ItemTransforms.TransformType pTransformType, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel labelModel = itemRenderer.m_174264_(labelStack, null, null, 0);
        pPoseStack.m_85836_();
        labelModel.applyTransform(pTransformType, pPoseStack, SulfurBEWLR.isLeftHand(pTransformType));
        pPoseStack.m_85836_();
        float pixel = 0.0625f;
        pPoseStack.m_85837_(0.0, 0.0, (double)pixel * 0.5);
        pPoseStack.m_85841_(1.0f, 1.0f, 0.01f);
        Lighting.m_84930_();
        itemRenderer.m_115143_(labelStack, ItemTransforms.TransformType.GUI, SulfurBEWLR.isLeftHand(pTransformType), pPoseStack, pBuffer, pPackedLight, pPackedOverlay, labelModel);
        pPoseStack.m_85849_();
        pPoseStack.m_85849_();
    }

    public void renderContainedItem(ItemStack sulfurStack, ItemTransforms.TransformType pTransformType, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack containedStack = AlchemicalSulfurItem.getSourceStack(sulfurStack);
        if (!containedStack.m_41619_()) {
            BakedModel containedModel = itemRenderer.m_174264_(containedStack, null, null, 0);
            BakedModel labelModel = itemRenderer.m_174264_(labelStack, null, null, 0);
            pPoseStack.m_85836_();
            labelModel.applyTransform(pTransformType, pPoseStack, SulfurBEWLR.isLeftHand(pTransformType));
            pPoseStack.m_85836_();
            float pixel = 0.0625f;
            pPoseStack.m_85837_(0.0, 0.0, (double)pixel * 0.6);
            float scale = 0.36f;
            pPoseStack.m_85841_(scale, scale, scale);
            pPoseStack.m_85837_(0.0, (double)(-pixel) * 3.2, 0.0);
            pPoseStack.m_85841_(0.74f, 0.74f, 0.01f);
            Lighting.m_84930_();
            itemRenderer.m_115143_(containedStack, ItemTransforms.TransformType.GUI, SulfurBEWLR.isLeftHand(pTransformType), pPoseStack, pBuffer, pPackedLight, pPackedOverlay, containedModel);
            pPoseStack.m_85849_();
            pPoseStack.m_85849_();
        }
    }
}

