/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.network;

import com.klikli_dev.theurgy.network.Message;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageHandler {
    public static <T extends Message> void handle(T message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.SERVER) {
            ctx.get().enqueueWork(() -> MessageHandler.handleServer(message, ctx));
        } else {
            ctx.get().enqueueWork(() -> ClientMessageHandler.handleClient(message, ctx));
        }
        ctx.get().setPacketHandled(true);
    }

    public static <T extends Message> void handleServer(T message, Supplier<NetworkEvent.Context> ctx) {
        MinecraftServer server = ctx.get().getSender().f_19853_.m_7654_();
        message.onServerReceived(server, ctx.get().getSender(), ctx.get());
    }

    public static class ClientMessageHandler {
        public static <T extends Message> void handleClient(T message, Supplier<NetworkEvent.Context> ctx) {
            Minecraft minecraft = Minecraft.m_91087_();
            message.onClientReceived(minecraft, (Player)minecraft.f_91074_, ctx.get());
        }
    }
}

