/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.network;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.network.MessageHandler;
import com.klikli_dev.theurgy.network.messages.MessageSetDivinationResult;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.filters.VanillaPacketSplitter;
import net.minecraftforge.network.simple.SimpleChannel;

public class Networking {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("theurgy", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int ID = 0;

    public static int nextID() {
        return ID++;
    }

    public static void registerMessages() {
        INSTANCE.registerMessage(Networking.nextID(), MessageSetDivinationResult.class, MessageSetDivinationResult::encode, MessageSetDivinationResult::new, MessageHandler::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static <T> void sendToSplit(ServerPlayer player, T message) {
        Packet vanillaPacket = INSTANCE.toVanillaPacket(message, NetworkDirection.PLAY_TO_CLIENT);
        ArrayList<Packet> packets = new ArrayList<Packet>();
        VanillaPacketSplitter.appendPackets((ConnectionProtocol)ConnectionProtocol.PLAY, (PacketFlow)PacketFlow.CLIENTBOUND, (Packet)vanillaPacket, packets);
        packets.forEach(arg_0 -> ((ServerGamePacketListenerImpl)player.f_8906_).m_9829_(arg_0));
    }

    public static <T> void sendTo(ServerPlayer player, T message) {
        if (player.f_8906_ == null) {
            Theurgy.LOGGER.warn("Tried to send message of type {} to player without connection. Id: {}, Name: {}.", new Object[]{player.m_20149_(), player.m_7755_().getString(), message.getClass().getName()});
            return;
        }
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <T> void sendToTracking(Entity entity, T message) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    public static <T> void sendToDimension(ResourceKey<Level> dimensionKey, T message) {
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> dimensionKey), message);
    }

    public static <T> void sendToServer(T message) {
        INSTANCE.sendToServer(message);
    }
}

