/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.tooltips;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.theurgy.tooltips.TooltipDataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class TooltipHandler {
    private static final Map<Item, TooltipDataProvider> tooltipDataProviders = new HashMap<Item, TooltipDataProvider>();
    private static final List<String> namespacesToListenFor = new ArrayList<String>();

    public static void onItemTooltipEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (namespacesToListenFor.contains(itemId.m_135827_())) {
            String tooltipKey = stack.m_41778_() + ".tooltip";
            String extendedTooltipKey = stack.m_41778_() + ".tooltip.extended";
            String usageTooltipKey = stack.m_41778_() + ".tooltip.usage";
            boolean tooltipExists = I18n.m_118936_((String)tooltipKey);
            boolean extendedTooltipExists = I18n.m_118936_((String)extendedTooltipKey);
            boolean usageTooltipExists = I18n.m_118936_((String)usageTooltipKey);
            List<MutableComponent> additionalTooltipData = TooltipHandler.getAdditionalTooltipData(stack);
            if (tooltipExists) {
                event.getToolTip().add(Component.m_237110_((String)tooltipKey, (Object[])additionalTooltipData.toArray()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
            }
            if (extendedTooltipExists) {
                if (Screen.m_96638_()) {
                    event.getToolTip().add(Component.m_237110_((String)extendedTooltipKey, (Object[])additionalTooltipData.toArray()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
                } else {
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.theurgy.show_extended", (Object[])additionalTooltipData.toArray()));
                }
            }
            if (usageTooltipExists) {
                if (Screen.m_96637_()) {
                    event.getToolTip().add(Component.m_237110_((String)usageTooltipKey, (Object[])additionalTooltipData.toArray()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
                } else {
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.theurgy.show_usage", (Object[])additionalTooltipData.toArray()));
                }
            }
        }
    }

    public static void registerTooltipDataProvider(Item item, TooltipDataProvider provider) {
        tooltipDataProviders.put(item, provider);
    }

    public static void registerNamespaceToListenTo(String namespace) {
        namespacesToListenFor.add(namespace);
    }

    public static List<MutableComponent> getAdditionalTooltipData(ItemStack stack) {
        TooltipDataProvider provider = tooltipDataProviders.get(stack.m_41720_());
        if (provider != null) {
            return provider.getTooltipData(stack);
        }
        return ImmutableList.of();
    }
}

