/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.start;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;

public abstract class LandmarkStructure
extends Structure
implements DecorationClearance,
ControlledSpawns {
    final ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig;
    final DecorationClearance.DecorationConfig decorationConfig;

    protected static <S extends LandmarkStructure> Products.P3<RecordCodecBuilder.Mu<S>, ControlledSpawns.ControlledSpawningConfig, DecorationClearance.DecorationConfig, Structure.StructureSettings> landmarkCodec(RecordCodecBuilder.Instance<S> instance) {
        return instance.group((App)ControlledSpawns.ControlledSpawningConfig.FLAT_CODEC.forGetter(s -> s.controlledSpawningConfig), (App)DecorationClearance.DecorationConfig.FLAT_CODEC.forGetter(s -> s.decorationConfig), (App)Structure.m_226567_(instance));
    }

    public LandmarkStructure(ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, DecorationClearance.DecorationConfig decorationConfig, Structure.StructureSettings structureSettings) {
        super(structureSettings);
        this.controlledSpawningConfig = controlledSpawningConfig;
        this.decorationConfig = decorationConfig;
    }

    @Override
    public boolean isSurfaceDecorationsAllowed() {
        return this.decorationConfig.surfaceDecorations();
    }

    @Override
    public boolean isUndergroundDecoAllowed() {
        return this.decorationConfig.undergroundDecorations();
    }

    @Override
    public boolean shouldAdjustToTerrain() {
        return this.decorationConfig.adjustElevation();
    }

    @Override
    public List<MobSpawnSettings.SpawnerData> getCombinedMonsterSpawnableList() {
        return this.controlledSpawningConfig.combinedMonsterSpawnableCache();
    }

    @Override
    public List<MobSpawnSettings.SpawnerData> getCombinedCreatureSpawnableList() {
        return this.controlledSpawningConfig.combinedCreatureSpawnableCache();
    }

    @Override
    public List<MobSpawnSettings.SpawnerData> getSpawnableList(MobCategory creatureType) {
        return switch (creatureType) {
            case MobCategory.MONSTER -> this.getSpawnableMonsterList(0);
            case MobCategory.AMBIENT -> this.controlledSpawningConfig.ambientCreatureList();
            case MobCategory.WATER_CREATURE -> this.controlledSpawningConfig.waterCreatureList();
            default -> List.of();
        };
    }

    @Override
    public List<MobSpawnSettings.SpawnerData> getSpawnableMonsterList(int index) {
        return this.controlledSpawningConfig.getForLabel("" + index);
    }
}

