/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.render.BlockEntityCustomItemRenderer;
import com.supermartijn642.core.render.CustomRendererBakedModelWrapper;
import com.supermartijn642.wirelesschargers.ChargerModelType;
import com.supermartijn642.wirelesschargers.ChargerRenderer;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.screen.ChargerScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class WirelessChargersClient {
    public static void register() {
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"wirelesschargers");
        for (ChargerType chargerType : ChargerType.values()) {
            handler.registerCustomBlockEntityRenderer(chargerType::getBlockEntityType, ChargerRenderer::new);
            ModelResourceLocation location = new ModelResourceLocation("wirelesschargers:" + chargerType.getRegistryName(), "inventory");
            handler.registerModelOverwrite((ResourceLocation)location, CustomRendererBakedModelWrapper::wrap);
            handler.registerCustomItemRenderer(chargerType::getItem, () -> new BlockEntityCustomItemRenderer(true, () -> type.createBlockEntity(BlockPos.f_121853_, type.getBlock().m_49966_()), (stack, entity) -> entity.readData(stack.m_41782_() ? stack.m_41783_().m_128469_("tileData") : new CompoundTag())));
        }
        for (ChargerModelType chargerModelType : ChargerModelType.values()) {
            handler.registerModel(chargerModelType.ringModel);
        }
    }

    public static void openChargerScreen(Component title, Level level, BlockPos pos) {
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new ChargerScreen(title, level, pos)));
    }
}

