/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.energy;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.DefaultChannelSettings;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.apiimpl.energy.EnergyConnectorSettings;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.commons.lang3.tuple.Pair;

public class EnergyChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    private List<Pair<SidedConsumer, EnergyConnectorSettings>> energyExtractors = null;
    private List<Pair<SidedConsumer, EnergyConnectorSettings>> energyConsumers = null;

    public JsonObject writeToJson() {
        return new JsonObject();
    }

    public void readFromJson(JsonObject data) {
    }

    public void readFromNBT(CompoundTag tag) {
    }

    public void writeToNBT(CompoundTag tag) {
    }

    public int getColors() {
        return 0;
    }

    public void tick(int channel, IControllerContext context) {
        this.updateCache(channel, context);
        Level world = context.getControllerWorld();
        int totalToDistribute = 0;
        HashMap<BlockPos, Integer> alreadyHandled = new HashMap<BlockPos, Integer>();
        ArrayList<Pair> energyProducers = new ArrayList<Pair>();
        for (Pair<SidedConsumer, EnergyConnectorSettings> entry : this.energyExtractors) {
            int level;
            Integer count;
            BlockEntity te;
            Direction side;
            BlockPos energyPos;
            BlockPos connectorPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).consumerId());
            if (connectorPos == null || !LevelTools.isLoaded((Level)world, (BlockPos)(energyPos = connectorPos.m_121945_(side = ((SidedConsumer)entry.getKey()).side()))) || !EnergyChannelSettings.isEnergyTE(te = world.m_7702_(energyPos), side.m_122424_())) continue;
            EnergyConnectorSettings settings = (EnergyConnectorSettings)((Object)entry.getValue());
            ConnectorTileEntity connectorTE = (ConnectorTileEntity)world.m_7702_(connectorPos);
            if (this.checkRedstone(world, settings, connectorPos) || !context.matchColor(settings.getColorsMask()) || (count = settings.getMinmax()) != null && (level = EnergyChannelSettings.getEnergyLevel(te, side.m_122424_())) < count) continue;
            Integer rate = settings.getRate();
            if (rate == null) {
                boolean advanced = ConnectorBlock.isAdvancedConnector(world, connectorPos);
                rate = advanced ? (Integer)Config.maxRfRateAdvanced.get() : (Integer)Config.maxRfRateNormal.get();
            }
            connectorTE.setEnergyInputFrom(side, rate);
            if (!alreadyHandled.containsKey(connectorPos)) {
                alreadyHandled.put(connectorPos, connectorTE.getEnergy());
            }
            int connectorEnergy = (Integer)alreadyHandled.get(connectorPos);
            int tosend = Math.min(rate, connectorEnergy);
            if (tosend <= 0) continue;
            alreadyHandled.put(connectorPos, connectorEnergy - tosend);
            totalToDistribute += tosend;
            energyProducers.add(Pair.of((Object)connectorTE, (Object)tosend));
        }
        if (totalToDistribute <= 0) {
            return;
        }
        if (!context.checkAndConsumeRF(((Integer)Config.controllerOperationRFT.get()).intValue())) {
            return;
        }
        int actuallyConsumed = this.insertEnergy(context, totalToDistribute);
        if (actuallyConsumed <= 0) {
            return;
        }
        for (Pair entry : energyProducers) {
            ConnectorTileEntity connectorTE = (ConnectorTileEntity)entry.getKey();
            int amount = (Integer)entry.getValue();
            int actuallySpent = Math.min(amount, actuallyConsumed);
            connectorTE.setEnergy(connectorTE.getEnergy() - actuallySpent);
            if ((actuallyConsumed -= actuallySpent) > 0) continue;
            break;
        }
    }

    private int insertEnergy(@Nonnull IControllerContext context, int energy) {
        int total = 0;
        Level world = context.getControllerWorld();
        for (Pair<SidedConsumer, EnergyConnectorSettings> entry : this.energyConsumers) {
            int level;
            Integer count;
            BlockEntity te;
            Direction side;
            BlockPos pos;
            EnergyConnectorSettings settings = (EnergyConnectorSettings)((Object)entry.getValue());
            BlockPos extractorPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).consumerId());
            if (extractorPos == null || !LevelTools.isLoaded((Level)world, (BlockPos)(pos = extractorPos.m_121945_(side = ((SidedConsumer)entry.getKey()).side()))) || !EnergyChannelSettings.isEnergyTE(te = world.m_7702_(pos), settings.getFacing()) || this.checkRedstone(world, settings, extractorPos) || !context.matchColor(settings.getColorsMask()) || (count = settings.getMinmax()) != null && (level = EnergyChannelSettings.getEnergyLevel(te, settings.getFacing())) >= count) continue;
            Integer rate = settings.getRate();
            if (rate == null) {
                boolean advanced = ConnectorBlock.isAdvancedConnector(world, extractorPos);
                rate = advanced ? (Integer)Config.maxRfRateAdvanced.get() : (Integer)Config.maxRfRateNormal.get();
            }
            int totransfer = Math.min(rate, energy);
            long e = EnergyTools.receiveEnergy((BlockEntity)te, (Direction)settings.getFacing(), (long)totransfer);
            energy = (int)((long)energy - e);
            total = (int)((long)total + e);
            if (energy > 0) continue;
            return total;
        }
        return total;
    }

    public static boolean isEnergyTE(@Nullable BlockEntity te, @Nonnull Direction side) {
        if (te == null) {
            return false;
        }
        return te.getCapability(CapabilityEnergy.ENERGY, side).isPresent();
    }

    public static int getEnergyLevel(BlockEntity tileEntity, @Nonnull Direction side) {
        if (tileEntity != null) {
            return tileEntity.getCapability(CapabilityEnergy.ENERGY, side).map(IEnergyStorage::getEnergyStored).orElse(0);
        }
        return 0;
    }

    public void cleanCache() {
        this.energyExtractors = null;
        this.energyConsumers = null;
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.energyExtractors == null) {
            EnergyConnectorSettings con;
            this.energyExtractors = new ArrayList<Pair<SidedConsumer, EnergyConnectorSettings>>();
            this.energyConsumers = new ArrayList<Pair<SidedConsumer, EnergyConnectorSettings>>();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                con = (EnergyConnectorSettings)((Object)entry.getValue());
                if (con.getEnergyMode() == EnergyConnectorSettings.EnergyMode.EXT) {
                    this.energyExtractors.add((Pair<SidedConsumer, EnergyConnectorSettings>)Pair.of((Object)((SidedConsumer)entry.getKey()), (Object)((Object)con)));
                    continue;
                }
                this.energyConsumers.add((Pair<SidedConsumer, EnergyConnectorSettings>)Pair.of((Object)((SidedConsumer)entry.getKey()), (Object)((Object)con)));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                con = (EnergyConnectorSettings)((Object)entry.getValue());
                if (con.getEnergyMode() != EnergyConnectorSettings.EnergyMode.INS) continue;
                this.energyConsumers.add((Pair<SidedConsumer, EnergyConnectorSettings>)Pair.of((Object)((SidedConsumer)entry.getKey()), (Object)((Object)con)));
            }
            this.energyExtractors.sort((o1, o2) -> ((EnergyConnectorSettings)((Object)((Object)o2.getRight()))).getPriority().compareTo(((EnergyConnectorSettings)((Object)((Object)o1.getRight()))).getPriority()));
            this.energyConsumers.sort((o1, o2) -> ((EnergyConnectorSettings)((Object)((Object)o2.getRight()))).getPriority().compareTo(((EnergyConnectorSettings)((Object)((Object)o1.getRight()))).getPriority()));
        }
    }

    public boolean isEnabled(String tag) {
        return true;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(iconGuiElements, 11, 80, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public void createGui(IEditorGui gui) {
    }

    public void update(Map<String, Object> data) {
    }
}

