/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import cofh.repack.codechicken.lib.render.uv.UV;
import cofh.repack.codechicken.lib.render.uv.UVTransformation;
import cofh.repack.codechicken.lib.util.Copyable;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Vector3;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class Vertex5
implements Copyable<Vertex5> {
    public Vector3 vec;
    public UV uv;

    public Vertex5() {
        this(new Vector3(), new UV());
    }

    public Vertex5(Vector3 vector3, UV uV) {
        this.vec = vector3;
        this.uv = uV;
    }

    public Vertex5(Vector3 vector3, double d, double d2) {
        this(vector3, new UV(d, d2));
    }

    public Vertex5(double d, double d2, double d3, double d4, double d5) {
        this(d, d2, d3, d4, d5, 0);
    }

    public Vertex5(double d, double d2, double d3, double d4, double d5, int n) {
        this(new Vector3(d, d2, d3), new UV(d4, d5, n));
    }

    public Vertex5 set(double d, double d2, double d3, double d4, double d5) {
        this.vec.set(d, d2, d3);
        this.uv.set(d4, d5);
        return this;
    }

    public Vertex5 set(double d, double d2, double d3, double d4, double d5, int n) {
        this.vec.set(d, d2, d3);
        this.uv.set(d4, d5, n);
        return this;
    }

    public Vertex5 set(Vertex5 vertex5) {
        this.vec.set(vertex5.vec);
        this.uv.set(vertex5.uv);
        return this;
    }

    public Vertex5(Vertex5 vertex5) {
        this(vertex5.vec.copy(), vertex5.uv.copy());
    }

    @Override
    public Vertex5 copy() {
        return new Vertex5(this);
    }

    public String toString() {
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        return "Vertex: (" + new BigDecimal(this.vec.x, mathContext) + ", " + new BigDecimal(this.vec.y, mathContext) + ", " + new BigDecimal(this.vec.z, mathContext) + ") (" + new BigDecimal(this.uv.u, mathContext) + ", " + new BigDecimal(this.uv.v, mathContext) + ") (" + this.uv.tex + ")";
    }

    public Vertex5 apply(Transformation transformation) {
        this.vec.apply(transformation);
        return this;
    }

    public Vertex5 apply(UVTransformation uVTransformation) {
        this.uv.apply(uVTransformation);
        return this;
    }
}

