/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.config.element;

import com.gitlab.cdagaming.craftpresence.core.config.Module;
import com.gitlab.cdagaming.craftpresence.core.config.element.ColorSection;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import java.awt.Color;
import java.io.Serializable;

public class ColorData
extends Module
implements Serializable {
    private static final ColorData DEFAULT = new ColorData();
    private final ColorSection start = new ColorSection();
    private ColorSection end;
    private String texLocation;

    public ColorData(ColorSection start, ColorSection end, String texLocation) {
        this.setStartColor(start);
        this.setEndColor(end);
        this.setTexLocation(texLocation);
    }

    public ColorData(ColorSection start, ColorSection end) {
        this(start, end, "");
    }

    public ColorData(ColorSection start, String texLocation) {
        this(start, null, texLocation);
    }

    public ColorData(ColorSection start) {
        this(start, "");
    }

    public ColorData(Color start, Color end, String texLocation) {
        this(new ColorSection(start), end != null ? new ColorSection(end) : null, texLocation);
    }

    public ColorData(Color start, Color end) {
        this(start, end, "");
    }

    public ColorData(Color start, String texLocation) {
        this(start, null, texLocation);
    }

    public ColorData(Color start) {
        this(start, "");
    }

    public ColorData(String texLocation) {
        this(new ColorSection(), texLocation);
    }

    public ColorData() {
        this("");
    }

    public ColorData(ColorData other) {
        this(other.start, other.end, other.texLocation);
    }

    @Override
    public ColorData getDefaults() {
        return new ColorData(DEFAULT);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof ColorData && !this.equals(target)) {
            ColorData data = (ColorData)target;
            this.setStartColor(data.start);
            this.setEndColor(data.end);
            this.setTexLocation(data.texLocation);
        }
    }

    @Override
    public ColorData copy() {
        return new ColorData(this);
    }

    public ColorSection getStart() {
        return new ColorSection(this.start);
    }

    public Color getStartColor() {
        return this.getStart().getColor();
    }

    public void setStartColor(ColorSection color) {
        if (color != null) {
            this.start.red = color.red;
            this.start.green = color.green;
            this.start.blue = color.blue;
            this.start.alpha = color.alpha;
        }
    }

    public ColorSection getEnd() {
        return new ColorSection(this.end != null ? this.end : this.start);
    }

    public Color getEndColor() {
        return this.getEnd().getColor();
    }

    public void setEndColor(ColorSection color) {
        if (color != null) {
            if (this.end == null) {
                this.end = new ColorSection();
            }
            this.end.red = color.red;
            this.end.green = color.green;
            this.end.blue = color.blue;
            this.end.alpha = color.alpha;
        } else {
            this.end = null;
        }
    }

    public String getTexLocation() {
        return StringUtils.isNullOrEmpty(this.texLocation) ? "" : this.texLocation;
    }

    public void setTexLocation(String texLocation) {
        this.texLocation = !StringUtils.isNullOrEmpty(texLocation) ? texLocation : null;
    }

    @Override
    public Object getProperty(String name) {
        return StringUtils.getField(ColorData.class, (Object)this, new String[0]);
    }

    @Override
    public void setProperty(String name, Object value) {
        StringUtils.updateField(ColorData.class, (Object)this, value, name);
    }
}

