/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets;

import com.gitlab.cdagaming.craftpresence.core.utils.MathUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ScrollPane;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.DynamicWidget;
import java.util.List;
import java.util.Objects;

public class TextDisplayWidget
implements DynamicWidget {
    private final ExtendedScreen parent;
    private int startX;
    private int startY;
    private int width;
    private int contentHeight;
    private String message;
    private List<String> renderLines;
    private boolean centered;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public TextDisplayWidget(ExtendedScreen parent, boolean centered, int startX, int startY, int width, String message) {
        this.parent = parent;
        this.setCentered(centered);
        this.setControlPosX(startX);
        this.setControlPosY(startY);
        this.setControlWidth(width);
        this.setMessage(message);
    }

    public TextDisplayWidget(ExtendedScreen parent, int startX, int startY, int width, String message) {
        this(parent, false, startX, startY, width, message);
    }

    public TextDisplayWidget(ExtendedScreen parent, boolean centered, int startX, int startY, int width) {
        this(parent, centered, startX, startY, width, "");
    }

    public TextDisplayWidget(ExtendedScreen parent, int startX, int startY, int width) {
        this(parent, false, startX, startY, width);
    }

    public TextDisplayWidget(ExtendedScreen parent, boolean centered, int width, String message) {
        this(parent, centered, 0, 0, width, message);
    }

    public TextDisplayWidget(ExtendedScreen parent, int width, String message) {
        this(parent, false, width, message);
    }

    public TextDisplayWidget(ExtendedScreen parent, boolean centered, int width) {
        this(parent, centered, width, "");
    }

    public TextDisplayWidget(ExtendedScreen parent, int width) {
        this(parent, false, width);
    }

    public String getMessage() {
        return this.message;
    }

    public TextDisplayWidget setMessage(String newMessage) {
        if (!Objects.equals(newMessage, this.message)) {
            this.message = newMessage;
            this.renderLines = this.refreshContent();
            this.parent.refreshContentHeight();
        }
        return this;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public TextDisplayWidget setCentered(boolean centered) {
        this.centered = centered;
        return this;
    }

    public List<String> getRenderLines() {
        return StringUtils.newArrayList(this.renderLines);
    }

    @Override
    public void draw(ExtendedScreen screen) {
        int padding = 0;
        if (screen instanceof ScrollPane) {
            padding = ((ScrollPane)screen).getPadding();
        }
        int xPos = this.getControlPosX() + padding;
        int currentY = this.getControlPosY() + padding;
        for (String line : this.getRenderLines()) {
            if (this.isCentered()) {
                screen.renderCenteredString(line, (float)this.getControlWidth() / 2.0f, currentY, 0xFFFFFF);
            } else {
                screen.renderString(line, xPos, currentY, 0xFFFFFF);
            }
            currentY += screen.getFontHeight() + 1;
        }
    }

    @Override
    public int getControlPosX() {
        return this.startX;
    }

    @Override
    public void setControlPosX(int posX) {
        this.startX = posX;
    }

    @Override
    public int getControlPosY() {
        return this.startY;
    }

    @Override
    public void setControlPosY(int posY) {
        this.startY = posY;
    }

    @Override
    public int getControlWidth() {
        return this.width - this.startX;
    }

    @Override
    public void setControlWidth(int width) {
        this.width = width;
    }

    @Override
    public int getControlHeight() {
        return this.contentHeight;
    }

    @Override
    public void setControlHeight(int height) {
        this.contentHeight = height;
    }

    private List<String> refreshContent() {
        int width = MathUtils.clamp(this.getControlWidth(), 0, this.parent.getMaxWidth());
        List<String> content = this.parent.createRenderLines(this.getMessage(), width);
        this.setControlHeight(content.size() * (this.parent.getFontHeight() + 1));
        return content;
    }
}

