/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.Button;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Display;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAsset;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.CheckBoxControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiScreen;

public class PresenceSettingsGui
extends ConfigurationGui<Display> {
    private final Display INSTANCE = this.getCurrentData().copy();
    private final PresenceData PRESENCE;
    private final boolean isDefaultModule;
    private final Consumer<PresenceData> onChangedCallback;
    private TextWidget detailsFormat;
    private TextWidget gameStateFormat;
    private TextWidget largeImageFormat;
    private TextWidget smallImageFormat;
    private TextWidget smallImageKeyFormat;
    private TextWidget largeImageKeyFormat;
    private TextWidget startTimeFormat;
    private TextWidget endTimeFormat;
    private CheckBoxControl useAsMainCheckbox;
    private CheckBoxControl enabledCheckbox;

    PresenceSettingsGui(GuiScreen parentScreen, PresenceData moduleData, Consumer<PresenceData> changedCallback) {
        super(parentScreen, "gui.config.title", "gui.config.title.presence_settings");
        PresenceData presenceData = this.PRESENCE = moduleData != null ? moduleData : this.getCurrentData().presenceData;
        if (this.PRESENCE.buttons.isEmpty()) {
            this.PRESENCE.buttons.put("default", new Button(this.getCurrentData().presenceData.buttons.get("default")));
        }
        this.isDefaultModule = moduleData != null && moduleData.equals(this.getCurrentData().presenceData);
        this.onChangedCallback = changedCallback;
    }

    PresenceSettingsGui(GuiScreen parentScreen) {
        this(parentScreen, CraftPresence.CONFIG.displaySettings.presenceData, (PresenceData output) -> {
            CraftPresence.CONFIG.displaySettings.presenceData = output;
        });
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        int checkboxCalc1 = this.getScreenWidth() / 2 - 160;
        this.detailsFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, "gui.config.name.display.details_message", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", CraftPresence.CLIENT.generateArgumentMessage("general.", "custom."))))));
        this.gameStateFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(1), 180, 20, "gui.config.name.display.game_state_message", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", CraftPresence.CLIENT.generateArgumentMessage("general.", "custom."))))));
        this.largeImageFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(2), 180, 20, "gui.config.name.display.large_image_message", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", CraftPresence.CLIENT.generateArgumentMessage("general.", "custom."))))));
        this.smallImageFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(3), 180, 20, "gui.config.name.display.small_image_message", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", CraftPresence.CLIENT.generateArgumentMessage("general.", "custom."))))));
        this.detailsFormat.setControlMessage(this.PRESENCE.details);
        this.gameStateFormat.setControlMessage(this.PRESENCE.gameState);
        this.largeImageFormat.setControlMessage(this.PRESENCE.largeImageText);
        this.smallImageFormat.setControlMessage(this.PRESENCE.smallImageText);
        if (!this.isDefaultModule) {
            this.enabledCheckbox = this.childFrame.addControl(new CheckBoxControl(checkboxCalc1, this.getButtonY(4), "gui.config.name.display.enabled", this.PRESENCE.enabled, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.enabled", new Object[0])))));
            this.useAsMainCheckbox = this.childFrame.addControl(new CheckBoxControl(calc2, this.getButtonY(4), "gui.config.name.display.use_as_main", this.PRESENCE.useAsMain, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.use_as_main", new Object[0])))));
        }
        this.smallImageKeyFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(5), 147, 20, "gui.config.name.display.small_image_key", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.icon", CraftPresence.CLIENT.generateArgumentMessage("general.", "custom."))))).setTitleXOffset(-16.0f));
        this.addIconSelector(this.childFrame, () -> this.smallImageKeyFormat, (attributeName, currentValue) -> {
            this.PRESENCE.smallImageKey = currentValue;
        });
        this.largeImageKeyFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(6), 147, 20, "gui.config.name.display.large_image_key", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.icon", CraftPresence.CLIENT.generateArgumentMessage("general.", "custom."))))).setTitleXOffset(-16.0f));
        this.addIconSelector(this.childFrame, () -> this.largeImageKeyFormat, (attributeName, currentValue) -> {
            this.PRESENCE.largeImageKey = currentValue;
        });
        this.smallImageKeyFormat.setControlMessage(this.PRESENCE.smallImageKey);
        this.largeImageKeyFormat.setControlMessage(this.PRESENCE.largeImageKey);
        this.startTimeFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(7), 180, 20, "gui.config.name.display.start_timestamp", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", CraftPresence.CLIENT.generateArgumentMessage("general.", "custom."))))));
        this.endTimeFormat = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(8), 180, 20, "gui.config.name.display.end_timestamp", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", CraftPresence.CLIENT.generateArgumentMessage("general.", "custom."))))));
        this.startTimeFormat.setControlMessage(this.PRESENCE.startTimestamp);
        this.endTimeFormat.setControlMessage(this.PRESENCE.endTimestamp);
        this.childFrame.addControl(new ExtendedButtonControl(calc1, this.getButtonY(9), 180, 20, "gui.config.name.display.button_messages", () -> this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.button", new Object[0]), CraftPresence.CLIENT.createButtonsList(this.PRESENCE.buttons), null, null, true, true, ScrollableListControl.RenderType.None, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.attributeName = "button_" + CraftPresence.CLIENT.createButtonsList(this.PRESENCE.buttons).size();
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.editor.add.new.prefilled", screenInstance.attributeName);
            screenInstance.primaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.secondaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            Button defaultData = this.PRESENCE.buttons.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(defaultData, "label") != null ? defaultData.label : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
            screenInstance.originalSecondaryMessage = Config.getProperty(defaultData, "url") != null ? defaultData.url : "";
            screenInstance.secondaryMessage = screenInstance.originalSecondaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.primaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.secondaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            screenInstance.overrideSecondaryRender = true;
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.display.edit_specific_button", attributeName);
            Button defaultData = this.PRESENCE.buttons.get("default");
            Button currentData = this.PRESENCE.buttons.get(attributeName);
            screenInstance.isPreliminaryData = currentData == null;
            screenInstance.originalPrimaryMessage = Config.getProperty(defaultData, "label") != null ? defaultData.label : "";
            screenInstance.originalSecondaryMessage = Config.getProperty(defaultData, "url") != null ? defaultData.url : "";
            screenInstance.primaryMessage = Config.getProperty(currentData, "label") != null ? currentData.label : screenInstance.originalPrimaryMessage;
            screenInstance.secondaryMessage = Config.getProperty(currentData, "url") != null ? currentData.url : screenInstance.originalSecondaryMessage;
        }, (screenInstance, secondaryText, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.PRESENCE.buttons.put(screenInstance.attributeName, new Button((String)inputText, (String)secondaryText));
        }, (screenInstance, secondaryText, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.PRESENCE.buttons.remove(screenInstance.attributeName);
        }, null, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.button_messages", new Object[0]))), (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.button_messages", new Object[0]))))))), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.button_messages", new Object[0]))), new String[0]));
        this.childFrame.addControl(new ExtendedButtonControl(calc2, this.getButtonY(9), 180, 20, "gui.config.name.display.dynamic_icons", () -> this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.CUSTOM_ASSET_LIST.keySet(), null, null, true, true, ScrollableListControl.RenderType.CustomDiscordAsset, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.primaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.secondaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.maxSecondaryLength = 32;
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage = this.getCurrentData().dynamicIcons.getOrDefault("default", "");
        }, (attributeName, screenInstance) -> {
            screenInstance.primaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.secondaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.maxSecondaryLength = 32;
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.display.edit_specific_icon", attributeName);
            screenInstance.originalPrimaryMessage = this.getCurrentData().dynamicIcons.getOrDefault("default", "");
            screenInstance.primaryMessage = this.getCurrentData().dynamicIcons.getOrDefault(attributeName, screenInstance.originalPrimaryMessage);
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().dynamicIcons.put((String)attributeName, (String)inputText);
            DiscordAsset asset = new DiscordAsset().setName((String)attributeName).setUrl((String)inputText).setType(DiscordAsset.AssetType.CUSTOM);
            if (!DiscordAssetUtils.CUSTOM_ASSET_LIST.containsKey(asset.getName())) {
                DiscordAssetUtils.CUSTOM_ASSET_LIST.put(asset.getName(), asset);
            }
            if (!asset.getName().equalsIgnoreCase("default")) {
                DiscordAssetUtils.ASSET_LIST.put(asset.getName(), asset);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().dynamicIcons.remove(attributeName);
            if (DiscordAssetUtils.CUSTOM_ASSET_LIST.containsKey(attributeName)) {
                DiscordAssetUtils.CUSTOM_ASSET_LIST.remove(attributeName);
                if (!attributeName.equalsIgnoreCase("default")) {
                    DiscordAssetUtils.ASSET_LIST.remove(attributeName);
                }
            }
        }, null, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_icons", new Object[0]))), (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_icons", new Object[0]))))))), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_icons", new Object[0]))), new String[0]));
        this.childFrame.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(10), 180, 20, "gui.config.name.display.dynamic_variables", () -> this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.item", new Object[0]), this.getCurrentData().dynamicVariables.keySet(), null, null, true, true, ScrollableListControl.RenderType.None, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.maxSecondaryLength = 32;
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage = this.getCurrentData().dynamicVariables.getOrDefault("default", "");
        }, (attributeName, screenInstance) -> {
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.maxSecondaryLength = 32;
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.item.edit_specific_item", attributeName);
            screenInstance.originalPrimaryMessage = this.getCurrentData().dynamicVariables.getOrDefault("default", "");
            screenInstance.primaryMessage = this.getCurrentData().dynamicVariables.getOrDefault(attributeName, screenInstance.originalPrimaryMessage);
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().dynamicVariables.put((String)attributeName, (String)inputText);
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().dynamicVariables.remove(attributeName);
        }, null, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_variables", new Object[0]))), (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_variables", new Object[0]))))))), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_variables", new Object[0]))), new String[0]));
    }

    @Override
    protected void applySettings() {
        if (!this.detailsFormat.getControlMessage().equals(this.PRESENCE.details)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.PRESENCE.details = this.detailsFormat.getControlMessage();
        }
        if (!this.gameStateFormat.getControlMessage().equals(this.PRESENCE.gameState)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.PRESENCE.gameState = this.gameStateFormat.getControlMessage();
        }
        if (!this.largeImageFormat.getControlMessage().equals(this.PRESENCE.largeImageText)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.PRESENCE.largeImageText = this.largeImageFormat.getControlMessage();
        }
        if (!this.smallImageFormat.getControlMessage().equals(this.PRESENCE.smallImageText)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.PRESENCE.smallImageText = this.smallImageFormat.getControlMessage();
        }
        if (!this.isDefaultModule) {
            if (this.enabledCheckbox.isChecked() != this.PRESENCE.enabled) {
                CraftPresence.CONFIG.hasChanged = true;
                this.PRESENCE.enabled = this.enabledCheckbox.isChecked();
            }
            if (this.useAsMainCheckbox.isChecked() != this.PRESENCE.useAsMain) {
                CraftPresence.CONFIG.hasChanged = true;
                this.PRESENCE.useAsMain = this.useAsMainCheckbox.isChecked();
            }
        }
        if (!this.largeImageKeyFormat.getControlMessage().equals(this.PRESENCE.largeImageKey)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.PRESENCE.largeImageKey = this.largeImageKeyFormat.getControlMessage();
        }
        if (!this.smallImageKeyFormat.getControlMessage().equals(this.PRESENCE.smallImageKey)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.PRESENCE.smallImageKey = this.smallImageKeyFormat.getControlMessage();
        }
        if (!this.startTimeFormat.getControlMessage().equals(this.PRESENCE.startTimestamp)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.PRESENCE.startTimestamp = this.startTimeFormat.getControlMessage();
        }
        if (!this.endTimeFormat.getControlMessage().equals(this.PRESENCE.endTimestamp)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.PRESENCE.endTimestamp = this.endTimeFormat.getControlMessage();
        }
        if (this.onChangedCallback != null) {
            this.onChangedCallback.accept(this.PRESENCE);
        }
    }

    @Override
    protected Display getOriginalData() {
        return this.INSTANCE;
    }

    @Override
    protected Display getCurrentData() {
        return CraftPresence.CONFIG.displaySettings;
    }

    @Override
    protected boolean setCurrentData(Display data) {
        if (!this.getCurrentData().equals(data)) {
            this.getCurrentData().transferFrom(data);
            CraftPresence.CONFIG.hasChanged = true;
            return true;
        }
        return false;
    }
}

