/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Server;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.PresenceSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import net.minecraft.client.gui.GuiScreen;

public class ServerSettingsGui
extends ConfigurationGui<Server> {
    private final Server INSTANCE;
    private final Server DEFAULTS = this.getCurrentData().getDefaults();
    private final ModuleData defaultData;
    private ExtendedButtonControl serverMessagesButton;
    private TextWidget defaultMOTD;
    private TextWidget defaultName;
    private TextWidget defaultMessage;
    private TextWidget defaultIcon;
    private String currentIcon;

    ServerSettingsGui(GuiScreen parentScreen) {
        super(parentScreen, "gui.config.title", "gui.config.title.server_messages");
        this.INSTANCE = this.getCurrentData().copy();
        this.defaultData = this.getCurrentData().serverData.get("default");
        this.currentIcon = this.getCurrentData().fallbackServerIcon;
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        String defaultServerMessage = Config.getProperty(this.defaultData, "textOverride") != null ? this.defaultData.getTextOverride() : "";
        this.defaultName = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, "gui.config.name.server_messages.server_name", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_name", new Object[0])))));
        this.defaultName.setControlMessage(this.getCurrentData().fallbackServerName);
        this.defaultMOTD = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(1), 180, 20, "gui.config.name.server_messages.server_motd", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_motd", new Object[0])))));
        this.defaultMOTD.setControlMessage(this.getCurrentData().fallbackServerMotd);
        this.defaultMessage = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(2), 180, 20, "gui.config.message.default.server", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player."))))));
        this.defaultMessage.setControlMessage(defaultServerMessage);
        this.defaultIcon = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(3), 147, 20, "gui.config.name.server_messages.server_icon", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_icon", new Object[0])))).setTitleXOffset(-16.0f));
        this.addIconSelector(this.childFrame, () -> this.defaultIcon, (attributeName, currentValue) -> {
            this.currentIcon = currentValue;
        });
        this.defaultIcon.setControlMessage(this.currentIcon);
        this.serverMessagesButton = this.childFrame.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(4), 180, 20, "gui.config.name.server_messages.server_messages", () -> this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.server", new Object[0]), CraftPresence.SERVER.knownAddresses, null, null, true, true, ScrollableListControl.RenderType.ServerData, (attributeName, currentValue) -> {
            ModuleData defaultServerData = this.getCurrentData().serverData.get("default");
            ModuleData currentServerData = this.getCurrentData().serverData.get(attributeName);
            String defaultMessage = Config.getProperty(defaultServerData, "textOverride") != null ? defaultServerData.getTextOverride() : "";
            String currentMessage = Config.getProperty(currentServerData, "textOverride") != null ? currentServerData.getTextOverride() : "";
            CraftPresence.CONFIG.hasChanged = true;
            ModuleData newData = new ModuleData();
            if (StringUtils.isNullOrEmpty(currentMessage) || currentMessage.equals(defaultMessage)) {
                newData.setTextOverride(defaultMessage);
            }
            newData.setIconOverride((String)currentValue);
            this.getCurrentData().serverData.put((String)attributeName, newData);
        }, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getCurrentData().serverData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getCurrentData().serverData.get("default");
            screenInstance.currentData = this.getCurrentData().serverData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.server.edit_specific_server", attributeName);
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, (screenInstance, attributeName, inputText) -> {
            screenInstance.currentData.setTextOverride((String)inputText);
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().serverData.put((String)attributeName, screenInstance.currentData);
            if (!CraftPresence.SERVER.knownAddresses.contains(attributeName)) {
                CraftPresence.SERVER.knownAddresses.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().serverData.remove(attributeName);
            if (!CraftPresence.SERVER.defaultAddresses.contains(attributeName)) {
                CraftPresence.SERVER.knownAddresses.remove(attributeName);
            }
        }, (attributeName, screenInstance, isPresenceButton) -> {
            if (isPresenceButton.booleanValue()) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                this.openScreen(new PresenceSettingsGui((GuiScreen)screenInstance, currentPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                String defaultIcon = Config.getProperty(screenInstance.defaultData, "iconOverride") != null ? screenInstance.defaultData.getIconOverride() : this.getCurrentData().fallbackServerIcon;
                String specificIcon = Config.getProperty(screenInstance.currentData, "iconOverride") != null ? screenInstance.currentData.getIconOverride() : defaultIcon;
                this.openScreen(new SelectorGui((GuiScreen)screenInstance, Constants.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), specificIcon, (String)attributeName, true, false, ScrollableListControl.RenderType.DiscordAsset, (innerAttributeName, innerCurrentValue) -> screenInstance.currentData.setIconOverride((String)innerCurrentValue), null));
            }
        }, (attributeName, screenInstance) -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")))))))), () -> {
            if (!this.serverMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.server_messages.server_messages", new Object[0]))));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player."))));
            }
        }, new String[0]));
        this.proceedButton.setOnHover(() -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        });
    }

    @Override
    protected boolean canReset() {
        return !this.getCurrentData().equals(this.DEFAULTS);
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected boolean resetData() {
        return this.setCurrentData(this.DEFAULTS);
    }

    @Override
    protected boolean canSync() {
        return true;
    }

    @Override
    protected boolean allowedToSync() {
        return true;
    }

    @Override
    protected boolean syncData() {
        return this.setCurrentData(Config.loadOrCreate().serverSettings);
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.defaultMessage.getControlMessage()) || !StringUtils.isNullOrEmpty(this.defaultName.getControlMessage()) || !StringUtils.isNullOrEmpty(this.defaultMOTD.getControlMessage()));
        this.serverMessagesButton.setControlEnabled(CraftPresence.SERVER.enabled);
    }

    @Override
    protected void applySettings() {
        String defaultServerMessage;
        String string = defaultServerMessage = Config.getProperty(this.defaultData, "textOverride") != null ? this.defaultData.getTextOverride() : "";
        if (!this.defaultName.getControlMessage().equals(this.getCurrentData().fallbackServerName)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().fallbackServerName = this.defaultName.getControlMessage();
        }
        if (!this.defaultMOTD.getControlMessage().equals(this.getCurrentData().fallbackServerMotd)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().fallbackServerMotd = this.defaultMOTD.getControlMessage();
        }
        if (!this.defaultMessage.getControlMessage().equals(defaultServerMessage)) {
            CraftPresence.CONFIG.hasChanged = true;
            ModuleData defaultServerData = this.getCurrentData().serverData.getOrDefault("default", new ModuleData());
            defaultServerData.setTextOverride(this.defaultMessage.getControlMessage());
            this.getCurrentData().serverData.put("default", defaultServerData);
        }
        if (!this.defaultIcon.getControlMessage().equals(this.getCurrentData().fallbackServerIcon)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().fallbackServerIcon = this.defaultIcon.getControlMessage();
        }
    }

    @Override
    protected Server getOriginalData() {
        return this.INSTANCE;
    }

    @Override
    protected Server getCurrentData() {
        return CraftPresence.CONFIG.serverSettings;
    }

    @Override
    protected boolean setCurrentData(Server data) {
        if (!this.getCurrentData().equals(data)) {
            this.getCurrentData().transferFrom(data);
            CraftPresence.CONFIG.hasChanged = true;
            return true;
        }
        return false;
    }
}

