/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.world;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.craftpresence.core.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.MappingUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import external.io.github.classgraph.ClassInfo;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import java.util.List;
import java.util.Map;
import net.minecraft.world.WorldProvider;

public class DimensionUtils
implements Module {
    private final List<WorldProvider> DIMENSION_TYPES = StringUtils.newArrayList();
    public boolean enabled = false;
    public List<String> DIMENSION_NAMES = StringUtils.newArrayList();
    public List<String> DEFAULT_NAMES = StringUtils.newArrayList();
    private boolean isInUse = false;
    private boolean hasScanned = false;
    private String CURRENT_DIMENSION_NAME;
    private String CURRENT_DIMENSION_IDENTIFIER;
    private WorldProvider CURRENT_DIMENSION;

    @Override
    public void emptyData() {
        this.hasScanned = false;
        this.DEFAULT_NAMES.clear();
        this.DIMENSION_NAMES.clear();
        this.DIMENSION_TYPES.clear();
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.CURRENT_DIMENSION = null;
        this.CURRENT_DIMENSION_NAME = null;
        this.CURRENT_DIMENSION_IDENTIFIER = null;
        this.setInUse(false);
        CraftPresence.CLIENT.removeArguments("dimension", "data.dimension");
        CraftPresence.CLIENT.clearOverride("dimension.message", "dimension.icon");
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.generalSettings.detectDimensionData : this.enabled;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned && this.canFetchData();
        if (needsUpdate) {
            this.scanForData();
            this.hasScanned = true;
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
    }

    @Override
    public void updateData() {
        WorldProvider newProvider = CraftPresence.player.field_70170_p.field_73011_w;
        String newDimensionName = StringUtils.formatIdentifier(newProvider.func_80007_l(), false, !CraftPresence.CONFIG.advancedSettings.formatWords);
        String newDimension_primaryIdentifier = StringUtils.formatIdentifier(newProvider.func_80007_l(), true, !CraftPresence.CONFIG.advancedSettings.formatWords);
        String newDimension_alternativeIdentifier = StringUtils.formatIdentifier(MappingUtils.getClassName(newProvider), true, !CraftPresence.CONFIG.advancedSettings.formatWords);
        String newDimension_Identifier = StringUtils.getOrDefault(newDimension_primaryIdentifier, newDimension_alternativeIdentifier);
        if (!newDimensionName.equals(this.CURRENT_DIMENSION_NAME) || !newDimension_Identifier.equals(this.CURRENT_DIMENSION_IDENTIFIER)) {
            this.CURRENT_DIMENSION = newProvider;
            this.CURRENT_DIMENSION_NAME = StringUtils.getOrDefault(newDimensionName, newDimension_Identifier);
            this.CURRENT_DIMENSION_IDENTIFIER = newDimension_Identifier;
            if (!this.DEFAULT_NAMES.contains(newDimension_Identifier)) {
                this.DEFAULT_NAMES.add(newDimension_Identifier);
            }
            if (!this.DIMENSION_NAMES.contains(newDimension_Identifier)) {
                this.DIMENSION_NAMES.add(newDimension_Identifier);
            }
            if (!this.DIMENSION_TYPES.contains(newProvider)) {
                this.DIMENSION_TYPES.add(newProvider);
            }
            this.updatePresence();
        }
    }

    @Override
    public void updatePresence() {
        ModuleData defaultData = CraftPresence.CONFIG.dimensionSettings.dimensionData.get("default");
        ModuleData currentData = CraftPresence.CONFIG.dimensionSettings.dimensionData.get(this.CURRENT_DIMENSION_IDENTIFIER);
        String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
        String currentMessage = Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage;
        String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_DIMENSION_IDENTIFIER;
        String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
        String formattedIcon = CraftPresence.CLIENT.imageOf("dimension.icon", true, currentIcon, CraftPresence.CONFIG.dimensionSettings.fallbackDimensionIcon);
        CraftPresence.CLIENT.syncArgument("dimension.default.icon", CraftPresence.CONFIG.dimensionSettings.fallbackDimensionIcon);
        CraftPresence.CLIENT.syncArgument("data.dimension.instance", this.CURRENT_DIMENSION);
        CraftPresence.CLIENT.syncArgument("data.dimension.class", this.CURRENT_DIMENSION.getClass());
        CraftPresence.CLIENT.syncArgument("dimension.name", this.CURRENT_DIMENSION_NAME);
        CraftPresence.CLIENT.syncOverride(currentData != null ? currentData : defaultData, "dimension.message", "dimension.icon");
        CraftPresence.CLIENT.syncArgument("dimension.message", currentMessage);
        CraftPresence.CLIENT.syncArgument("dimension.icon", formattedIcon);
        CraftPresence.CLIENT.syncTimestamp("data.dimension.time");
    }

    private List<WorldProvider> getDimensionTypes() {
        List<WorldProvider> dimensionTypes;
        block8: {
            dimensionTypes = StringUtils.newArrayList();
            if (!dimensionTypes.isEmpty()) break block8;
            Map reflectedDimensionTypes = (Map)StringUtils.getField("net.minecraftforge.common.DimensionManager", null, "providers");
            if (reflectedDimensionTypes != null) {
                for (Object objectType : reflectedDimensionTypes.values()) {
                    try {
                        WorldProvider type = objectType instanceof Class ? (WorldProvider)((Class)objectType).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : null;
                        if (type == null || dimensionTypes.contains(type)) continue;
                        dimensionTypes.add(type);
                    }
                    catch (Throwable ex) {
                        Constants.LOG.debugError(ex);
                    }
                }
            } else {
                for (ClassInfo classInfo : FileUtils.getClassNamesMatchingSuperType(WorldProvider.class, new String[0]).values()) {
                    if (classInfo == null) continue;
                    try {
                        WorldProvider providerObj;
                        Class<?> classObj = FileUtils.findValidClass(MappingUtils.CLASS_LOADER, true, classInfo.getName());
                        if (classObj == null || dimensionTypes.contains(providerObj = (WorldProvider)classObj.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]))) continue;
                        dimensionTypes.add(providerObj);
                    }
                    catch (Throwable ex) {
                        Constants.LOG.debugError(ex);
                    }
                }
            }
        }
        return dimensionTypes;
    }

    @Override
    public void getAllData() {
        for (WorldProvider TYPE : this.getDimensionTypes()) {
            if (TYPE == null) continue;
            String dimensionName = StringUtils.getOrDefault(TYPE.func_80007_l(), MappingUtils.getClassName(TYPE));
            String name = StringUtils.formatIdentifier(dimensionName, true, !CraftPresence.CONFIG.advancedSettings.formatWords);
            if (!this.DEFAULT_NAMES.contains(name)) {
                this.DEFAULT_NAMES.add(name);
            }
            if (!this.DIMENSION_NAMES.contains(name)) {
                this.DIMENSION_NAMES.add(name);
            }
            if (this.DIMENSION_TYPES.contains(TYPE)) continue;
            this.DIMENSION_TYPES.add(TYPE);
        }
        for (String dimensionEntry : CraftPresence.CONFIG.dimensionSettings.dimensionData.keySet()) {
            String name;
            if (StringUtils.isNullOrEmpty(dimensionEntry) || this.DIMENSION_NAMES.contains(name = StringUtils.formatIdentifier(dimensionEntry, true, !CraftPresence.CONFIG.advancedSettings.formatWords))) continue;
            this.DIMENSION_NAMES.add(name);
        }
    }

    @Override
    public boolean canFetchData() {
        return FileUtils.canScanClasses();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }
}

