/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.BoP;

import biomesoplenty.api.content.BOPCBlocks;
import com.github.bartimaeusnek.cropspp.CCropUtility;
import com.github.bartimaeusnek.cropspp.abstracts.BasicCrop;
import ic2.api.crops.ICropTile;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class Bamboo
extends BasicCrop {
    public String name() {
        return "Bamboo";
    }

    @Override
    public String discoveredBy() {
        return "Minepolz320";
    }

    public int tier() {
        return 2;
    }

    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)((double)humidity * 1.3 + (double)nutrients * 1.2 + (double)air * 0.8);
    }

    public int stat(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    public String[] attributes() {
        return new String[]{"Green", "Pointed", "Edgy"};
    }

    public int maxSize() {
        return 3;
    }

    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < 3;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() > 1;
    }

    @Override
    public int getOptimalHavestSize(ICropTile crop) {
        return 3;
    }

    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(BOPCBlocks.bamboo, crop.getSize() - 1);
    }

    public int growthDuration(ICropTile crop) {
        if (CCropUtility.isRainingOn(crop)) {
            return 100;
        }
        return 150;
    }

    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        if (!entity.func_70093_af()) {
            CCropUtility.damageEntity(entity, 1.0f);
        }
        return false;
    }
}

