/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.cpp;

import biomesoplenty.api.content.BOPCBlocks;
import com.github.bartimaeusnek.croploadcore.ModsLoaded;
import com.github.bartimaeusnek.cropspp.CCropUtility;
import com.github.bartimaeusnek.cropspp.abstracts.BasicDecorationCrop;
import com.github.bartimaeusnek.cropspp.croploader.CropLoader;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CactiCrop
extends BasicDecorationCrop {
    public CactiCrop() {
        if (ModsLoaded.BoP) {
            Crops.instance.registerBaseSeed(new ItemStack(BOPCBlocks.plants, 1, 12), CropLoader.CropunpackerCC(new CropLoader(this)), 1, 1, 1, 1);
        }
    }

    @Override
    public int tier() {
        return 3;
    }

    public String name() {
        return "Cactus";
    }

    public String[] attributes() {
        return new String[]{"Green", "Cactus"};
    }

    public ItemStack getGain(ICropTile crop) {
        if (ModsLoaded.BoP && crop.getSize() == 2) {
            return new ItemStack(BOPCBlocks.plants, 1, 12);
        }
        return new ItemStack(Item.func_150899_d((int)81), 1, 0);
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() >= 2;
    }

    @Override
    public List<String> getCropInformation() {
        return Arrays.asList("Has increased air and nutrients requirements (x1.25)", "Has decreased humidity requirements (x0.5)", "Hurt Player on collision");
    }

    @Override
    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)((double)humidity * 0.5 + (double)nutrients * 1.25 + (double)air * 1.25);
    }

    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        if (!entity.func_70093_af()) {
            CCropUtility.damageEntity(entity, 1.0f);
        }
        return super.onEntityCollision(crop, entity);
    }

    @Override
    public ItemStack getDisplayItem() {
        return new ItemStack(Item.func_150899_d((int)81), 1, 0);
    }
}

