/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.natura.nether;

import biomesoplenty.api.content.BOPCBlocks;
import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicNetherBerryCrop;
import ic2.api.crops.ICropTile;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class BasicNetherShroomCrop
extends BasicNetherBerryCrop {
    private String name;

    public BasicNetherShroomCrop(String color) {
        this.name = color.equals("Purple") || color.equals("Blue") || color.equals("Green") ? color + " Glowshroom" : "Glowshroom";
    }

    public String name() {
        return this.name;
    }

    @Override
    public int tier() {
        return 3;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public int growthDuration(ICropTile crop) {
        return ConfigValues.debug ? 1 : 600;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == 2;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < 2;
    }

    @Override
    public int maxSize() {
        return 2;
    }

    public String[] attributes() {
        String[] r = new String[]{"Food", "Mushroom", "Ingredient", "Nether"};
        return r;
    }

    public ItemStack getGain(ICropTile crop) {
        ItemStack r = this.name.contains("Blue") ? new ItemStack((Block)NContent.glowshroom, 1, 2) : (this.name.contains("Green") ? new ItemStack((Block)NContent.glowshroom, 1, 0) : (this.name.contains("Purple") ? new ItemStack((Block)NContent.glowshroom, 1, 1) : new ItemStack(BOPCBlocks.mushrooms, 1, 3)));
        return r;
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        return 1;
    }

    @Override
    public ItemStack getDisplayItem() {
        ItemStack r = this.name.contains("Blue") ? new ItemStack((Block)NContent.glowshroom, 1, 2) : (this.name.contains("Green") ? new ItemStack((Block)NContent.glowshroom, 1, 0) : (this.name.contains("Purple") ? new ItemStack((Block)NContent.glowshroom, 1, 1) : new ItemStack(BOPCBlocks.mushrooms, 1, 3)));
        return r;
    }
}

