/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.block.general.redstone;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.base.itemblock.ItemBlockMeta;
import gtPlusPlus.core.tileentities.general.redstone.TileEntityRedstoneHandler;
import gtPlusPlus.core.util.minecraft.InventoryUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockGenericRedstone
extends BlockContainer {
    private final HashMap<Integer, HashMap<ForgeDirection, IIcon>> mTextures = new HashMap();

    public BlockGenericRedstone(String aUnlocalizedSuffix, String aDisplayName) {
        super(Material.field_151591_t);
        this.func_149663_c("blockGenericRedstone." + aUnlocalizedSuffix);
        this.func_149711_c(3.0f);
        this.func_149647_a(AddToCreativeTab.tabMachines);
        GameRegistry.registerBlock((Block)this, ItemBlockMeta.class, (String)("blockGenericRedstone." + aUnlocalizedSuffix));
    }

    public HashMap<Integer, HashMap<ForgeDirection, IIcon>> getTextureArray() {
        return this.mTextures;
    }

    public abstract void generateTextureArray(IIconRegister var1);

    @SideOnly(value=Side.CLIENT)
    public final void func_149651_a(IIconRegister iicon) {
        this.generateTextureArray(iicon);
        this.field_149761_L = iicon.func_94245_a("redstone_block");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float lx, float ly, float lz) {
        if (world.field_72995_K) {
            return true;
        }
        boolean mDidTool = false;
        try {
            ItemStack mHandStack = PlayerUtils.getItemStackInPlayersHand(world, player.getDisplayName());
            Item mHandItem = mHandStack.func_77973_b();
            if (ItemUtils.isItemGregtechTool(mHandStack)) {
                Logger.INFO("Found Tool in players hand!");
                TileEntityRedstoneHandler tile = (TileEntityRedstoneHandler)world.func_147438_o(x, y, z);
                if (tile != null) {
                    if (tile.isScrewdriverable() && ItemUtils.isToolScrewdriver(mHandStack)) {
                        mDidTool = tile.onScrewdriverRMB();
                        PlayerUtils.messagePlayer(player, "Adjusted Light level by 0.0625f. " + tile.getLightBrightness());
                    }
                    if (tile.isMalletable() && ItemUtils.isToolMallet(mHandStack)) {
                        mDidTool = tile.onMalletRMB();
                        PlayerUtils.messagePlayer(player, "Light Mode active: " + mDidTool);
                    }
                    if (tile.isWrenchable() && ItemUtils.isToolWrench(mHandStack)) {
                        mDidTool = tile.onWrenchRMB();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mDidTool;
    }

    public void func_149699_a(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        boolean mDidTool = false;
        try {
            TileEntityRedstoneHandler tile;
            ItemStack mHandStack = PlayerUtils.getItemStackInPlayersHand(aWorld, aPlayer.getDisplayName());
            Item mHandItem = mHandStack.func_77973_b();
            if (mHandItem instanceof GT_MetaGenerated_Tool_01 && (tile = (TileEntityRedstoneHandler)aWorld.func_147438_o(aX, aY, aZ)) != null) {
                if (tile.isScrewdriverable() && ItemUtils.isToolScrewdriver(mHandStack)) {
                    mDidTool = tile.onScrewdriverLMB();
                }
                if (tile.isMalletable() && ItemUtils.isToolMallet(mHandStack)) {
                    mDidTool = tile.onMalletLMB();
                }
                if (tile.isWrenchable() && ItemUtils.isToolWrench(mHandStack)) {
                    mDidTool = tile.onWrenchLMB();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (mDidTool || aPlayer.field_71075_bZ.field_75098_d) {
            return;
        }
        super.func_149699_a(aWorld, aX, aY, aZ, aPlayer);
    }

    public abstract TileEntity func_149915_a(World var1, int var2);

    public void func_149749_a(World world, int x, int y, int z, Block block, int number) {
        InventoryUtils.dropInventoryItems(world, x, y, z, block);
        super.func_149749_a(world, x, y, z, block, number);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (stack.func_82837_s()) {
            ((TileEntityRedstoneHandler)world.func_147438_o(x, y, z)).setCustomName(stack.func_82833_r());
        }
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int func_149750_m() {
        return super.func_149750_m();
    }

    public int func_149660_a(World p_149660_1_, int p_149660_2_, int p_149660_3_, int p_149660_4_, int p_149660_5_, float p_149660_6_, float p_149660_7_, float p_149660_8_, int p_149660_9_) {
        return super.func_149660_a(p_149660_1_, p_149660_2_, p_149660_3_, p_149660_4_, p_149660_5_, p_149660_6_, p_149660_7_, p_149660_8_, p_149660_9_);
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityRedstoneHandler aThis = this.getTileEntity(world, x, y, z);
        if (aThis != null) {
            return aThis.isProvidingWeakPower(world, x, y, z, side);
        }
        return 0;
    }

    public boolean func_149744_f() {
        return false;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityRedstoneHandler aThis = this.getTileEntity(world, x, y, z);
        if (aThis != null) {
            return aThis.isProvidingStrongPower(world, x, y, z, side);
        }
        return 0;
    }

    public boolean func_149740_M() {
        return super.func_149740_M();
    }

    public int func_149736_g(World p_149736_1_, int p_149736_2_, int p_149736_3_, int p_149736_4_, int p_149736_5_) {
        return super.func_149736_g(p_149736_1_, p_149736_2_, p_149736_3_, p_149736_4_, p_149736_5_);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityRedstoneHandler aThis = this.getTileEntity(world, x, y, z);
        if (aThis != null) {
            return aThis.canConnectRedstone(world, x, y, z, side);
        }
        return false;
    }

    public boolean shouldCheckWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityRedstoneHandler aThis = this.getTileEntity(world, x, y, z);
        if (aThis != null) {
            return aThis.shouldCheckWeakPower(world, x, y, z, side);
        }
        return this.func_149721_r();
    }

    public boolean getWeakChanges(IBlockAccess world, int x, int y, int z) {
        TileEntityRedstoneHandler aThis = this.getTileEntity(world, x, y, z);
        if (aThis != null) {
            return aThis.getWeakChanges(world, x, y, z);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract IIcon func_149691_a(int var1, int var2);

    public int func_149692_a(int damage) {
        return damage;
    }

    public abstract void func_149666_a(Item var1, CreativeTabs var2, List var3);

    public void func_149726_b(World aWorld, int aX, int aY, int aZ) {
        TileEntityRedstoneHandler aThis = this.getTileEntity((IBlockAccess)aWorld, aX, aY, aZ);
        if (!aWorld.field_72995_K) {
            if (aThis.hasUpdatedRecently() && !aWorld.func_72864_z(aX, aY, aZ)) {
                aWorld.func_147464_a(aX, aY, aZ, (Block)this, 4);
            } else if (!aThis.hasUpdatedRecently() && aWorld.func_72864_z(aX, aY, aZ)) {
                aWorld.func_147465_d(aX, aY, aZ, Blocks.field_150374_bv, 0, 2);
            }
        }
    }

    public void func_149695_a(World aWorld, int aX, int aY, int aZ, Block p_149695_5_) {
        TileEntityRedstoneHandler aThis = this.getTileEntity((IBlockAccess)aWorld, aX, aY, aZ);
        if (!aWorld.field_72995_K) {
            if (aThis.hasUpdatedRecently() && !aWorld.func_72864_z(aX, aY, aZ)) {
                aWorld.func_147464_a(aX, aY, aZ, (Block)this, 4);
            } else if (!aThis.hasUpdatedRecently() && aWorld.func_72864_z(aX, aY, aZ)) {
                aWorld.func_147465_d(aX, aY, aZ, Blocks.field_150374_bv, 0, 2);
            }
        }
    }

    public void func_149674_a(World aWorld, int aX, int aY, int aZ, Random p_149674_5_) {
        TileEntityRedstoneHandler aTile = this.getTileEntity((IBlockAccess)aWorld, aX, aY, aZ);
        if (aTile != null) {
            this.func_149715_a(aTile.getLightBrightness());
        }
        if (aWorld.field_72995_K) {
            return;
        }
        if (aTile == null || aTile.isGettingIndirectlyPowered()) {
            // empty if block
        }
    }

    public TileEntityRedstoneHandler getTileEntity(IBlockAccess world, int aX, int aY, int aZ) {
        TileEntityRedstoneHandler g;
        TileEntity aTemp = world.func_147438_o(aX, aY, aZ);
        if (aTemp != null && aTemp instanceof TileEntityRedstoneHandler && (g = (TileEntityRedstoneHandler)aTemp) != null) {
            return g;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract Item func_149694_d(World var1, int var2, int var3, int var4);

    protected abstract ItemStack func_149644_j(int var1);

    public abstract ArrayList<ItemStack> getDrops(World var1, int var2, int var3, int var4, int var5, int var6);

    public abstract Item func_149650_a(int var1, Random var2, int var3);
}

