/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.general.redstone;

import cpw.mods.fml.common.registry.GameRegistry;
import gtPlusPlus.api.interfaces.IToolable;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;

public abstract class TileEntityRedstoneHandler
extends TileEntity
implements IToolable {
    private final int mTileType;
    private BlockPos mTilePos;
    private boolean mRequiresUpdate = false;
    private Long mStartTime;
    private Byte mRedstoneLevel;
    public boolean mLightMode = false;
    public float mLightValue = 0.0f;
    private boolean mHasUpdatedRecently = false;
    private Long mLastUpdate;
    private String mInvName = "";

    public TileEntityRedstoneHandler(int aTileType) {
        this.mTileType = aTileType;
        this.registerTileEntity();
    }

    private void registerTileEntity() {
        if (!EntityUtils.isTileEntityRegistered(this.getTileEntityClass(), this.getTileEntityNameForRegistration())) {
            GameRegistry.registerTileEntity(this.getTileEntityClass(), (String)this.getTileEntityNameForRegistration());
        }
    }

    protected abstract Class<? extends TileEntity> getTileEntityClass();

    protected abstract String getTileEntityNameForRegistration();

    public Block getBlock() {
        return this.mTilePos != null ? this.mTilePos.getBlockAtPos() : Blocks.field_150451_bX;
    }

    public final boolean isLight() {
        return this.mLightMode;
    }

    public final float getLightBrightness() {
        if (!this.isLight()) {
            return 0.0f;
        }
        return this.mLightValue;
    }

    public void func_145839_a(NBTTagCompound aNBT) {
        this.mStartTime = aNBT.func_74763_f("mStartTime");
        this.mInvName = aNBT.func_74779_i("mInvName");
        this.mLightValue = aNBT.func_74760_g("mLightValue");
        this.mLightMode = aNBT.func_74767_n("mLightMode");
        this.mRedstoneLevel = aNBT.func_74771_c("mRedstoneLevel");
        super.func_145839_a(aNBT);
    }

    public void func_145841_b(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mTileType", this.mTileType);
        aNBT.func_74772_a("mStartTime", this.mStartTime.longValue());
        aNBT.func_74778_a("mInvName", this.mInvName);
        aNBT.func_74776_a("mLightValue", this.getLightBrightness());
        aNBT.func_74757_a("mLightMode", this.isLight());
        aNBT.func_74774_a("mRedstoneLevel", this.mRedstoneLevel.byteValue());
        super.func_145841_b(aNBT);
    }

    private final boolean init() {
        if (this.mTilePos == null) {
            try {
                this.mTilePos = new BlockPos(this);
            }
            catch (Throwable t) {
                return false;
            }
        }
        if (this.mStartTime == null) {
            try {
                this.mStartTime = System.currentTimeMillis();
            }
            catch (Throwable t) {
                return false;
            }
        }
        return true;
    }

    public void func_145845_h() {
        if (!this.init()) {
            return;
        }
        if (this.mRequiresUpdate || this.mLastUpdate == null) {
            this.mRequiresUpdate = false;
            this.mHasUpdatedRecently = true;
            this.mLastUpdate = System.currentTimeMillis();
            if ((float)this.mTilePos.world.func_72957_l(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this.getLightBrightness() / 0.0625f) {
                this.mTilePos.getBlockAtPos().func_149715_a(this.getLightBrightness() / 0.0625f);
                this.mTilePos.world.func_72915_b(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)(this.getLightBrightness() / 0.0625f));
                this.mTilePos.world.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                Logger.INFO("Updating Light");
            }
            this.mTilePos.world.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.mTilePos.getBlockAtPos(), 1);
            this.func_70296_d();
        }
        if (Utils.getMillisSince(this.mLastUpdate, System.currentTimeMillis()) >= 5000L && this.mHasUpdatedRecently) {
            this.mHasUpdatedRecently = false;
            this.markForUpdate();
        }
        if (Utils.getMillisSince(this.mStartTime, System.currentTimeMillis()) % 50L == 0L) {
            // empty if block
        }
        super.func_145845_h();
    }

    public final void markForUpdate() {
        this.mRequiresUpdate = true;
    }

    public final boolean hasUpdatedRecently() {
        return this.mHasUpdatedRecently;
    }

    public int func_145832_p() {
        return super.func_145832_p();
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean canUpdate() {
        return true;
    }

    public void setRedstoneState(boolean aRedstoneActive) {
    }

    public void setCurrentTextureArray(IIcon[] aTextures) {
    }

    public boolean isGettingIndirectlyPowered() {
        if (this.mTilePos == null) {
            return false;
        }
        return this.mTilePos.world.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getStrongestIndirectPower() {
        if (this.mTilePos == null) {
            return 0;
        }
        return this.mTilePos.world.func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getIndirectPowerForSide(int aSide) {
        if (this.mTilePos == null || aSide < 0 || aSide > 5) {
            return 0;
        }
        return this.mTilePos.world.func_72878_l(this.field_145851_c, this.field_145848_d, this.field_145849_e, aSide);
    }

    public int getBlockPowerInput() {
        if (this.mTilePos == null) {
            return 0;
        }
        return this.mTilePos.world.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        if (this.mTilePos == null) {
            return false;
        }
        return this.canAcceptRedstoneSignal() || this.canSupplyRedstoneSignal();
    }

    public boolean shouldCheckWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        if (this.mTilePos == null) {
            return false;
        }
        return this.getBlock().func_149721_r();
    }

    public boolean getWeakChanges(IBlockAccess world, int x, int y, int z) {
        if (this.mTilePos == null) {
            return false;
        }
        return false;
    }

    public int getRedstoneLevel() {
        if (this.mTilePos == null || this.mRedstoneLevel == null) {
            return 0;
        }
        if (this.canSupplyRedstoneSignal()) {
            if (this.hasUpdatedRecently()) {
                int aInputPower = this.getInputPowerLevel();
                this.mRedstoneLevel = (byte)(aInputPower >= 0 && aInputPower <= 127 ? aInputPower : 0);
            }
            return this.mRedstoneLevel.byteValue();
        }
        return 0;
    }

    public boolean providesWeakPower() {
        return this.isProvidingPower();
    }

    public boolean providesStrongPower() {
        return this.isProvidingPower();
    }

    public int isProvidingWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        if (!this.providesWeakPower()) {
            return 0;
        }
        return this.getOutputPowerLevel();
    }

    public int isProvidingStrongPower(IBlockAccess world, int x, int y, int z, int side) {
        if (!this.providesStrongPower()) {
            return 0;
        }
        return this.getOutputPowerLevel();
    }

    public final boolean isPowered() {
        return this.canAcceptRedstoneSignal() && this.getInputPowerLevel() > 0;
    }

    public final boolean isProvidingPower() {
        return this.canSupplyRedstoneSignal() && this.getOutputPowerLevel() > 0;
    }

    public final int getOutputPowerLevel() {
        return this.getRedstoneLevel();
    }

    public final int getInputPowerLevel() {
        return this.getBlockPowerInput();
    }

    public final boolean canSupplyRedstoneSignal() {
        return this.mTileType == 1 || this.mTileType == 2;
    }

    public final boolean canAcceptRedstoneSignal() {
        return this.mTileType == 0 || this.mTileType == 2;
    }

    @Override
    public boolean isScrewdriverable() {
        return false;
    }

    @Override
    public boolean onScrewdriverLMB() {
        return false;
    }

    @Override
    public boolean onScrewdriverRMB() {
        return false;
    }

    @Override
    public boolean isWrenchable() {
        return false;
    }

    @Override
    public boolean onWrenchLMB() {
        return false;
    }

    @Override
    public boolean onWrenchRMB() {
        return false;
    }

    @Override
    public boolean isMalletable() {
        return false;
    }

    @Override
    public boolean onMalletLMB() {
        return false;
    }

    @Override
    public boolean onMalletRMB() {
        return false;
    }

    public void setCustomName(String displayName) {
        this.mInvName = displayName;
    }

    public String getCustomName() {
        return this.mInvName;
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.mInvName : "container.redstone.generic";
    }

    public boolean hasCustomInventoryName() {
        return this.mInvName != null && !this.mInvName.equals("");
    }
}

