/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.machines;

import gregtech.api.enums.ItemList;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.container.Container_ModularityTable;
import gtPlusPlus.core.inventories.modulartable.InventoryModularMain;
import gtPlusPlus.core.inventories.modulartable.InventoryModularOutput;
import gtPlusPlus.core.item.bauble.ModularBauble;
import gtPlusPlus.core.tileentities.base.TileEntityBase;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.ModularArmourUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityModularityTable
extends TileEntityBase
implements ISidedInventory {
    public InventoryModularMain inventoryGrid = new InventoryModularMain();
    public InventoryModularOutput inventoryOutputs = new InventoryModularOutput();
    public InventoryModularOutput mTempRecipeStorage = new InventoryModularOutput();
    private Container_ModularityTable container;
    private String customName;
    private int mRecipeTimeRemaining = -1;
    protected ItemStack mOutputStack;
    protected ItemStack mInputstackA;
    protected ItemStack mInputstackB;
    public static Map<ItemStack, Pair<ModularArmourUtils.Modifiers, Integer>> mValidUpgradeList = new HashMap<ItemStack, Pair<ModularArmourUtils.Modifiers, Integer>>();
    public static Map<ItemStack, ModularArmourUtils.BT> mValidUpgradeListFormChange = new HashMap<ItemStack, ModularArmourUtils.BT>();

    public TileEntityModularityTable() {
        super(16);
        this.canUpdate();
        TileEntityModularityTable.generateAllValidUpgrades();
    }

    public void setContainer(Container_ModularityTable container_ModularityTable) {
        this.container = container_ModularityTable;
    }

    public Container_ModularityTable getContainer() {
        return this.container;
    }

    public int getRecipeTime() {
        return this.mRecipeTimeRemaining;
    }

    @Override
    public NBTTagCompound getTag(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag)) {
            nbt.func_74782_a(tag, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("mRecipeTime", this.mRecipeTimeRemaining);
        this.inventoryOutputs.writeToNBT(this.getTag(nbt, "ContentsOutput"));
        this.inventoryGrid.writeToNBT(this.getTag(nbt, "ContentsGrid"));
        this.mTempRecipeStorage.writeToNBT(this.getTag(nbt, "ContentsRecipeTemp"));
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.getCustomName());
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mRecipeTimeRemaining = nbt.func_74762_e("mRecipeTime");
        this.inventoryOutputs.readFromNBT(nbt.func_74775_l("ContentsOutput"));
        this.inventoryGrid.readFromNBT(nbt.func_74775_l("ContentsGrid"));
        this.mTempRecipeStorage.readFromNBT(nbt.func_74775_l("ContentsRecipeTemp"));
        if (nbt.func_150297_b("CustomName", 8)) {
            this.setCustomName(nbt.func_74779_i("CustomName"));
        }
    }

    public ItemStack getPendingOutputItem() {
        --this.mRecipeTimeRemaining;
        return this.mOutputStack;
    }

    public ItemStack[] getCurrentInputItems() {
        if (this.mRecipeTimeRemaining < 0) {
            return null;
        }
        return new ItemStack[]{this.mInputstackA, this.mInputstackB};
    }

    public boolean setInputStacks(ItemStack tBauble, ItemStack tUpgrade) {
        this.mInputstackA = tBauble != null ? tBauble : null;
        this.mInputstackB = tUpgrade != null ? tBauble : null;
        return this.mInputstackA != null && this.mInputstackB != null;
    }

    public boolean setOutputStack(ItemStack mNewBauble) {
        if (mNewBauble != null) {
            this.mOutputStack = mNewBauble;
            return true;
        }
        this.mOutputStack = null;
        return false;
    }

    public boolean clearRecipeData() {
        this.mInputstackA = null;
        this.mInputstackB = null;
        this.mOutputStack = null;
        return true;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    private static boolean generateAllValidUpgrades() {
        TileEntityModularityTable.generateUpgradeFormData(ItemList.Sensor_MV.get(1L, new Object[0]), ModularArmourUtils.BT.TYPE_RING);
        TileEntityModularityTable.generateUpgradeFormData(ItemList.Electric_Piston_MV.get(1L, new Object[0]), ModularArmourUtils.BT.TYPE_BELT);
        TileEntityModularityTable.generateUpgradeFormData(ItemList.Emitter_MV.get(1L, new Object[0]), ModularArmourUtils.BT.TYPE_AMULET);
        TileEntityModularityTable.generateUpgradeData(ItemList.Electric_Motor_LV.get(1L, new Object[0]), ModularArmourUtils.Modifiers.BOOST_DAMAGE, 1);
        TileEntityModularityTable.generateUpgradeData(ItemList.Electric_Motor_MV.get(1L, new Object[0]), ModularArmourUtils.Modifiers.BOOST_DAMAGE, 2);
        TileEntityModularityTable.generateUpgradeData(ItemList.Electric_Motor_HV.get(1L, new Object[0]), ModularArmourUtils.Modifiers.BOOST_DAMAGE, 3);
        TileEntityModularityTable.generateUpgradeData(ItemList.Electric_Motor_EV.get(1L, new Object[0]), ModularArmourUtils.Modifiers.BOOST_DAMAGE, 4);
        TileEntityModularityTable.generateUpgradeData(ItemList.Electric_Motor_IV.get(1L, new Object[0]), ModularArmourUtils.Modifiers.BOOST_DAMAGE, 5);
        TileEntityModularityTable.generateUpgradeData(ItemUtils.getItemStackOfAmountFromOreDictNoBroken("plateAluminium", 1), ModularArmourUtils.Modifiers.BOOST_DEF, 1);
        TileEntityModularityTable.generateUpgradeData(ItemUtils.getItemStackOfAmountFromOreDictNoBroken("plateStainlessSteel", 1), ModularArmourUtils.Modifiers.BOOST_DEF, 2);
        TileEntityModularityTable.generateUpgradeData(ItemUtils.getItemStackOfAmountFromOreDictNoBroken("plateTungsten", 1), ModularArmourUtils.Modifiers.BOOST_DEF, 3);
        TileEntityModularityTable.generateUpgradeData(ItemUtils.getItemStackOfAmountFromOreDictNoBroken("plateTungstenSteel", 1), ModularArmourUtils.Modifiers.BOOST_DEF, 4);
        TileEntityModularityTable.generateUpgradeData(ItemUtils.getItemStackOfAmountFromOreDictNoBroken("plateNaquadah", 1), ModularArmourUtils.Modifiers.BOOST_DEF, 5);
        TileEntityModularityTable.generateUpgradeData(ItemUtils.simpleMetaStack(Items.field_151153_ao, 0, 1), ModularArmourUtils.Modifiers.BOOST_HP, 1);
        TileEntityModularityTable.generateUpgradeData(ItemUtils.simpleMetaStack(Items.field_151153_ao, 1, 1), ModularArmourUtils.Modifiers.BOOST_HP, 2);
        TileEntityModularityTable.generateUpgradeData(ItemUtils.simpleMetaStack(Items.field_151156_bN, 0, 1), ModularArmourUtils.Modifiers.BOOST_HP, 3);
        TileEntityModularityTable.generateUpgradeData(ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32725", 32725, 1), ModularArmourUtils.Modifiers.BOOST_HP, 4);
        TileEntityModularityTable.generateUpgradeData(ItemUtils.simpleMetaStack("gregtech:gt.metaitem.01:32726", 32726, 1), ModularArmourUtils.Modifiers.BOOST_HP, 5);
        return true;
    }

    public static boolean generateUpgradeData(ItemStack tStack, ModularArmourUtils.Modifiers tMod, int tLevel) {
        Pair<ModularArmourUtils.Modifiers, Integer> tTemp = new Pair<ModularArmourUtils.Modifiers, Integer>(tMod, tLevel);
        return mValidUpgradeList.put(tStack, tTemp) != null;
    }

    public static boolean generateUpgradeFormData(ItemStack tStack, ModularArmourUtils.BT tMod) {
        return mValidUpgradeListFormChange.put(tStack, tMod) != null;
    }

    public static boolean addUpgrade(ItemStack tStack, ItemStack tBauble) {
        try {
            for (Map.Entry<ItemStack, ModularArmourUtils.BT> entry : mValidUpgradeListFormChange.entrySet()) {
                if (entry.getKey().func_77973_b() != tStack.func_77973_b() || entry.getKey().func_77960_j() != tStack.func_77960_j()) continue;
                ModularArmourUtils.setBaubleType(tBauble, entry.getValue());
                tBauble.func_77964_b(ModularArmourUtils.getBaubleTypeID(tBauble));
                return true;
            }
        }
        catch (Throwable it) {
            // empty catch block
        }
        try {
            for (Map.Entry<ItemStack, Pair<ModularArmourUtils.Modifiers, Integer>> entry : mValidUpgradeList.entrySet()) {
                if (entry.getKey().func_77973_b() != tStack.func_77973_b() || entry.getKey().func_77960_j() != tStack.func_77960_j()) continue;
                Pair<ModularArmourUtils.Modifiers, Integer> newPair = entry.getValue();
                ModularArmourUtils.setModifierLevel(tBauble, newPair);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int func_70302_i_() {
        return 11;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        if (slot >= this.inventoryGrid.func_70302_i_()) {
            return this.inventoryOutputs.func_70301_a(slot - 9);
        }
        if (slot < this.inventoryGrid.func_70302_i_()) {
            return this.inventoryGrid.func_70301_a(slot);
        }
        return null;
    }

    @Override
    public ItemStack func_70298_a(int slot, int count) {
        if (slot < this.inventoryGrid.func_70302_i_()) {
            return this.inventoryGrid.func_70298_a(slot, count);
        }
        if (slot >= this.inventoryGrid.func_70302_i_()) {
            return this.inventoryOutputs.func_70298_a(slot - 9, count);
        }
        return null;
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        return this.func_70301_a(slot);
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (slot >= this.inventoryGrid.func_70302_i_()) {
            this.inventoryOutputs.func_70299_a(slot - 9, stack);
        } else if (slot < this.inventoryGrid.func_70302_i_()) {
            this.inventoryGrid.func_70299_a(slot, stack);
        }
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public void func_70295_k_() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 1);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        this.inventoryGrid.func_70295_k_();
        this.inventoryOutputs.func_70295_k_();
    }

    @Override
    public void func_70305_f() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 1);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        this.inventoryGrid.func_70295_k_();
        this.inventoryOutputs.func_70295_k_();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (slot >= this.inventoryGrid.func_70302_i_()) {
            return this.inventoryOutputs.func_94041_b(slot - 9, itemstack);
        }
        if (slot < this.inventoryGrid.func_70302_i_()) {
            return this.inventoryGrid.func_94041_b(slot, itemstack);
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] accessibleSides = new int[this.func_70302_i_()];
        for (int r = 0; r < this.func_70302_i_(); ++r) {
            accessibleSides[r] = r;
        }
        return accessibleSides;
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack item, int side) {
        Logger.INFO("Slot:" + slot + " | side? " + side);
        if (slot >= 9) {
            return this.inventoryOutputs.func_94041_b(slot - 9, item);
        }
        return this.inventoryGrid.func_94041_b(slot, item);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack item, int side) {
        Logger.INFO("Slot:" + slot + " | side? " + side);
        return slot == 11 || slot <= 8;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Override
    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.fishtrap";
    }

    @Override
    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.equals("");
    }

    @Override
    public boolean onPreTick(long aTick) {
        if (this.mRecipeTimeRemaining > -1 || this.mTempRecipeStorage != null && this.mTempRecipeStorage.getRecipeTime() > -1) {
            if (this.mTempRecipeStorage != null && this.mTempRecipeStorage.getRecipeTime() > -1 && this.mRecipeTimeRemaining < this.mTempRecipeStorage.getRecipeTime()) {
                this.mRecipeTimeRemaining = this.mTempRecipeStorage.getRecipeTime();
                this.func_70296_d();
            }
            if (this.mInputstackA != null && this.mInputstackB != null && this.mOutputStack != null) {
                this.mTempRecipeStorage.func_70299_a(0, this.mInputstackA);
                this.mTempRecipeStorage.func_70299_a(1, this.mInputstackB);
                this.mTempRecipeStorage.func_70299_a(2, this.mOutputStack);
                this.mTempRecipeStorage.setRecipeTime(this.mRecipeTimeRemaining);
                this.func_70296_d();
            }
        }
        return true;
    }

    @Override
    public boolean onPostTick(long aTick) {
        if (this.mRecipeTimeRemaining == 0) {
            this.inventoryOutputs.func_70299_a(2, this.getPendingOutputItem());
            this.clearRecipeData();
            this.mTempRecipeStorage.setRecipeTime(this.mRecipeTimeRemaining);
            this.func_70296_d();
        } else if (this.mRecipeTimeRemaining > 0) {
            --this.mRecipeTimeRemaining;
            this.mTempRecipeStorage.setRecipeTime(this.mRecipeTimeRemaining);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean processRecipe() {
        boolean removeInputA = false;
        boolean removeInputB = false;
        ItemStack tBauble = this.inventoryOutputs.func_70301_a(0);
        ItemStack tUpgrade = this.inventoryOutputs.func_70301_a(1);
        if (tBauble != null && tUpgrade != null && this.container != null && tBauble.func_77973_b() instanceof ModularBauble && this.mRecipeTimeRemaining == -1 && tUpgrade != null && tBauble != null) {
            removeInputA = true;
            this.setInputStacks(tBauble, tUpgrade);
            try {
                removeInputB = TileEntityModularityTable.addUpgrade(tUpgrade, tBauble);
                if (removeInputB) {
                    // empty if block
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (removeInputA && removeInputB && this.setOutputStack(tBauble)) {
                if (this.inventoryOutputs.func_70301_a((int)1).field_77994_a > 1) {
                    ItemStack mTempStack = this.inventoryOutputs.func_70301_a(1);
                    --mTempStack.field_77994_a;
                    this.inventoryOutputs.func_70299_a(1, mTempStack);
                } else {
                    this.inventoryOutputs.func_70299_a(1, null);
                }
                this.inventoryOutputs.func_70299_a(0, null);
                this.mRecipeTimeRemaining = 80;
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public static boolean isValidModularPiece(ItemStack itemstack) {
        return itemstack.func_77973_b() instanceof ModularBauble;
    }

    public static boolean isValidUpgrade(ItemStack itemstack) {
        boolean isValid = false;
        if (itemstack != null) {
            for (Map.Entry<ItemStack, ModularArmourUtils.BT> pair : mValidUpgradeListFormChange.entrySet()) {
                if (pair.getKey().func_77973_b() != itemstack.func_77973_b() || pair.getKey().func_77960_j() != itemstack.func_77960_j()) continue;
                isValid = true;
            }
            for (Map.Entry<ItemStack, Pair<ModularArmourUtils.Modifiers, Integer>> pair : mValidUpgradeList.entrySet()) {
                if (pair.getKey().func_77973_b() != itemstack.func_77973_b() || pair.getKey().func_77960_j() != itemstack.func_77960_j()) continue;
                isValid = true;
            }
        }
        return isValid;
    }
}

