/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import gregtech.api.enums.Mods;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.gui.machine.GUI_DecayablesChest;
import gtPlusPlus.core.handler.Recipes.DecayableRecipe;
import gtPlusPlus.core.item.base.dusts.BaseItemDustUnique;
import gtPlusPlus.core.item.materials.DustDecayable;
import gtPlusPlus.core.lib.VanillaColours;
import gtPlusPlus.nei.handlers.NeiTextureHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class DecayableRecipeHandler
extends TemplateRecipeHandler {
    public static final String mNEIName = "Decayables";

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"GTPP.container.decaychest.name");
    }

    public String getGuiTexture() {
        return Mods.GTPlusPlus.ID + ":textures/gui/nei/decayables.png";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GUI_DecayablesChest.class;
    }

    public String getOverlayIdentifier() {
        return "GTPP_Decayables";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(6, 3, 16, 16), this.getOverlayIdentifier(), new Object[0]));
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result == null || !DustDecayable.class.isInstance(result.func_77973_b()) && !BaseItemDustUnique.class.isInstance(result.func_77973_b())) {
            return;
        }
        if (result != null) {
            // empty if block
        }
        AutoMap<DecayableRecipe> recipes = DecayableRecipe.mRecipes;
        for (DecayableRecipe recipe : recipes) {
            if (!recipe.isValid()) continue;
            ItemStack input = recipe.mInput.func_77946_l();
            ItemStack output = recipe.mOutput.func_77946_l();
            if (!GT_Utility.areStacksEqual((ItemStack)result, (ItemStack)output, (boolean)true)) continue;
            DecayableRecipeNEI rec = new DecayableRecipeNEI(input, output, recipe.mTime);
            this.arecipes.add(rec);
            this.sort();
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier()) && ((Object)((Object)this)).getClass() == DecayableRecipeHandler.class) {
            AutoMap<DecayableRecipe> recipes = DecayableRecipe.mRecipes;
            for (DecayableRecipe recipe : recipes) {
                if (!recipe.isValid()) continue;
                ItemStack input = recipe.mInput.func_77946_l();
                ItemStack output = recipe.mOutput.func_77946_l();
                DecayableRecipeNEI rec = new DecayableRecipeNEI(input, output, recipe.mTime);
                this.arecipes.add(rec);
                this.sort();
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        AutoMap<DecayableRecipe> recipes = DecayableRecipe.mRecipes;
        if (ingredient != null) {
            // empty if block
        }
        for (DecayableRecipe recipe : recipes) {
            if (!recipe.isValid()) continue;
            ItemStack input = recipe.mInput.func_77946_l();
            ItemStack output = recipe.mOutput.func_77946_l();
            if (!GT_Utility.areStacksEqual((ItemStack)ingredient, (ItemStack)input, (boolean)true)) continue;
            DecayableRecipeNEI rec = new DecayableRecipeNEI(input, output, recipe.mTime);
            this.arecipes.add(rec);
            this.sort();
        }
    }

    private final void sort() {
        ArrayList<DecayableRecipeNEI> g = new ArrayList<DecayableRecipeNEI>();
        for (TemplateRecipeHandler.CachedRecipe u : this.arecipes) {
            g.add((DecayableRecipeNEI)u);
        }
        if (g != null && !g.isEmpty()) {
            Collections.sort(g);
        }
    }

    public void drawExtras(int recipeIndex) {
        DecayableRecipeNEI recipe = (DecayableRecipeNEI)this.arecipes.get(recipeIndex);
        int cost = recipe.time;
        if (cost > 0) {
            int aLeftoverMinutes;
            int formattedTime;
            String suffix;
            String s = I18n.func_135052_a((String)"GTPP.nei.info", (Object[])new Object[]{cost});
            String s0 = I18n.func_135052_a((String)"GTPP.nei.timetaken", (Object[])new Object[]{cost});
            String s1 = I18n.func_135052_a((String)"GTPP.time.ticks", (Object[])new Object[]{cost});
            String s2 = I18n.func_135052_a((String)"GTPP.time.seconds", (Object[])new Object[]{cost});
            String s3 = I18n.func_135052_a((String)"GTPP.time.minutes", (Object[])new Object[]{cost});
            String s4 = I18n.func_135052_a((String)"GTPP.time.hours", (Object[])new Object[]{cost});
            String s5 = I18n.func_135052_a((String)"GTPP.time.days", (Object[])new Object[]{cost});
            String s6 = I18n.func_135052_a((String)"GTPP.time.months", (Object[])new Object[]{cost});
            int y = 20;
            int secs = cost / 20;
            int mins = secs / 60;
            int hours = mins / 60;
            int days = hours / 24;
            int months = days / 30;
            if (cost <= 20) {
                suffix = s1;
                formattedTime = cost;
            } else if (cost <= 1200) {
                suffix = s2;
                formattedTime = secs;
            } else if (cost <= 72000) {
                suffix = s3;
                formattedTime = mins;
            } else if (cost <= 1728000) {
                suffix = s4;
                formattedTime = hours;
            } else if (cost < 51840000) {
                suffix = s5;
                formattedTime = days;
            } else if (cost <= 51840000) {
                suffix = s6;
                formattedTime = months;
            } else {
                suffix = s1;
                formattedTime = cost;
            }
            int x = 5;
            GuiDraw.drawString((String)s, (int)x, (int)25, (int)VanillaColours.DYE_BLACK.getAsInt(), (boolean)false);
            GuiDraw.drawString((String)s0, (int)x, (int)40, (int)VanillaColours.DYE_BLACK.getAsInt(), (boolean)false);
            GuiDraw.drawString((String)suffix, (int)(x + 16), (int)(y + 30), (int)VanillaColours.DYE_BLACK.getAsInt(), (boolean)false);
            GuiDraw.drawString((String)("" + formattedTime), (int)x, (int)(y + 30), (int)VanillaColours.DYE_GREEN.getAsInt(), (boolean)false);
            if (hours > 1 && (aLeftoverMinutes = cost - hours * 72000) > 0) {
                int secs2 = aLeftoverMinutes / 20;
                int mins2 = secs2 / 60;
                GuiDraw.drawString((String)s3, (int)(x + 16), (int)(y + 42), (int)VanillaColours.DYE_BLACK.getAsInt(), (boolean)false);
                GuiDraw.drawString((String)("" + mins2), (int)x, (int)(y + 42), (int)VanillaColours.DYE_GREEN.getAsInt(), (boolean)false);
            }
        }
        NeiTextureHandler.RECIPE_BUTTON.renderIcon(6.0, 3.0, 16.0, 16.0, 0.0, true);
    }

    public class DecayableRecipeNEI
    extends TemplateRecipeHandler.CachedRecipe
    implements Comparable<TemplateRecipeHandler.CachedRecipe> {
        private PositionedStack input;
        private PositionedStack output;
        public int time;

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public DecayableRecipeNEI(ItemStack input, ItemStack result, int time) {
            super((TemplateRecipeHandler)DecayableRecipeHandler.this);
            this.input = new PositionedStack((Object)input, 93, 24);
            this.output = new PositionedStack((Object)result, 142, 42);
            this.time = time;
        }

        @Override
        public int compareTo(TemplateRecipeHandler.CachedRecipe o) {
            boolean b = DecayableRecipeNEI.class.isInstance(o);
            if (b) {
                DecayableRecipeNEI p = (DecayableRecipeNEI)o;
                if (p.time > this.time) {
                    return 1;
                }
                if (p.time == this.time) {
                    return 0;
                }
                return -1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            DecayableRecipeNEI p;
            if (obj != null && DecayableRecipeNEI.class.isInstance(obj) && (p = (DecayableRecipeNEI)obj) != null && p.time == this.time) {
                ItemStack aInput = p.input.item;
                ItemStack aOutput = p.output.item;
                if (GT_Utility.areStacksEqual((ItemStack)aInput, (ItemStack)this.input.item, (boolean)true) && GT_Utility.areStacksEqual((ItemStack)aOutput, (ItemStack)this.output.item, (boolean)true)) {
                    return true;
                }
            }
            return false;
        }
    }
}

