/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.forestry.bees.custom;

import gregtech.api.enums.Materials;
import gregtech.api.util.GT_LanguageManager;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.xmod.forestry.bees.custom.GTPP_Bees;

public enum CustomCombs {
    SILICON("silicon", true, Materials.Silicon, 100),
    RUBBER("rubber", true, Materials.Rubber, 100),
    PLASTIC("polyethylene", true, Materials.Plastic, 75),
    PTFE("polytetrafluoroethylene", true, GTPP_Bees.PTFE, 50),
    PBS("styrene-butadiene", true, GTPP_Bees.PBS, 25),
    BIOMASS("biomass", true, Materials.Biomass, 100),
    ETHANOL("ethanol", true, Materials.Ethanol, 75),
    DIESEL("diesel", true, Materials.Fuel, 50),
    NITRO("nitro", true, Materials.NitroFuel, 25),
    HOOTCH("hootch", true, Materials.Silicon, 50),
    ROCKETFUEL("rocket", true, Materials.Silicon, 25),
    FLUORINE("fluorine", true, Materials.Fluorine, 25),
    COKE("coke", true, Materials._NULL, 50),
    FORCE("force", true, Materials.Force, 50),
    NIKOLITE("nikolite", true, Materials.Nikolite, 75),
    MITHRIL("mithril", true, Materials.Mithril, 10),
    ADAMANTIUM("adamantium", true, Materials.Adamantium, 5),
    SALT("salt", true, Materials.Salt, 75),
    SAND("sand", true, Materials.Sand, 100);

    private static int[][] colours;
    public boolean showInList;
    public Materials material;
    public int chance;
    private String name;

    private CustomCombs(String pName, boolean show, Materials material, int chance) {
        this.name = pName;
        this.material = material;
        this.chance = chance;
        this.showInList = show;
    }

    public void setHidden() {
        this.showInList = false;
    }

    public String getName() {
        return GT_LanguageManager.addStringLocalization((String)("comb." + this.name), (String)(this.name.substring(0, 1).toUpperCase() + this.name.substring(1) + " Comb"));
    }

    public int[] getColours() {
        return colours[this.ordinal()];
    }

    static {
        colours = new int[][]{{Utils.rgbtoHexValue(75, 75, 75), Utils.rgbtoHexValue(125, 125, 125)}, {Utils.rgbtoHexValue(55, 55, 55), Utils.rgbtoHexValue(75, 75, 75)}, {Utils.rgbtoHexValue(245, 245, 245), Utils.rgbtoHexValue(175, 175, 175)}, {Utils.rgbtoHexValue(150, 150, 150), Utils.rgbtoHexValue(75, 75, 75)}, {Utils.rgbtoHexValue(33, 26, 24), Utils.rgbtoHexValue(23, 16, 14)}, {Utils.rgbtoHexValue(33, 225, 24), Utils.rgbtoHexValue(23, 175, 14)}, {Utils.rgbtoHexValue(255, 128, 0), Utils.rgbtoHexValue(220, 156, 32)}, {Utils.rgbtoHexValue(75, 75, 75), Utils.rgbtoHexValue(125, 125, 125)}, {Utils.rgbtoHexValue(75, 75, 75), Utils.rgbtoHexValue(125, 125, 125)}, {Utils.rgbtoHexValue(75, 75, 75), Utils.rgbtoHexValue(125, 125, 125)}, {Utils.rgbtoHexValue(75, 75, 75), Utils.rgbtoHexValue(125, 125, 125)}, {Utils.rgbtoHexValue(30, 230, 230), Utils.rgbtoHexValue(10, 150, 150)}, {Utils.rgbtoHexValue(75, 75, 75), Utils.rgbtoHexValue(125, 125, 125)}, {Utils.rgbtoHexValue(250, 250, 20), Utils.rgbtoHexValue(200, 200, 5)}, {Utils.rgbtoHexValue(60, 180, 200), Utils.rgbtoHexValue(40, 150, 170)}, {Utils.rgbtoHexValue(75, 75, 75), Utils.rgbtoHexValue(125, 125, 125)}, {Utils.rgbtoHexValue(75, 75, 75), Utils.rgbtoHexValue(125, 125, 125)}, {Utils.rgbtoHexValue(75, 75, 75), Utils.rgbtoHexValue(125, 125, 125)}, {Utils.rgbtoHexValue(75, 75, 75), Utils.rgbtoHexValue(125, 125, 125)}, {Utils.rgbtoHexValue(75, 75, 75), Utils.rgbtoHexValue(125, 125, 125)}, {0x666666, 0x525252}, {3051355, 14467721}, {0x4C4C4C, 0x333333}, {0x808080, 0x999999}, {5754875, 0xBBEEFF}, {8195855, 0xD11919}, {1656785, 4680922}, {15073372, 13369426}, {13260, 9359}, {0xCCFFFF, 0xA3CCCC}, {2395940, 0xCCFFCC}, {2395940, 3061806}, {0xD4D4D4, 5779467}, {0xFF6600, 15096832}, {0xD4D4D4, 0xDDDDDD}, {0x666699, 0xA3A3CC}, {14324039, 14589017}, {0x808080, 0x999999}, {8750509, 0x9D9DBD}, {15785712, 15917554}, {12763862, 0xCECEDE}, {15120384, 13608448}, {35512, 0xD6D6FF}, {0xD5D5D5, 0xAAAAAA}, {0xCC99FF, 14399743}, {15442411, 15909874}, {0x62626D, 1447456}, {0xE6E6E6, 0xFFFFCC}, {0xDADADA, 13750752}, {1683225, 1482262}, {0x335C33, 7048960}, {13056, 9216}};
    }
}

