/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Fluid;
import gregtech.api.render.TextureFactory;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechOrePrefixes;
import net.minecraftforge.common.util.ForgeDirection;

public class GregtechMetaPipeEntityFluid
extends GT_MetaPipeEntity_Fluid {
    public final GregtechOrePrefixes.GT_Materials mMaterial;

    public GregtechMetaPipeEntityFluid(int aID, String aName, String aNameRegional, float aThickNess, GregtechOrePrefixes.GT_Materials aMaterial, int aCapacity, int aHeatResistance, boolean aGasProof) {
        this(aID, aName, aNameRegional, aThickNess, aMaterial, aCapacity, aHeatResistance, aGasProof, 1);
    }

    public GregtechMetaPipeEntityFluid(String aName, float aThickNess, GregtechOrePrefixes.GT_Materials aMaterial, int aCapacity, int aHeatResistance, boolean aGasProof) {
        this(aName, aThickNess, aMaterial, aCapacity, aHeatResistance, aGasProof, 1);
    }

    public GregtechMetaPipeEntityFluid(int aID, String aName, String aNameRegional, float aThickNess, GregtechOrePrefixes.GT_Materials aMaterial, int aCapacity, int aHeatResistance, boolean aGasProof, int aFluidTypes) {
        super(aID, aName, aNameRegional, aThickNess, null, aCapacity, aHeatResistance, aGasProof, aFluidTypes);
        this.mLastReceivedFrom = 0;
        this.oLastReceivedFrom = 0;
        this.mMaterial = aMaterial;
    }

    public GregtechMetaPipeEntityFluid(String aName, float aThickNess, GregtechOrePrefixes.GT_Materials aMaterial, int aCapacity, int aHeatResistance, boolean aGasProof, int aFluidTypes) {
        super(aName, aThickNess, null, aCapacity, aHeatResistance, aGasProof, aFluidTypes);
        this.mLastReceivedFrom = 0;
        this.oLastReceivedFrom = 0;
        this.mMaterial = aMaterial;
    }

    public byte getTileEntityBaseType() {
        return this.mMaterial == null ? (byte)4 : (byte)((this.mMaterial.contains(SubTag.WOOD) ? 12 : 4) + Math.max(0, Math.min(3, this.mMaterial.mToolQuality)));
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaPipeEntityFluid(this.mName, this.mThickNess, this.mMaterial, this.mCapacity, this.mHeatResistance, this.mGasProof);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, int aConnections, int aColorIndex, boolean aConnected, boolean aRedstone) {
        float tThickNess = this.getThickNess();
        if (this.mDisableInput == 0) {
            return new ITexture[]{aConnected ? GregtechMetaPipeEntityFluid.getBaseTexture(tThickNess, this.mPipeAmount, this.mMaterial, aColorIndex) : TextureFactory.of((IIconContainer)this.mMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], (short[])Dyes.getModulation((int)aColorIndex, (short[])this.mMaterial.mRGBa))};
        }
        int tMask = 0;
        int[][] sRestrictionArray = new int[][]{{2, 3, 5, 4}, {2, 3, 5, 4}, {1, 0, 5, 4}, {1, 0, 4, 5}, {1, 0, 2, 3}, {1, 0, 2, 3}};
        if (side != ForgeDirection.UNKNOWN) {
            for (int i = 0; i < 4; ++i) {
                if (!this.isInputDisabledAtSide(ForgeDirection.getOrientation((int)sRestrictionArray[side.ordinal()][i]))) continue;
                tMask |= 1 << i;
            }
            if ((side == ForgeDirection.EAST || side == ForgeDirection.UP) && tMask > 3 && tMask < 12) {
                tMask ^= 0xC;
            }
        }
        return new ITexture[]{aConnected ? GregtechMetaPipeEntityFluid.getBaseTexture(tThickNess, this.mPipeAmount, this.mMaterial, aColorIndex) : TextureFactory.of((IIconContainer)this.mMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], (short[])Dyes.getModulation((int)aColorIndex, (short[])this.mMaterial.mRGBa)), GregtechMetaPipeEntityFluid.getRestrictorTexture((int)tMask)};
    }

    protected static ITexture getBaseTexture(float aThickNess, int aPipeAmount, GregtechOrePrefixes.GT_Materials aMaterial, int aColorIndex) {
        if (aPipeAmount >= 9) {
            return TextureFactory.of((IIconContainer)aMaterial.mIconSet.mTextures[OrePrefixes.pipeNonuple.mTextureIndex], (short[])Dyes.getModulation((int)aColorIndex, (short[])aMaterial.mRGBa));
        }
        if (aPipeAmount >= 4) {
            return TextureFactory.of((IIconContainer)aMaterial.mIconSet.mTextures[OrePrefixes.pipeQuadruple.mTextureIndex], (short[])Dyes.getModulation((int)aColorIndex, (short[])aMaterial.mRGBa));
        }
        if (aThickNess < 0.124f) {
            return TextureFactory.of((IIconContainer)aMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], (short[])Dyes.getModulation((int)aColorIndex, (short[])aMaterial.mRGBa));
        }
        if (aThickNess < 0.374f) {
            return TextureFactory.of((IIconContainer)aMaterial.mIconSet.mTextures[OrePrefixes.pipeTiny.mTextureIndex], (short[])Dyes.getModulation((int)aColorIndex, (short[])aMaterial.mRGBa));
        }
        if (aThickNess < 0.499f) {
            return TextureFactory.of((IIconContainer)aMaterial.mIconSet.mTextures[OrePrefixes.pipeSmall.mTextureIndex], (short[])Dyes.getModulation((int)aColorIndex, (short[])aMaterial.mRGBa));
        }
        if (aThickNess < 0.749f) {
            return TextureFactory.of((IIconContainer)aMaterial.mIconSet.mTextures[OrePrefixes.pipeMedium.mTextureIndex], (short[])Dyes.getModulation((int)aColorIndex, (short[])aMaterial.mRGBa));
        }
        if (aThickNess < 0.874f) {
            return TextureFactory.of((IIconContainer)aMaterial.mIconSet.mTextures[OrePrefixes.pipeLarge.mTextureIndex], (short[])Dyes.getModulation((int)aColorIndex, (short[])aMaterial.mRGBa));
        }
        return TextureFactory.of((IIconContainer)aMaterial.mIconSet.mTextures[OrePrefixes.pipeHuge.mTextureIndex], (short[])Dyes.getModulation((int)aColorIndex, (short[])aMaterial.mRGBa));
    }
}

