/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.covers;

import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.api.objects.random.XSTR;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class GTPP_Cover_ToggleVisual
extends GT_CoverBehavior {
    private static final Map<String, Integer> sConnectionStateForEntityMap = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, String> sPrefixMap = new ConcurrentHashMap<String, String>();
    private static final int VALUE_OFF = 0;
    private static final int VALUE_ON = 1;

    public static String generateUniqueKey(ForgeDirection side, ICoverable aEntity) {
        try {
            BlockPos aPos = new BlockPos(aEntity.getIGregTechTileEntity(aEntity.getXCoord(), (int)aEntity.getYCoord(), aEntity.getZCoord()));
            String s = aEntity.func_145825_b() + "." + aPos.getUniqueIdentifier() + side.name();
            return s;
        }
        catch (Throwable aPos) {
            XSTR x = new XSTR();
            return "ERROR." + x.getSeed() + x.hashCode() + x.nextDouble() + ".ID";
        }
    }

    public boolean onCoverRightclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        PlayerUtils.messagePlayer(aPlayer, GT_Utility.trans((String)"756", (String)"Connectable: ") + GTPP_Cover_ToggleVisual.getConnectionState(aCoverVariable));
        return super.onCoverRightclick(side, aCoverID, aCoverVariable, aTileEntity, aPlayer, aX, aY, aZ);
    }

    public int onCoverScrewdriverclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return super.onCoverScrewdriverclick(side, aCoverID, aCoverVariable, aTileEntity, aPlayer, aX, aY, aZ);
    }

    public boolean letsEnergyIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return GTPP_Cover_ToggleVisual.getConnectionState(aCoverVariable);
    }

    public boolean letsEnergyOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return GTPP_Cover_ToggleVisual.getConnectionState(aCoverVariable);
    }

    public boolean letsFluidIn(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return GTPP_Cover_ToggleVisual.getConnectionState(aCoverVariable);
    }

    public boolean letsFluidOut(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return GTPP_Cover_ToggleVisual.getConnectionState(aCoverVariable);
    }

    public boolean letsItemsIn(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return GTPP_Cover_ToggleVisual.getConnectionState(aCoverVariable);
    }

    public boolean letsItemsOut(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return GTPP_Cover_ToggleVisual.getConnectionState(aCoverVariable);
    }

    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    public int doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        try {
            String aKey = GTPP_Cover_ToggleVisual.generateUniqueKey(side, aTileEntity);
            Integer b = sConnectionStateForEntityMap.get(aKey);
            if (b != null && aCoverVariable != b) {
                aCoverVariable = b;
            }
            if (b == null) {
                b = aCoverVariable;
                sConnectionStateForEntityMap.put(aKey, b);
                GTPP_Cover_ToggleVisual.trySetState(side, b == 1 ? 1 : 0, aTileEntity);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return aCoverVariable;
    }

    public boolean letsRedstoneGoIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return GTPP_Cover_ToggleVisual.getConnectionState(aCoverVariable);
    }

    public boolean letsRedstoneGoOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return GTPP_Cover_ToggleVisual.getConnectionState(aCoverVariable);
    }

    public boolean alwaysLookConnected(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return super.alwaysLookConnected(side, aCoverID, aCoverVariable, aTileEntity);
    }

    public byte getRedstoneInput(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        if (!GTPP_Cover_ToggleVisual.getConnectionState(aCoverVariable)) {
            return 0;
        }
        return super.getRedstoneInput(side, aInputRedstone, aCoverID, aCoverVariable, aTileEntity);
    }

    public void placeCover(ForgeDirection side, ItemStack aCover, ICoverable aTileEntity) {
        String aKey = GTPP_Cover_ToggleVisual.generateUniqueKey(side, aTileEntity);
        boolean state = GTPP_Cover_ToggleVisual.getCoverConnections(aCover);
        sPrefixMap.put(aKey, aCover.func_77977_a());
        Logger.INFO("Mapping key " + aKey + " to " + state);
        sConnectionStateForEntityMap.put(aKey, state ? 1 : 0);
        Logger.INFO("Key Value: " + (state ? 1 : 0));
        super.placeCover(side, aCover, aTileEntity);
    }

    public boolean onCoverRemoval(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        String aKey = GTPP_Cover_ToggleVisual.generateUniqueKey(side, aTileEntity);
        sConnectionStateForEntityMap.remove(aKey);
        return true;
    }

    public static boolean getConnectionState(int aCoverVar) {
        return aCoverVar == 1;
    }

    private static final void trySetState(ForgeDirection side, int aState, ICoverable aTile) {
        if (aTile instanceof IGregTechTileEntity) {
            IGregTechTileEntity gTileEntity = (IGregTechTileEntity)aTile;
            gTileEntity.setCoverDataAtSide(side, (ISerializableObject)new ISerializableObject.LegacyCoverData(aState));
        }
    }

    public static boolean getConnectionState(ForgeDirection side, ICoverable aTile) {
        String aKey = GTPP_Cover_ToggleVisual.generateUniqueKey(side, aTile);
        return GTPP_Cover_ToggleVisual.getConnectionState(aKey);
    }

    public static boolean getConnectionState(String aKey) {
        Integer b = sConnectionStateForEntityMap.get(aKey);
        return b != null ? b == 1 : false;
    }

    public static final boolean getCoverConnections(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("CustomCoverMeta")) != null) {
            return aNBT.func_74767_n("AllowConnections");
        }
        return false;
    }
}

