/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.GregtechMetaTileEntity_LargerTurbineBase;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_MTE_LargeTurbine_SCSteam
extends GregtechMetaTileEntity_LargerTurbineBase {
    public GT_MTE_LargeTurbine_SCSteam(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MTE_LargeTurbine_SCSteam(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MTE_LargeTurbine_SCSteam(this.mName);
    }

    @Override
    public int getCasingMeta() {
        return 15;
    }

    @Override
    public int getCasingTextureIndex() {
        return 1538;
    }

    @Override
    protected boolean requiresOutputHatch() {
        return true;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getFuelValue(FluidStack aLiquid) {
        return 0;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, long aOptFlow, int aBaseEff, float[] flowMultipliers) {
        int tEU = 0;
        int totalFlow = 0;
        int flow = 0;
        int remainingFlow = MathUtils.safeInt((long)((float)aOptFlow * 1.25f));
        this.realOptFlow = (double)aOptFlow * (double)flowMultipliers[0];
        this.storedFluid = 0;
        FluidStack tSCSteam = FluidRegistry.getFluidStack((String)"supercriticalsteam", (int)1);
        for (int i = 0; i < aFluids.size() && remainingFlow > 0; ++i) {
            if (!GT_Utility.areFluidsEqual((FluidStack)aFluids.get(i), (FluidStack)tSCSteam, (boolean)true)) continue;
            flow = Math.min(aFluids.get((int)i).amount, remainingFlow);
            this.depleteInput(new FluidStack(aFluids.get(i), flow));
            this.storedFluid += aFluids.get((int)i).amount;
            remainingFlow -= flow;
            totalFlow += flow;
        }
        if (totalFlow <= 0) {
            return 0;
        }
        tEU = totalFlow;
        this.addOutput(GT_ModHandler.getSteam((long)totalFlow));
        if ((long)totalFlow != aOptFlow) {
            float efficiency = 1.0f - Math.abs((float)((long)totalFlow - aOptFlow) / (float)aOptFlow);
            tEU = (int)((float)tEU * efficiency);
            tEU = Math.max(1, MathUtils.safeInt((long)tEU * (long)aBaseEff / 10000L));
        } else {
            tEU = MathUtils.safeInt((long)tEU * (long)aBaseEff / 10000L);
        }
        return (int)Math.min((long)tEU * 100L, Integer.MAX_VALUE);
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 8;
    }

    @Override
    public String getMachineType() {
        return "Large Supercritical Steam Turbine";
    }

    @Override
    protected String getTurbineType() {
        return "Supercritical Steam";
    }

    @Override
    protected String getCasingName() {
        return "Reinforced SC Turbine Casing";
    }

    @Override
    protected ITexture getTextureFrontFace() {
        return TextureFactory.of((IIconContainer)Textures.BlockIcons.LARGETURBINE_TI5);
    }

    @Override
    protected ITexture getTextureFrontFaceActive() {
        return TextureFactory.of((IIconContainer)Textures.BlockIcons.LARGETURBINE_TI_ACTIVE5);
    }
}

