/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines;

import gregtech.GT_Mod;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.GregtechMetaTileEntity_LargerTurbineBase;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MTE_LargeTurbine_Steam
extends GregtechMetaTileEntity_LargerTurbineBase {
    private float water;
    private boolean achievement = false;
    private boolean looseFit = false;

    public GT_MTE_LargeTurbine_Steam(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MTE_LargeTurbine_Steam(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MTE_LargeTurbine_Steam(this.mName);
    }

    @Override
    public int getCasingMeta() {
        return 1;
    }

    @Override
    public int getCasingTextureIndex() {
        return 16;
    }

    @Override
    protected boolean requiresOutputHatch() {
        return true;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 0;
    }

    private int useWater(float input) {
        this.water += input;
        int usage = (int)this.water;
        this.water -= (float)usage;
        return usage;
    }

    @Override
    public int getFuelValue(FluidStack aLiquid) {
        return 0;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, long aOptFlow, int aBaseEff, float[] flowMultipliers) {
        if (this.looseFit) {
            aOptFlow *= 4L;
            if (aBaseEff > 10000) {
                aOptFlow = (long)((double)aOptFlow * Math.pow(1.1f, (float)(aBaseEff - 7500) / 10000.0f * 20.0f));
                aBaseEff = 7500;
            } else if (aBaseEff > 7500) {
                aOptFlow = (long)((double)aOptFlow * Math.pow(1.1f, (float)(aBaseEff - 7500) / 10000.0f * 20.0f));
                aBaseEff = (int)((float)aBaseEff * 0.75f);
            } else {
                aBaseEff = (int)((float)aBaseEff * 0.75f);
            }
        }
        int tEU = 0;
        int totalFlow = 0;
        int flow = 0;
        int remainingFlow = MathUtils.safeInt((long)((float)aOptFlow * 1.25f));
        this.realOptFlow = (double)aOptFlow * (double)flowMultipliers[0];
        this.storedFluid = 0;
        for (int i = 0; i < aFluids.size() && remainingFlow > 0; ++i) {
            String fluidName = aFluids.get(i).getFluid().getUnlocalizedName(aFluids.get(i));
            if (fluidName.equals("fluid.steam") || fluidName.equals("ic2.fluidSteam") || fluidName.equals("fluid.mfr.steam.still.name")) {
                flow = Math.min(aFluids.get((int)i).amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluids.get(i), flow));
                this.storedFluid += aFluids.get((int)i).amount;
                remainingFlow -= flow;
                totalFlow += flow;
                if (this.achievement) continue;
                GT_Mod.achievements.issueAchievement(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()), "muchsteam");
                this.achievement = true;
                continue;
            }
            if (!fluidName.equals("ic2.fluidSuperheatedSteam")) continue;
            this.depleteInput(new FluidStack(aFluids.get(i), aFluids.get((int)i).amount));
        }
        if (totalFlow <= 0) {
            return 0;
        }
        tEU = totalFlow;
        int waterToOutput = this.useWater((float)totalFlow / 160.0f);
        this.addOutput(GT_ModHandler.getDistilledWater((long)waterToOutput));
        if ((long)totalFlow != aOptFlow) {
            float efficiency = 1.0f - Math.abs((float)((long)totalFlow - aOptFlow) / (float)aOptFlow);
            tEU = (int)((float)tEU * efficiency);
            tEU = Math.max(1, MathUtils.safeInt((long)tEU * (long)aBaseEff / 20000L));
        } else {
            tEU = MathUtils.safeInt((long)tEU * (long)aBaseEff / 20000L);
        }
        return tEU;
    }

    @Override
    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.looseFit ^= true;
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(this.looseFit ? "Fitting: Loose - More Flow" : "Fitting: Tight - More Efficiency"));
        }
        if (this.looseFit) {
            super.onModeChangeByScrewdriver(side, aPlayer, aX, aY, aZ);
        } else if (this.mFastMode) {
            PlayerUtils.messagePlayer(aPlayer, "Running in Fast (48x) Mode.");
        } else {
            PlayerUtils.messagePlayer(aPlayer, "Running in Slow (16x) Mode.");
        }
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return this.looseFit && CORE.RANDOM.nextInt(4) == 0 ? 0 : 1;
    }

    @Override
    public boolean isLooseMode() {
        return this.looseFit;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("turbineFitting", this.looseFit);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.looseFit = aNBT.func_74767_n("turbineFitting");
    }

    @Override
    public String getMachineType() {
        return "Large Steam Turbine";
    }

    @Override
    protected String getTurbineType() {
        return "Steam";
    }

    @Override
    protected String getCasingName() {
        return "Reinforced Steam Turbine Casing";
    }

    @Override
    protected ITexture getTextureFrontFace() {
        return new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.LARGETURBINE_ST5);
    }

    @Override
    protected ITexture getTextureFrontFaceActive() {
        return new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.LARGETURBINE_ST_ACTIVE5);
    }
}

