/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.blocks.tileEntity.base.GT_MetaTileEntity_TooltipMultiBlockBase_EM;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import goodgenerator.util.MyRecipeAdder;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class FuelRefineFactory
extends GT_MetaTileEntity_TooltipMultiBlockBase_EM
implements IConstructable,
ISurvivalConstructable {
    private IStructureDefinition<FuelRefineFactory> multiDefinition = null;
    private int Tier = -1;
    private int[] cnt = new int[]{0, 0, 0};
    private static final Block[] coils = new Block[]{Loaders.FRF_Coil_1, Loaders.FRF_Coil_2, Loaders.FRF_Coil_3};

    public FuelRefineFactory(String name) {
        super(name);
        this.turnOffMaintenance();
    }

    public FuelRefineFactory(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
        this.turnOffMaintenance();
    }

    public void onFirstTick_EM(IGregTechTileEntity aBaseMetaTileEntity) {
        if (!this.hasMaintenanceChecks) {
            this.turnOffMaintenance();
        }
    }

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.structureBuild_EM(this.mName, 7, 12, 1, itemStack, hintsOnly);
    }

    public IStructureDefinition<FuelRefineFactory> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"               ", "      CCC      ", "               "}, {"      XGX      ", "    CCFFFCC    ", "      XGX      "}, {"    CC   CC    ", "   CFFCCCFFC   ", "    CC   CC    "}, {"   C       C   ", "  CFCC   CCFC  ", "   C       C   "}, {"  C         C  ", " CFC       CFC ", "  C         C  "}, {"  C         C  ", " CFC       CFC ", "  C         C  "}, {" X           X ", "CFC         CFC", " X           X "}, {" G           G ", "CFC         CFC", " G           G "}, {" X           X ", "CFC         CFC", " X           X "}, {"  C         C  ", " CFC       CFC ", "  C         C  "}, {"  C         C  ", " CFC       CFC ", "  C         C  "}, {"   C       C   ", "  CFCC   CCFC  ", "   C       C   "}, {"    CC   CC    ", "   CFFC~CFFC   ", "    CC   CC    "}, {"      XGX      ", "    CCFFFCC    ", "      XGX      "}, {"               ", "      CCC      ", "               "}})).addElement('X', (IStructureElement)GT_StructureUtility.buildHatchAdder(FuelRefineFactory.class).atLeast(new IHatchElement[]{GT_HatchElement.Maintenance, GT_HatchElement.InputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputHatch, GT_MetaTileEntity_MultiblockBase_EM.HatchElement.EnergyMulti.or((IHatchElement)GT_HatchElement.Energy)}).casingIndex(179).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)Loaders.FRF_Casings, (int)0)})).addElement('C', StructureUtility.ofBlock((Block)Loaders.FRF_Casings, (int)0)).addElement('G', StructureUtility.ofBlock((Block)Loaders.fieldRestrictingGlass, (int)0)).addElement('F', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(x -> {
                x.cnt[0] = x.cnt[0] + 1;
            }, FuelRefineFactory.ofFieldCoil(0)), StructureUtility.onElementPass(x -> {
                x.cnt[1] = x.cnt[1] + 1;
            }, FuelRefineFactory.ofFieldCoil(1)), StructureUtility.onElementPass(x -> {
                x.cnt[2] = x.cnt[2] + 1;
            }, FuelRefineFactory.ofFieldCoil(2))})).build();
        }
        return this.multiDefinition;
    }

    public static <T> IStructureElement<T> ofFieldCoil(final int aIndex) {
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                Block block = world.func_147439_a(x, y, z);
                return block.equals(coils[aIndex]);
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)coils[this.getIndex(trigger)], (int)0);
                return true;
            }

            private int getIndex(ItemStack trigger) {
                int s = trigger.field_77994_a;
                if (s > 3 || s <= 0) {
                    s = 3;
                }
                return s - 1;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return world.func_147465_d(x, y, z, coils[this.getIndex(trigger)], 0, 3);
            }
        };
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Naquadah Fuel Refinery").addInfo("Controller block for the Naquadah Fuel Refinery").addInfo("But at what cost?").addInfo("Produce the endgame naquadah fuel.").addInfo("Need field restriction coil to control the fatal radiation.").addInfo("Use higher tier coil to unlock more fuel and reduce the process time.").addInfo("The structure is too complex!").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().beginStructureBlock(3, 15, 15, false).addInputHatch("The casings adjoin the field restriction glass.").addInputBus("The casings adjoin the field restriction glass.").addOutputHatch("The casings adjoin the field restriction glass.").addEnergyHatch("The casings adjoin the field restriction glass.").toolTipFinisher("Good Generator");
        return tt;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.Tier = aNBT.func_74762_e("mTier");
        super.loadNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mTier", this.Tier);
        super.saveNBTData(aNBT);
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return DescTextLocalization.addText("FuelRefineFactory.hint", 8);
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.cnt[0] = 0;
        this.cnt[1] = 0;
        this.cnt[2] = 0;
        return this.structureCheck_EM(this.mName, 7, 12, 1) && this.getTier() != -1;
    }

    public int getTier() {
        for (int i = 0; i < 3; ++i) {
            if (this.cnt[i] != 32) continue;
            this.Tier = i + 1;
            return i;
        }
        this.Tier = -1;
        return -1;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return MyRecipeAdder.instance.FRF;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GT_Recipe recipe) {
                if (recipe.mSpecialValue > FuelRefineFactory.this.Tier) {
                    return CheckRecipeResultRegistry.insufficientMachineTier((int)recipe.mSpecialValue);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @NotNull
            protected GT_OverclockCalculator createOverclockCalculator(@NotNull GT_Recipe recipe) {
                int overclockAmount = FuelRefineFactory.this.Tier - recipe.mSpecialValue;
                return super.createOverclockCalculator(recipe).limitOverclockCount(overclockAmount);
            }
        }.setOverclock(1, 1);
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(this.getMaxInputEu());
        logic.setAvailableAmperage(1L);
    }

    public final boolean addToFRFList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyMulti) {
            return this.eEnergyMulti.add((GT_MetaTileEntity_Hatch_EnergyMulti)aMetaTileEntity);
        }
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new FuelRefineFactory(this.mName);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public String[] getInfoData() {
        String[] infoData = new String[super.getInfoData().length + 1];
        System.arraycopy(super.getInfoData(), 0, infoData, 0, super.getInfoData().length);
        infoData[super.getInfoData().length] = StatCollector.func_74838_a((String)"scanner.info.FRF") + " " + this.Tier;
        return infoData;
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public boolean supportsVoidProtection() {
        return true;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)179), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)179), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW}).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)179)};
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 7, 12, 1, elementBudget, source, actor, false, true);
    }
}

