/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity.GTMetaTileEntity;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import goodgenerator.blocks.tileEntity.NeutronActivator;
import goodgenerator.util.CharExchanger;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class NeutronSensor
extends GT_MetaTileEntity_Hatch {
    private static final IIconContainer textureFont = new Textures.BlockIcons.CustomIcon("icons/NeutronSensorFont");
    private static final IIconContainer textureFont_Glow = new Textures.BlockIcons.CustomIcon("icons/NeutronSensorFont_GLOW");
    protected String texts = "";
    boolean isOn = false;

    public NeutronSensor(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "Detect Neutron Kinetic Energy.", new ITexture[0]);
    }

    public NeutronSensor(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    public String[] getDescription() {
        return new String[]{"Can be installed in Neutron Activator.", "Output Redstone Signal according to the Neutron Kinetic Energy.", "Right click to open the GUI and setting."};
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.texts = aNBT.func_74779_i("mBoxContext");
        super.loadNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74778_a("mBoxContext", this.texts);
        super.saveNBTData(aNBT);
    }

    public void initDefaultModes(NBTTagCompound aNBT) {
        this.getBaseMetaTileEntity().setActive(true);
    }

    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public void setText(String text) {
        this.texts = text == null ? "" : text;
    }

    public String getText() {
        return this.texts == null ? "" : this.texts;
    }

    public void outputRedstoneSignal() {
        this.isOn = true;
    }

    public void stopOutputRedstoneSignal() {
        this.isOn = false;
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)textureFont), TextureFactory.builder().addIcon(new IIconContainer[]{textureFont_Glow}).glow().build()};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)textureFont)};
    }

    public boolean allowGeneralRedstoneOutput() {
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.isOn) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                aBaseMetaTileEntity.setInternalOutputRedstoneSignal(side, (byte)15);
            }
        } else {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                aBaseMetaTileEntity.setInternalOutputRedstoneSignal(side, (byte)0);
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new NeutronSensor(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection Side2, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public boolean useModularUI() {
        return true;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        TextFieldWidget textField = new TextFieldWidget();
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(textField.setGetter(this::getText).setSetter(this::setText).setValidator(str -> this.isValidExpression((String)str) ? str : (textField.getLastText().size() > 0 ? (String)textField.getLastText().get(0) : "")).setFocusOnGuiOpen(true).setTextColor(Color.WHITE.dark(1)).setTextAlignment(Alignment.CenterLeft).setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)}).setPos(8, 48).setSize(100, 18))).widget(new TextWidget(StatCollector.func_74838_a((String)"gui.NeutronSensor.0")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setTextAlignment(Alignment.CenterLeft).setPos(8, 8))).widget(new TextWidget(StatCollector.func_74838_a((String)"gui.NeutronSensor.1")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(8, 32))).widget(TextWidget.dynamicText(() -> this.isValidExpression(textField.getText()) ? new Text(StatCollector.func_74838_a((String)"gui.NeutronSensor.2")).color(490754) : new Text(StatCollector.func_74838_a((String)"gui.NeutronSensor.3")).color(((Integer)this.COLOR_TEXT_RED.get()).intValue())).setSynced(false).setPos(120, 53));
    }

    private boolean isValidExpression(String exp) {
        return this.isValidSuffix(exp) && CharExchanger.isValidCompareExpress(NeutronActivator.rawProcessExp(exp));
    }

    private boolean isValidSuffix(String exp) {
        int index = exp.length() - 1;
        if (index < 0) {
            return false;
        }
        if (exp.charAt(index) != 'V' && exp.charAt(index) != 'v') {
            return false;
        }
        index = exp.length() - 2;
        if (index < 0) {
            return false;
        }
        if (exp.charAt(index) != 'E' && exp.charAt(index) != 'e') {
            return false;
        }
        index = exp.length() - 3;
        if (index < 0) {
            return false;
        }
        return exp.charAt(index) == 'M' || exp.charAt(index) == 'm' || exp.charAt(index) == 'K' || exp.charAt(index) == 'k' || Character.isDigit(exp.charAt(index));
    }
}

