/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.crossmod.thaumcraft;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import goodgenerator.crossmod.thaumcraft.FuelData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import thaumcraft.api.aspects.Aspect;

public class LargeEssentiaEnergyData {
    public static final HashMap<Aspect, FuelData> ASPECT_FUEL_DATA = new HashMap();

    public static String readJsonFile() {
        try {
            String s;
            URL url = Thread.currentThread().getContextClassLoader().getResource("assets/goodgenerator/data/essentia.json");
            assert (url != null);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((s = in.readLine()) != null) {
                sb.append(s);
            }
            in.close();
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void processEssentiaData() {
        String data = LargeEssentiaEnergyData.readJsonFile();
        if (data == null) {
            return;
        }
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = (JsonObject)jsonParser.parse(data);
        JsonArray jsonArray = jsonObject.get("Essentia").getAsJsonArray();
        for (JsonElement elm : jsonArray) {
            JsonObject essData = elm.getAsJsonObject();
            String aspectName = essData.get("name").getAsString();
            Aspect aspect = Aspect.getAspect((String)aspectName.toLowerCase());
            if (aspect == null) continue;
            int fuel = essData.get("fuelValue").getAsInt();
            String cate = essData.get("category").getAsString();
            float ceo = essData.get("consumeCeo").getAsFloat();
            ASPECT_FUEL_DATA.put(aspect, new FuelData(fuel, cate, ceo));
        }
    }

    public static int getAspectTypeIndex(Aspect aspect) {
        if (ASPECT_FUEL_DATA.containsKey(aspect)) {
            return ASPECT_FUEL_DATA.get(aspect).getCategoryIndex();
        }
        return -1;
    }

    public static String getAspectType(Aspect aspect) {
        if (ASPECT_FUEL_DATA.containsKey(aspect)) {
            return ASPECT_FUEL_DATA.get(aspect).getCategory();
        }
        return null;
    }

    public static int getAspectFuelValue(Aspect aspect) {
        if (ASPECT_FUEL_DATA.containsKey(aspect)) {
            return ASPECT_FUEL_DATA.get(aspect).getFuelValue();
        }
        return 0;
    }

    public static float getAspectCeo(Aspect aspect) {
        if (ASPECT_FUEL_DATA.containsKey(aspect)) {
            return ASPECT_FUEL_DATA.get(aspect).getConsumeSpeed();
        }
        return 0.0f;
    }
}

