/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.parser.text;

import com.github.lunatrius.ingameinfo.parser.text.InvalidTokenException;
import com.github.lunatrius.ingameinfo.parser.text.Location;
import com.github.lunatrius.ingameinfo.parser.text.Token;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;
import java.util.regex.Matcher;

public class Tokenizer {
    private final Queue<Token> tokens = new LinkedList<Token>();

    public void tokenize(String str) throws Exception {
        Location start = new Location(0, 0);
        Location end = new Location(0, 0);
        this.tokens.clear();
        str = str.trim();
        while (str.length() > 0) {
            boolean match = false;
            for (Token.TokenType tokenType : Token.TokenType.values()) {
                Matcher matcher = tokenType.getPattern().matcher(str);
                if (!matcher.find()) continue;
                match = true;
                String lexem = matcher.group();
                str = matcher.replaceFirst("");
                if (tokenType.equals((Object)Token.TokenType.NEWLINE)) {
                    int lines = lexem.length() - lexem.replace("\n", "").length();
                    end.setRow(start.getRow() + lines);
                    end.setColumn(0);
                } else {
                    end.setColumn(start.getColumn() + lexem.length());
                }
                this.tokens.add(new Token(lexem, start.clone(), end.clone(), tokenType));
                start = end.clone();
                break;
            }
            if (match) continue;
            throw new InvalidTokenException(String.format(Locale.ENGLISH, "Invalid token at %s!", start));
        }
        this.tokens.add(new Token("", start.clone(), end.clone(), Token.TokenType.EOF));
    }

    public Token nextToken() {
        return this.tokens.remove();
    }
}

