/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.component.traits;

import li.cil.oc.Settings$;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.prefab.ItemStackArrayValue;
import li.cil.oc.server.component.UpgradeDatabase;
import li.cil.oc.server.component.package$;
import li.cil.oc.server.component.traits.WorldInventoryAnalytics;
import li.cil.oc.server.component.traits.WorldInventoryAnalytics$;
import li.cil.oc.util.BlockInventorySource;
import li.cil.oc.util.BlockPosition;
import li.cil.oc.util.DatabaseAccess$;
import li.cil.oc.util.EntityInventorySource;
import li.cil.oc.util.ExtendedArguments$;
import li.cil.oc.util.ExtendedWorld$;
import li.cil.oc.util.InventorySource;
import li.cil.oc.util.InventoryUtils$;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Unit$;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public abstract class WorldInventoryAnalytics$class {
    @Callback(doc="function(side:number):number -- Get the number of slots in the inventory on the specified side of the device.")
    public static Object[] getInventorySize(WorldInventoryAnalytics $this, Context context, Arguments args) {
        ForgeDirection facing = $this.checkSideForAction(args, 0);
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Object[] apply(IInventory inventory2) {
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)inventory2.func_70302_i_())}));
            }
        });
    }

    @Callback(doc="function(side:number, slot:number):number -- Get number of items in the specified slot of the inventory on the specified side of the device.")
    public static Object[] getSlotStackSize(WorldInventoryAnalytics $this, Context context, Arguments args) {
        ForgeDirection facing = $this.checkSideForAction(args, 0);
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, args){
            public static final long serialVersionUID = 0L;
            private final Arguments args$1;

            public final Object[] apply(IInventory inventory2) {
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.apply((Object)inventory2.func_70301_a(ExtendedArguments$.MODULE$.extendedArguments(this.args$1).checkSlot(inventory2, 1))).fold((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(ItemStack x$1) {
                        return x$1.field_77994_a;
                    }
                })}));
            }
            {
                this.args$1 = args$1;
            }
        });
    }

    @Callback(doc="function(side:number, slot:number):number -- Get the maximum number of items in the specified slot of the inventory on the specified side of the device.")
    public static Object[] getSlotMaxStackSize(WorldInventoryAnalytics $this, Context context, Arguments args) {
        ForgeDirection facing = $this.checkSideForAction(args, 0);
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, args){
            public static final long serialVersionUID = 0L;
            private final Arguments args$2;

            public final Object[] apply(IInventory inventory2) {
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.apply((Object)inventory2.func_70301_a(ExtendedArguments$.MODULE$.extendedArguments(this.args$2).checkSlot(inventory2, 1))).fold((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(ItemStack x$2) {
                        return x$2.func_77976_d();
                    }
                })}));
            }
            {
                this.args$2 = args$2;
            }
        });
    }

    @Callback(doc="function(side:number, slotA:number, slotB:number[, checkNBT:boolean=false]):boolean -- Get whether the items in the two specified slots of the inventory on the specified side of the device are of the same type.")
    public static Object[] compareStacks(WorldInventoryAnalytics $this, Context context, Arguments args) {
        ForgeDirection facing = $this.checkSideForAction(args, 0);
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, args){
            public static final long serialVersionUID = 0L;
            private final Arguments args$3;

            public final Object[] apply(IInventory inventory2) {
                ItemStack stackA = inventory2.func_70301_a(ExtendedArguments$.MODULE$.extendedArguments(this.args$3).checkSlot(inventory2, 1));
                ItemStack stackB = inventory2.func_70301_a(ExtendedArguments$.MODULE$.extendedArguments(this.args$3).checkSlot(inventory2, 2));
                Object[] objectArray = new Object[1];
                ItemStack itemStack = stackA;
                ItemStack itemStack2 = stackB;
                objectArray[0] = BoxesRunTime.boxToBoolean((!(itemStack == null ? itemStack2 != null : !itemStack.equals(itemStack2)) || InventoryUtils$.MODULE$.haveSameItemType(stackA, stackB, this.args$3.optBoolean(3, false)) ? 1 : 0) != 0);
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)objectArray));
            }
            {
                this.args$3 = args$3;
            }
        });
    }

    @Callback(doc="function(side:number, slot:number, dbAddress:string, dbSlot:number[, checkNBT:boolean=false]):boolean -- Compare an item in the specified slot in the inventory on the specified side with one in the database with the specified address.")
    public static Object[] compareStackToDatabase(WorldInventoryAnalytics $this, Context context, Arguments args) {
        ForgeDirection facing = $this.checkSideForAction(args, 0);
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, args){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WorldInventoryAnalytics $outer;
            public final Arguments args$4;

            public final Object[] apply(IInventory inventory2) {
                int slot = ExtendedArguments$.MODULE$.extendedArguments(this.args$4).checkSlot(inventory2, 1);
                String dbAddress = this.args$4.checkString(2);
                ItemStack stack = inventory2.func_70301_a(slot);
                return DatabaseAccess$.MODULE$.withDatabase(this.$outer.node(), dbAddress, (Function1<UpgradeDatabase, Object[]>)new Serializable(this, stack){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ WorldInventoryAnalytics$.anonfun.compareStackToDatabase.1 $outer;
                    private final ItemStack stack$1;

                    public final Object[] apply(UpgradeDatabase database) {
                        int dbSlot = ExtendedArguments$.MODULE$.extendedArguments(this.$outer.args$4).checkSlot(database.data(), 3);
                        ItemStack dbStack = database.getStackInSlot(dbSlot);
                        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)InventoryUtils$.MODULE$.haveSameItemType(this.stack$1, dbStack, this.$outer.args$4.optBoolean(4, false)))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.stack$1 = stack$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.args$4 = args$4;
            }
        });
    }

    @Callback(doc="function(side:number, slotA:number, slotB:number):boolean -- Get whether the items in the two specified slots of the inventory on the specified side of the device are equivalent (have shared OreDictionary IDs).")
    public static Object[] areStacksEquivalent(WorldInventoryAnalytics $this, Context context, Arguments args) {
        ForgeDirection facing = $this.checkSideForAction(args, 0);
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, args){
            public static final long serialVersionUID = 0L;
            private final Arguments args$5;

            public final Object[] apply(IInventory inventory2) {
                ItemStack stackA = inventory2.func_70301_a(ExtendedArguments$.MODULE$.extendedArguments(this.args$5).checkSlot(inventory2, 1));
                ItemStack stackB = inventory2.func_70301_a(ExtendedArguments$.MODULE$.extendedArguments(this.args$5).checkSlot(inventory2, 2));
                Object[] objectArray = new Object[1];
                ItemStack itemStack = stackA;
                ItemStack itemStack2 = stackB;
                objectArray[0] = BoxesRunTime.boxToBoolean((!(itemStack == null ? itemStack2 != null : !itemStack.equals(itemStack2)) || stackA != null && stackB != null && Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(OreDictionary.getOreIDs((ItemStack)stackA)).intersect((GenSeq)Predef$.MODULE$.wrapIntArray(OreDictionary.getOreIDs((ItemStack)stackB)))).nonEmpty() ? 1 : 0) != 0);
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)objectArray));
            }
            {
                this.args$5 = args$5;
            }
        });
    }

    @Callback(doc="function(side:number, slot:number, label:string):boolean -- Change the display name of the stack in the inventory on the specified side of the device.")
    public static Object[] setStackDisplayName(WorldInventoryAnalytics $this, Context context, Arguments args) {
        ForgeDirection facing = $this.checkSideForAction(args, 0);
        String label = args.checkString(2).trim();
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, label, args){
            public static final long serialVersionUID = 0L;
            private final String label$1;
            private final Arguments args$6;

            public final Object[] apply(IInventory inventory2) {
                Object[] objectArray;
                ItemStack stack = inventory2.func_70301_a(ExtendedArguments$.MODULE$.extendedArguments(this.args$6).checkSlot(inventory2, 1));
                if (stack != null && stack.field_77994_a > 0) {
                    ItemStack itemStack;
                    if (new StringOps(Predef$.MODULE$.augmentString(this.label$1)).nonEmpty()) {
                        itemStack = stack.func_151001_c(this.label$1);
                    } else {
                        if (stack.func_82837_s()) {
                            stack.func_135074_t();
                        }
                        itemStack = BoxedUnit.UNIT;
                    }
                    objectArray = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true)}));
                } else {
                    objectArray = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)false)}));
                }
                return objectArray;
            }
            {
                this.label$1 = label$1;
                this.args$6 = args$6;
            }
        });
    }

    @Callback(doc="function(side:number, slot:number):table -- Get a description of the stack in the inventory on the specified side of the device.")
    public static Object[] getStackInSlot(WorldInventoryAnalytics $this, Context context, Arguments args) {
        Object[] objectArray;
        if (Settings$.MODULE$.get().allowItemStackInspection()) {
            ForgeDirection facing = $this.checkSideForAction(args, 0);
            objectArray = WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, args){
                public static final long serialVersionUID = 0L;
                private final Arguments args$7;

                public final Object[] apply(IInventory inventory2) {
                    return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inventory2.func_70301_a(ExtendedArguments$.MODULE$.extendedArguments(this.args$7).checkSlot(inventory2, 1))}));
                }
                {
                    this.args$7 = args$7;
                }
            });
        } else {
            objectArray = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "not enabled in config"}));
        }
        return objectArray;
    }

    @Callback(doc="function(side:number):userdata -- Get a description of all stacks in the inventory on the specified side of the device.")
    public static Object[] getAllStacks(WorldInventoryAnalytics $this, Context context, Arguments args) {
        Object[] objectArray;
        if (Settings$.MODULE$.get().allowItemStackInspection()) {
            ForgeDirection facing = $this.checkSideForAction(args, 0);
            objectArray = WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Object[] apply(IInventory inventory2) {
                    ItemStack[] stacks = new ItemStack[inventory2.func_70302_i_()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), inventory2.func_70302_i_()).foreach$mVc$sp((Function1)new Serializable(this, stacks, inventory2){
                        public static final long serialVersionUID = 0L;
                        private final ItemStack[] stacks$1;
                        private final IInventory inventory$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.stacks$1[i] = this.inventory$1.func_70301_a(i);
                        }
                        {
                            this.stacks$1 = stacks$1;
                            this.inventory$1 = inventory$1;
                        }
                    });
                    return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ItemStackArrayValue(stacks)}));
                }
            });
        } else {
            objectArray = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "not enabled in config"}));
        }
        return objectArray;
    }

    @Callback(doc="function(side:number):string -- Get the the name of the inventory on the specified side of the device.")
    public static Object[] getInventoryName(WorldInventoryAnalytics $this, Context context, Arguments args) {
        Object[] objectArray;
        if (Settings$.MODULE$.get().allowItemStackInspection()) {
            ForgeDirection facing = $this.checkSideForAction(args, 0);
            objectArray = WorldInventoryAnalytics$class.withInventorySource($this, facing, (Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ WorldInventoryAnalytics $outer;

                public final Object[] apply(InventorySource x0$1) {
                    Object[] objectArray;
                    InventorySource inventorySource = x0$1;
                    if (inventorySource instanceof BlockInventorySource) {
                        Object[] objectArray2;
                        BlockInventorySource blockInventorySource = (BlockInventorySource)inventorySource;
                        BlockPosition position = blockInventorySource.position();
                        Option option = WorldInventoryAnalytics$class.blockAt$1(this.$outer, position);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Block block = (Block)some.x();
                            objectArray2 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{block.func_149739_a()}));
                        } else {
                            objectArray2 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "Unknown"}));
                        }
                        objectArray = objectArray2;
                    } else if (inventorySource instanceof EntityInventorySource) {
                        EntityInventorySource entityInventorySource = (EntityInventorySource)inventorySource;
                        Entity entity = entityInventorySource.entity();
                        objectArray = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EntityList.func_75621_b((Entity)entity)}));
                    } else {
                        objectArray = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "Unknown"}));
                    }
                    return objectArray;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            objectArray = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "not enabled in config"}));
        }
        return objectArray;
    }

    @Callback(doc="function(side:number, slot:number, dbAddress:string, dbSlot:number):boolean -- Store an item stack description in the specified slot of the database with the specified address.")
    public static Object[] store(WorldInventoryAnalytics $this, Context context, Arguments args) {
        ForgeDirection facing = $this.checkSideForAction(args, 0);
        String dbAddress = args.checkString(2);
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, dbAddress, args){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WorldInventoryAnalytics $outer;
            private final String dbAddress$1;
            private final Arguments args$8;

            public final Object[] apply(IInventory inventory2) {
                return WorldInventoryAnalytics$class.store$1(this.$outer, inventory2.func_70301_a(ExtendedArguments$.MODULE$.extendedArguments(this.args$8).checkSlot(inventory2, 1)), this.dbAddress$1, this.args$8);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dbAddress$1 = dbAddress$1;
                this.args$8 = args$8;
            }
        });
    }

    private static boolean mayInteract(WorldInventoryAnalytics $this, ForgeDirection side, InventorySource f) {
        boolean bl;
        if (f.inventory().func_70300_a($this.fakePlayer())) {
            boolean bl2;
            InventorySource inventorySource = f;
            if (inventorySource instanceof BlockInventorySource) {
                BlockInventorySource blockInventorySource = (BlockInventorySource)inventorySource;
                BlockPosition pos = blockInventorySource.position();
                bl2 = $this.mayInteract(pos, side.getOpposite());
            } else {
                bl2 = true;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    private static Object[] withInventorySource(WorldInventoryAnalytics $this, ForgeDirection side, Function1 f) {
        Some some;
        InventorySource is;
        Option<InventorySource> option = InventoryUtils$.MODULE$.inventorySourceAt($this.position().offset(side));
        Object[] objectArray = option instanceof Some && WorldInventoryAnalytics$class.mayInteract($this, side, is = (InventorySource)(some = (Some)option).x()) ? (Object[])f.apply((Object)is) : package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "no inventory"}));
        return objectArray;
    }

    private static Object[] withInventory(WorldInventoryAnalytics $this, ForgeDirection side, Function1 f) {
        return WorldInventoryAnalytics$class.withInventorySource($this, side, (Function1)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$1;

            public final Object[] apply(InventorySource is) {
                return (Object[])this.f$1.apply((Object)is.inventory());
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    public static final Option blockAt$1(WorldInventoryAnalytics $this, BlockPosition position) {
        None$ none$;
        Some some;
        World world;
        Option<World> option = position.world();
        if (option instanceof Some && ExtendedWorld$.MODULE$.extendedWorld(world = (World)(some = (Some)option).x()).blockExists(position)) {
            None$ none$2;
            Block block = ExtendedWorld$.MODULE$.extendedWorld(world).getBlock(position);
            if (block != null) {
                Block block2 = block;
                none$2 = new Some((Object)block2);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final Object[] store$1(WorldInventoryAnalytics $this, ItemStack stack, String dbAddress$1, Arguments args$8) {
        return DatabaseAccess$.MODULE$.withDatabase($this.node(), dbAddress$1, (Function1<UpgradeDatabase, Object[]>)new Serializable($this, stack, args$8){
            public static final long serialVersionUID = 0L;
            private final ItemStack stack$2;
            private final Arguments args$8;

            public final Object[] apply(UpgradeDatabase database) {
                int dbSlot = ExtendedArguments$.MODULE$.extendedArguments(this.args$8).checkSlot(database.data(), 3);
                boolean nonEmpty = database.getStackInSlot(dbSlot) != null;
                database.setStackInSlot(dbSlot, this.stack$2.func_77946_l());
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)nonEmpty)}));
            }
            {
                this.stack$2 = stack$2;
                this.args$8 = args$8;
            }
        });
    }

    public static void $init$(WorldInventoryAnalytics $this) {
    }
}

