/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.collect.ImmutableList;
import java.util.List;
import openmods.calc.IExecutable;
import openmods.calc.UnaryOperator;
import openmods.calc.parsing.IExprNode;

public class UnaryOpNode<E>
implements IExprNode<E> {
    public final UnaryOperator<E> operator;
    public final IExprNode<E> argument;

    public UnaryOpNode(UnaryOperator<E> operator, IExprNode<E> argument) {
        this.operator = operator;
        this.argument = argument;
    }

    @Override
    public void flatten(List<IExecutable<E>> output) {
        this.argument.flatten(output);
        output.add(this.operator);
    }

    public String toString() {
        return "<op: " + this.operator.id + " a: " + this.argument + ">";
    }

    @Override
    public Iterable<IExprNode<E>> getChildren() {
        return ImmutableList.of(this.argument);
    }
}

