/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.microblock.MicroMaterialRegistry;
import gcewing.projectblue.ProjectBlue;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class ControlPanelMaterial {
    static Map<String, ControlPanelMaterial> cache = new HashMap<String, ControlPanelMaterial>();
    public String name;
    public Block block;
    public int metadata;

    public static ControlPanelMaterial forStack(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("mat")) {
            return ControlPanelMaterial.forName(nbt.func_74779_i("mat"));
        }
        return null;
    }

    public static ControlPanelMaterial forName(String name) {
        ControlPanelMaterial result = cache.get(name);
        if (result == null) {
            result = new ControlPanelMaterial(name);
            cache.put(name, result);
        }
        return result;
    }

    ControlPanelMaterial(String name) {
        ItemStack stack;
        Item item;
        this.name = name;
        MicroMaterialRegistry.IMicroMaterial mat = MicroMaterialRegistry.getMaterial((String)name);
        if (mat != null && (item = (stack = mat.getItem()).func_77973_b()) instanceof ItemBlock) {
            this.block = ((ItemBlock)item).field_150939_a;
            this.metadata = stack.func_77960_j();
            return;
        }
        this.block = Blocks.field_150344_f;
        this.metadata = 0;
    }

    public ItemStack newStack() {
        return this.newStack(ProjectBlue.controlPanelItem);
    }

    public ItemStack newStack(Item item) {
        return this.newStack(item, this.metadata);
    }

    public ItemStack newStack(Item item, int meta) {
        ItemStack stack = new ItemStack(item, 1, meta);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("mat", this.name);
        stack.func_77982_d(nbt);
        return stack;
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)(this.block.func_149739_a() + ".name"));
    }
}

