/*
 * Decompiled with CFR 0.152.
 */
package remoteio.core.transform;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import remoteio.core.MappingHelper;
import remoteio.core.mapping.MappingConstants;
import remoteio.core.transform.ITransformer;

public class TransformTessellator
implements ITransformer {
    private static final String METHOD_HANDLER = "remoteio/client/render/TessellatorCapture";

    @Override
    public String[] getClasses() {
        return new String[]{"net.minecraft.client.renderer.Tessellator"};
    }

    @Override
    public byte[] transform(String name, byte[] basicClass) {
        InsnList insnList;
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode getVertexStateNode = null;
        MethodNode addVertexNode = null;
        MethodNode setNormalNode = null;
        String tessellator = MappingConstants.Type.get(MappingConstants.Type.TESSELLATOR);
        String vertexState = MappingConstants.Type.get(MappingConstants.Type.TESSELLATOR_VERTEX_STATE);
        for (MethodNode methodNode : classNode.methods) {
            if (MappingConstants.Method.equals(methodNode, MappingConstants.Method.GET_VERTEX_STATE, MappingConstants.Method.Desc.GET_VERTEX_STATE)) {
                getVertexStateNode = methodNode;
                MappingHelper.logger.info("Found method 'getVertexState'");
                continue;
            }
            if (MappingConstants.Method.equals(methodNode, MappingConstants.Method.ADD_VERTEX, MappingConstants.Method.Desc.ADD_VERTEX)) {
                addVertexNode = methodNode;
                MappingHelper.logger.info("Found method 'addVertex'");
                continue;
            }
            if (!MappingConstants.Method.equals(methodNode, MappingConstants.Method.SET_NORMAL, MappingConstants.Method.Desc.SET_NORMAL)) continue;
            setNormalNode = methodNode;
            MappingHelper.logger.info("Found method 'setNormal'");
        }
        if (getVertexStateNode != null) {
            insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)this.getFieldNode(tessellator, MappingConstants.Field.RAW_BUFFER_INDEX, "I"));
            insnList.add((AbstractInsnNode)new InsnNode(4));
            LabelNode l1 = new LabelNode(new Label());
            insnList.add((AbstractInsnNode)new JumpInsnNode(162, l1));
            insnList.add((AbstractInsnNode)new TypeInsnNode(187, vertexState));
            insnList.add((AbstractInsnNode)new InsnNode(89));
            insnList.add((AbstractInsnNode)new InsnNode(3));
            insnList.add((AbstractInsnNode)new IntInsnNode(188, 10));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)this.getFieldNode(tessellator, MappingConstants.Field.RAW_BUFFER_INDEX, "I"));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)this.getFieldNode(tessellator, MappingConstants.Field.VERTEX_COUNT, "I"));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)this.getFieldNode(tessellator, MappingConstants.Field.HAS_TEXTURE, "Z"));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)this.getFieldNode(tessellator, MappingConstants.Field.HAS_BRIGHTNESS, "Z"));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)this.getFieldNode(tessellator, MappingConstants.Field.HAS_NORMALS, "Z"));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)this.getFieldNode(tessellator, MappingConstants.Field.HAS_COLOR, "Z"));
            insnList.add((AbstractInsnNode)new MethodInsnNode(183, vertexState, "<init>", "([IIIZZZZ)V", false));
            insnList.add((AbstractInsnNode)new InsnNode(176));
            insnList.add((AbstractInsnNode)l1);
            insnList.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
            getVertexStateNode.instructions.insertBefore(getVertexStateNode.instructions.get(0), insnList);
        }
        if (addVertexNode != null) {
            insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(24, 1));
            insnList.add((AbstractInsnNode)new VarInsnNode(24, 3));
            insnList.add((AbstractInsnNode)new VarInsnNode(24, 5));
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, METHOD_HANDLER, "rotatePointWithOffset", "(DDD)[D", false));
            insnList.add((AbstractInsnNode)new VarInsnNode(58, 6));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 6));
            insnList.add((AbstractInsnNode)new InsnNode(3));
            insnList.add((AbstractInsnNode)new InsnNode(49));
            insnList.add((AbstractInsnNode)new VarInsnNode(57, 1));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 6));
            insnList.add((AbstractInsnNode)new InsnNode(4));
            insnList.add((AbstractInsnNode)new InsnNode(49));
            insnList.add((AbstractInsnNode)new VarInsnNode(57, 3));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 6));
            insnList.add((AbstractInsnNode)new InsnNode(5));
            insnList.add((AbstractInsnNode)new InsnNode(49));
            insnList.add((AbstractInsnNode)new VarInsnNode(57, 5));
            addVertexNode.instructions.insertBefore(addVertexNode.instructions.get(0), insnList);
        }
        if (setNormalNode != null) {
            insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(23, 1));
            insnList.add((AbstractInsnNode)new InsnNode(141));
            insnList.add((AbstractInsnNode)new VarInsnNode(23, 2));
            insnList.add((AbstractInsnNode)new InsnNode(141));
            insnList.add((AbstractInsnNode)new VarInsnNode(23, 3));
            insnList.add((AbstractInsnNode)new InsnNode(141));
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, METHOD_HANDLER, "rotatePoint", "(DDD)[D", false));
            insnList.add((AbstractInsnNode)new VarInsnNode(58, 3));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 3));
            insnList.add((AbstractInsnNode)new InsnNode(3));
            insnList.add((AbstractInsnNode)new InsnNode(49));
            insnList.add((AbstractInsnNode)new InsnNode(144));
            insnList.add((AbstractInsnNode)new VarInsnNode(56, 1));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 3));
            insnList.add((AbstractInsnNode)new InsnNode(4));
            insnList.add((AbstractInsnNode)new InsnNode(49));
            insnList.add((AbstractInsnNode)new InsnNode(144));
            insnList.add((AbstractInsnNode)new VarInsnNode(56, 2));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 3));
            insnList.add((AbstractInsnNode)new InsnNode(5));
            insnList.add((AbstractInsnNode)new InsnNode(49));
            insnList.add((AbstractInsnNode)new InsnNode(144));
            insnList.add((AbstractInsnNode)new VarInsnNode(56, 3));
            setNormalNode.instructions.insertBefore(setNormalNode.instructions.get(0), insnList);
        }
        if (getVertexStateNode != null && addVertexNode != null && setNormalNode != null) {
            MappingHelper.logger.warn("Successfully transformed Tessellator.class!");
            ClassWriter classWriter = new ClassWriter(0);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        MappingHelper.logger.warn("Failed to transform Tessellator.class!");
        return basicClass;
    }

    private FieldInsnNode getFieldNode(String owner, String[] name, String desc) {
        if (MappingHelper.obfuscated) {
            return new FieldInsnNode(180, owner, name[2], desc);
        }
        return new FieldInsnNode(180, owner, name[0], desc);
    }
}

