/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.maps;

import com.github.technus.tectech.mechanics.elementalMatter.core.EMException;
import com.github.technus.tectech.mechanics.elementalMatter.core.decay.EMDecayResult;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMDefinitionsRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.IEMMapWrite;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.EMDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.EMInstanceStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.IEMStack;
import com.github.technus.tectech.util.DoubleCount;
import com.github.technus.tectech.util.TT_Utility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public final class EMInstanceStackMap
extends EMStackMap<EMInstanceStack>
implements IEMMapWrite<EMInstanceStack> {
    public EMInstanceStackMap() {
    }

    public EMInstanceStackMap(EMInstanceStack ... inSafe) {
        this(true, inSafe);
    }

    public EMInstanceStackMap(boolean clone, EMInstanceStack ... in) {
        if (clone) {
            IEMStack[] stacks = new EMInstanceStack[in.length];
            for (int i = 0; i < stacks.length; ++i) {
                stacks[i] = in[i].clone();
            }
            this.putUnifyAll(stacks);
        } else {
            this.putUnifyAll(in);
        }
    }

    private EMInstanceStackMap(NavigableMap<IEMDefinition, EMInstanceStack> inSafe) {
        this(true, inSafe);
    }

    private EMInstanceStackMap(boolean clone, NavigableMap<IEMDefinition, EMInstanceStack> in) {
        super(clone ? new TreeMap() : in);
        if (clone) {
            for (EMInstanceStack stack : in.values()) {
                this.putUnify(stack.clone());
            }
        }
    }

    @Override
    public Class<EMInstanceStack> getType() {
        return EMInstanceStack.class;
    }

    @Override
    public EMInstanceStackMap clone() {
        return new EMInstanceStackMap(this.getBackingMap());
    }

    public double removeOverflow(int stacksCount, double stackCapacity) {
        double massRemoved = 0.0;
        if (this.size() > stacksCount) {
            IEMDefinition[] keys = this.keySetToArray();
            for (int i = stacksCount; i < keys.length; ++i) {
                massRemoved += ((EMInstanceStack)this.get(keys[i])).getDefinitionStack().getMass();
                this.removeKey(keys[i]);
            }
        }
        for (EMInstanceStack instance : (EMInstanceStack[])this.valuesToArray()) {
            if (!(instance.getAmount() > stackCapacity)) continue;
            massRemoved += instance.getDefinition().getMass() * (instance.getAmount() - stackCapacity);
            instance.setAmount(stackCapacity);
        }
        return massRemoved;
    }

    @Override
    public String[] getElementalInfo() {
        String[] info = new String[this.size()];
        int i = 0;
        for (Map.Entry entry : this.entrySet()) {
            EMInstanceStack instance = (EMInstanceStack)entry.getValue();
            info[i++] = EnumChatFormatting.BLUE + instance.getDefinition().getLocalizedName() + " " + EnumChatFormatting.AQUA + instance.getDefinition().getSymbol() + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"tt.keyword.short.amount") + ": " + EnumChatFormatting.GREEN + TT_Utility.formatNumberExp(instance.getAmount() / 6.02214076E23) + " " + StatCollector.func_74838_a((String)"tt.keyword.unit.mol") + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"tt.keyword.short.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((double)instance.getDefinition().getEnergyDiffBetweenStates(0L, instance.getEnergy())) + " " + StatCollector.func_74838_a((String)"tt.keyword.unit.energy") + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"tt.keyword.short.charge") + ": " + EnumChatFormatting.GREEN + TT_Utility.formatNumberExp(instance.getCharge()) + " " + StatCollector.func_74838_a((String)"tt.keyword.unit.charge") + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"tt.keyword.short.time") + ": " + EnumChatFormatting.GREEN + (instance.getLifeTime() < 0.0 ? StatCollector.func_74838_a((String)"tt.keyword.stable") : TT_Utility.formatNumberShortExp(instance.getLifeTime()) + " " + StatCollector.func_74838_a((String)"tt.keyword.unit.time")) + EnumChatFormatting.RESET;
        }
        return info;
    }

    public ArrayList<String> getScanInfo(int[] capabilities) {
        ArrayList<String> list = new ArrayList<String>(16);
        for (Map.Entry e : this.entrySet()) {
            ((EMInstanceStack)e.getValue()).addScanResults(list, capabilities);
        }
        return list;
    }

    public double tickContent(double lifeTimeMult, int postEnergize, double seconds) {
        double diff = 0.0;
        for (EMInstanceStack instance : this.takeAllToArray()) {
            instance.setAge(instance.getAge() + seconds);
            EMDecayResult newInstances = instance.decay(lifeTimeMult, instance.getAge(), postEnergize);
            if (newInstances == null) {
                this.putUnify(instance);
                continue;
            }
            diff = DoubleCount.add(diff, newInstances.getMassDiff());
            this.putUnifyAll(newInstances.getOutput());
        }
        return diff;
    }

    public static EMInstanceStackMap fromNBT(EMDefinitionsRegistry registry, NBTTagCompound nbt) throws EMException {
        return new EMInstanceStackMap(false, TT_Utility.unpackNBT(EMInstanceStack.class, inner -> EMInstanceStack.fromNBT(registry, inner), nbt));
    }

    public String toString() {
        StringBuilder build = new StringBuilder("Instance Stack Map\n");
        for (Map.Entry stack : this.entrySet()) {
            build.append(((EMInstanceStack)stack.getValue()).toString()).append('\n');
        }
        return build.toString();
    }

    public EMInstanceStack[] takeAllToArray() {
        EMInstanceStack[] newStack = (EMInstanceStack[])this.valuesToArray();
        this.clear();
        return newStack;
    }

    public EMInstanceStackMap takeAll() {
        EMInstanceStackMap newStack = new EMInstanceStackMap(false, new TreeMap<IEMDefinition, EMInstanceStack>(this.getBackingMap()));
        this.clear();
        return newStack;
    }

    @Deprecated
    public EMDefinitionStackMap toDefinitionMapForComparison() {
        EMDefinitionStack[] list = new EMDefinitionStack[this.size()];
        int i = 0;
        for (Map.Entry entry : this.entrySet()) {
            EMInstanceStack value = (EMInstanceStack)entry.getValue();
            list[i++] = new EMDefinitionStack(value.getDefinition(), value.getAmount());
        }
        return new EMDefinitionStackMap(list);
    }

    @Override
    public EMInstanceStack putUnify(EMInstanceStack stack) {
        EMInstanceStack target = (EMInstanceStack)this.get(stack.getDefinition());
        if (target == null) {
            this.putReplace(stack);
            return stack;
        }
        double newAmount = DoubleCount.add(target.getAmount(), stack.getAmount());
        if (IEMStack.isValidAmount(newAmount)) {
            stack = target.unifyIntoThis(stack);
            this.putReplace(stack);
            return stack;
        }
        this.removeKey(stack.getDefinition());
        return null;
    }

    @Override
    public EMInstanceStack putUnifyExact(EMInstanceStack stack) {
        EMInstanceStack target = (EMInstanceStack)this.get(stack.getDefinition());
        if (target == null) {
            this.putReplace(stack);
            return stack;
        }
        double newAmount = target.getAmount() + stack.getAmount();
        if (IEMStack.isValidAmount(newAmount)) {
            stack = target.unifyIntoThis(stack);
            this.putReplace(stack);
            return stack;
        }
        this.removeKey(stack.getDefinition());
        return null;
    }
}

