/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.transformations;

import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.IEMStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMFluidQuantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMItemQuantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMOredictQuantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.OreDictionaryStack;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_OreDictUnificator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class EMTransformationRegistry {
    public static final double AVOGADRO_CONSTANT = 6.02214076E23;
    public static final double EM_COUNT_PER_CUBE = 8.280443545E31;
    public static final double EM_COUNT_PER_MATERIAL_AMOUNT = 6.3892311304012354E28;
    public static final double EM_COUNT_PER_ITEM = 7.452399190500001E32;
    public static final double EM_COUNT_PER_1k = 6.389231130401236E31;
    public static final double EM_COUNT_MINIMUM = 1.2076647761264339E-32;
    public static final double EM_COUNT_EPSILON = 8.280443545E31 / Math.pow(2.0, 40.0);
    public static final double EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED = 6.3892311304012354E28 - EM_COUNT_EPSILON;
    public static final double EM_COUNT_PER_CUBE_DIMINISHED = EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED * 144.0 * 9.0;
    public static final double EM_COUNT_PER_ITEM_DIMINISHED = EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED * 144.0;
    public static final double EM_COUNT_PER_1k_DIMINISHED = EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED * 1000.0;
    private final Map<Integer, EMFluidQuantizationInfo> fluidQuantization;
    private final Map<EMItemQuantizationInfo, EMItemQuantizationInfo> itemQuantization;
    private final Map<Integer, EMOredictQuantizationInfo> oredictQuantization;
    private final Map<IEMDefinition, EMDequantizationInfo> infoMap;
    private final Function<IEMStack, EMDequantizationInfo> creator;

    public EMTransformationRegistry() {
        this(EMDequantizationInfo::new);
    }

    public EMTransformationRegistry(Function<IEMStack, EMDequantizationInfo> creator) {
        this(creator, new HashMap<Integer, EMFluidQuantizationInfo>(16), new HashMap<EMItemQuantizationInfo, EMItemQuantizationInfo>(16), new HashMap<Integer, EMOredictQuantizationInfo>(64), new HashMap<IEMDefinition, EMDequantizationInfo>(256));
    }

    public EMTransformationRegistry(Function<IEMStack, EMDequantizationInfo> creator, Map<Integer, EMFluidQuantizationInfo> fluidQuantization, Map<EMItemQuantizationInfo, EMItemQuantizationInfo> itemQuantization, Map<Integer, EMOredictQuantizationInfo> oredictQuantization, Map<IEMDefinition, EMDequantizationInfo> infoMap) {
        this.creator = creator;
        this.fluidQuantization = fluidQuantization;
        this.itemQuantization = itemQuantization;
        this.oredictQuantization = oredictQuantization;
        this.infoMap = infoMap;
    }

    protected EMDequantizationInfo compute(IEMStack em) {
        return this.infoMap.computeIfAbsent(em.getDefinition(), stack -> this.creator.apply(em));
    }

    public void addFluid(IEMStack em, FluidStack fluidStack) {
        this.getFluidQuantization().put(fluidStack.getFluidID(), new EMFluidQuantizationInfo(fluidStack, em));
        this.compute(em).setFluid(fluidStack);
    }

    public void addFluid(IEMStack em, Fluid fluid, int fluidAmount) {
        this.addFluid(em, new FluidStack(fluid, fluidAmount));
    }

    protected void addItemQuantization(EMItemQuantizationInfo aIQI) {
        this.getItemQuantization().put(aIQI, aIQI);
    }

    public void addItem(IEMStack em, ItemStack itemStack, boolean skipNBT) {
        this.addItemQuantization(new EMItemQuantizationInfo(itemStack, skipNBT, em));
        this.compute(em).setItem(itemStack);
    }

    public void addItem(IEMStack em, OrePrefixes prefix, Materials material, int amount, boolean skipNBT) {
        this.addItem(em, GT_OreDictUnificator.get((OrePrefixes)prefix, (Object)material, (long)amount), skipNBT);
    }

    public void addOredict(IEMStack em, int id, int qty) {
        this.getOredictQuantization().put(id, new EMOredictQuantizationInfo(id, qty, em));
        this.compute(em).setOre(new OreDictionaryStack(qty, id));
    }

    public void addOredict(IEMStack em, String name, int qty) {
        this.addOredict(em, OreDictionary.getOreID((String)name), qty);
    }

    public void addOredict(IEMStack em, OrePrefixes prefix, Materials material, int qty) {
        this.addOredict(em, prefix, material.mName, qty);
    }

    public void addOredict(IEMStack em, OrePrefixes prefix, String materialName, int qty) {
        this.addOredict(em, OreDictionary.getOreID((String)(prefix.name() + materialName)), qty);
    }

    public Map<Integer, EMFluidQuantizationInfo> getFluidQuantization() {
        return this.fluidQuantization;
    }

    public Map<EMItemQuantizationInfo, EMItemQuantizationInfo> getItemQuantization() {
        return this.itemQuantization;
    }

    public Map<Integer, EMOredictQuantizationInfo> getOredictQuantization() {
        return this.oredictQuantization;
    }

    public Map<IEMDefinition, EMDequantizationInfo> getInfoMap() {
        return this.infoMap;
    }
}

